/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import codechicken.lib.math.MathHelper;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.shapes.Rectangle;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.api.widget.scroll.IHorizontalScrollable;
import com.gtnewhorizons.modularui.api.widget.scroll.IVerticalScrollable;
import com.gtnewhorizons.modularui.api.widget.scroll.ScrollType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollBar
extends Widget
implements Interactable {
    private ScrollType scrollType;
    private IVerticalScrollable verticalScrollable;
    private IHorizontalScrollable horizontalScrollable;
    private IDrawable barTexture = IDrawable.EMPTY;
    private int handleClickOffset = -1;
    private int posOffset = 0;

    public static ScrollBar defaultTextScrollBar() {
        return new ScrollBar().setBarTexture(new Rectangle().setColor(Color.WHITE.normal).setCornerRadius(1));
    }

    public void setScrollType(ScrollType scrollType, @Nullable IHorizontalScrollable horizontalScrollable, @Nullable IVerticalScrollable verticalScrollable) {
        this.scrollType = scrollType;
        this.verticalScrollable = verticalScrollable;
        this.horizontalScrollable = horizontalScrollable;
    }

    @Override
    public void onInit() {
        if (this.scrollType == ScrollType.VERTICAL && this.verticalScrollable == null || this.scrollType == ScrollType.HORIZONTAL && this.horizontalScrollable == null) {
            throw new IllegalStateException("Scroll bar was not properly initialized");
        }
        if (this.isAutoSized()) {
            this.setSizeProvider((screenSize, window, parent) -> {
                if (this.scrollType == ScrollType.HORIZONTAL) {
                    return new Size(this.horizontalScrollable.getVisibleWidth(), this.horizontalScrollable.getHorizontalBarHeight());
                }
                if (this.scrollType == ScrollType.VERTICAL) {
                    return new Size(this.verticalScrollable.getVerticalBarWidth(), this.verticalScrollable.getVisibleHeight());
                }
                return Size.ZERO;
            });
        }
        if (this.isAutoPositioned()) {
            this.setPosProvider((screenSize, window, parent) -> {
                if (this.scrollType == ScrollType.HORIZONTAL) {
                    return new Pos2d(0, parent.getSize().height - this.horizontalScrollable.getHorizontalBarHeight() + this.posOffset);
                }
                if (this.scrollType == ScrollType.VERTICAL) {
                    return new Pos2d(parent.getSize().width - this.verticalScrollable.getVerticalBarWidth() + this.posOffset, 0);
                }
                return Pos2d.ZERO;
            });
        }
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        if (this.scrollType == ScrollType.HORIZONTAL) {
            return new Size(this.horizontalScrollable.getVisibleWidth(), this.horizontalScrollable.getHorizontalBarHeight());
        }
        if (this.scrollType == ScrollType.VERTICAL) {
            return new Size(this.verticalScrollable.getVerticalBarWidth(), this.verticalScrollable.getVisibleHeight());
        }
        return super.determineSize(maxWidth, maxHeight);
    }

    public int getVisibleSize() {
        if (this.scrollType == ScrollType.HORIZONTAL) {
            return this.horizontalScrollable.getVisibleWidth();
        }
        if (this.scrollType == ScrollType.VERTICAL) {
            return this.verticalScrollable.getVisibleHeight();
        }
        return 0;
    }

    public int getActualSize() {
        if (this.scrollType == ScrollType.HORIZONTAL) {
            return this.horizontalScrollable.getActualWidth();
        }
        if (this.scrollType == ScrollType.VERTICAL) {
            return this.verticalScrollable.getActualHeight();
        }
        return 0;
    }

    public boolean isActive() {
        int actualSize = this.getActualSize();
        return actualSize > 0 && actualSize > this.getVisibleSize();
    }

    @Override
    public void draw(float partialTicks) {
        if (this.isActive() && this.barTexture != null) {
            int size = this.calculateMainAxisSize();
            if (this.scrollType == ScrollType.HORIZONTAL) {
                float offset = (float)this.horizontalScrollable.getHorizontalScrollOffset() / (float)this.horizontalScrollable.getActualWidth();
                this.barTexture.draw((float)this.horizontalScrollable.getVisibleWidth() * offset, 0.0f, size, this.horizontalScrollable.getHorizontalBarHeight(), partialTicks);
            } else if (this.scrollType == ScrollType.VERTICAL) {
                float offset = (float)this.verticalScrollable.getVerticalScrollOffset() / (float)this.verticalScrollable.getActualHeight();
                this.barTexture.draw(0.0f, (float)this.verticalScrollable.getVisibleHeight() * offset, this.verticalScrollable.getVerticalBarWidth(), size, partialTicks);
            }
        }
    }

    public int calculateMainAxisSize() {
        int actualSize = this.getActualSize();
        if (actualSize == 0) {
            return 1;
        }
        int size = this.getVisibleSize();
        return (int)Math.max((double)size / (double)actualSize * (double)size, 6.0);
    }

    public void clampScrollOffset() {
        this.setScrollOffset(this.getScrollOffset());
    }

    public void setScrollOffsetOfCursor(float x) {
        int visible = this.getVisibleSize();
        this.setScrollOffset((int)(x - (float)visible / 2.0f));
    }

    public void setScrollOffset(int offset) {
        offset = (int)MathHelper.clip((double)offset, (double)0.0, (double)(this.getActualSize() - this.getVisibleSize()));
        if (this.scrollType == ScrollType.HORIZONTAL) {
            this.horizontalScrollable.setHorizontalScrollOffset(offset);
        } else if (this.scrollType == ScrollType.VERTICAL) {
            this.verticalScrollable.setVerticalScrollOffset(offset);
        }
    }

    public int getScrollOffset() {
        if (this.scrollType == ScrollType.HORIZONTAL) {
            return this.horizontalScrollable.getHorizontalScrollOffset();
        }
        if (this.scrollType == ScrollType.VERTICAL) {
            return this.verticalScrollable.getVerticalScrollOffset();
        }
        return 0;
    }

    public int getBarSize() {
        if (this.scrollType == ScrollType.HORIZONTAL) {
            return this.horizontalScrollable.getHorizontalBarHeight();
        }
        if (this.scrollType == ScrollType.VERTICAL) {
            return this.verticalScrollable.getVerticalBarWidth();
        }
        return 0;
    }

    @Override
    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        Pos2d relative = this.getContext().getCursor().getPos().subtract(this.getAbsolutePos());
        int barSize = this.calculateMainAxisSize();
        int actualSize = this.getActualSize();
        if (this.scrollType == ScrollType.HORIZONTAL) {
            float offset = (float)this.horizontalScrollable.getHorizontalScrollOffset() / (float)actualSize * (float)this.horizontalScrollable.getVisibleWidth();
            if ((float)relative.x >= offset && (float)relative.x <= offset + (float)barSize) {
                this.handleClickOffset = (int)((float)relative.x - offset);
            } else {
                float newOffset = Math.max(0.0f, ((float)relative.x - (float)barSize / 2.0f) / (float)this.horizontalScrollable.getVisibleWidth());
                this.setScrollOffset((int)(newOffset * (float)actualSize));
            }
        } else if (this.scrollType == ScrollType.VERTICAL) {
            float offset = (float)this.verticalScrollable.getVerticalScrollOffset() / (float)actualSize * (float)this.verticalScrollable.getVisibleHeight();
            if ((float)relative.y >= offset && (float)relative.y <= offset + (float)barSize) {
                this.handleClickOffset = (int)((float)relative.y - offset);
            } else {
                float newOffset = Math.max(0.0f, ((float)relative.y - (float)barSize / 2.0f) / (float)this.verticalScrollable.getVisibleHeight());
                this.setScrollOffset((int)(newOffset * (float)actualSize));
            }
        }
        return Interactable.ClickResult.ACCEPT;
    }

    @Override
    public void onMouseDragged(int buttonId, long deltaTime) {
        if (this.handleClickOffset >= 0) {
            int actualSize = this.getActualSize();
            if (this.scrollType == ScrollType.HORIZONTAL) {
                int offset = this.getContext().getCursor().getX() - this.pos.x - this.handleClickOffset;
                float newOffset = Math.max(0.0f, (float)offset / (float)this.horizontalScrollable.getVisibleWidth());
                this.setScrollOffset((int)(newOffset * (float)actualSize));
            } else if (this.scrollType == ScrollType.VERTICAL) {
                int offset = this.getContext().getCursor().getY() - this.pos.y - this.handleClickOffset;
                float newOffset = Math.max(0.0f, (float)offset / (float)this.verticalScrollable.getVisibleHeight());
                this.setScrollOffset((int)(newOffset * (float)actualSize));
            }
        }
    }

    @Override
    public boolean onClickReleased(int buttonId) {
        if (this.handleClickOffset >= 0) {
            this.handleClickOffset = -1;
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseScroll(int direction) {
        if (this.isActive()) {
            this.setScrollOffset(this.getScrollOffset() - direction * 6);
        }
        return true;
    }

    public ScrollBar setBarTexture(IDrawable barTexture) {
        this.barTexture = barTexture;
        return this;
    }

    public ScrollBar setPosOffset(int posOffset) {
        this.posOffset = posOffset;
        return this;
    }
}

