/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import kubatech.config.Config;
import kubatech.config.OverridesConfig;
import kubatech.kubatech;
import kubatech.loaders.MobRecipeLoader;

public class LoadConfigPacket
implements IMessage {
    public static final LoadConfigPacket instance = new LoadConfigPacket();
    public final HashSet<String> mobsToLoad = new HashSet();
    public final HashMap<String, OverridesConfig.MobOverride> mobsOverrides = new HashMap();

    public void fromBytes(ByteBuf buf) {
        if (!buf.readBoolean()) {
            this.mobsToLoad.clear();
        } else {
            this.mobsToLoad.clear();
            int mobssize = buf.readInt();
            for (int i = 0; i < mobssize; ++i) {
                byte[] sbytes = new byte[buf.readInt()];
                buf.readBytes(sbytes);
                this.mobsToLoad.add(new String(sbytes, StandardCharsets.UTF_8));
            }
            int overridessize = buf.readInt();
            for (int i = 0; i < overridessize; ++i) {
                byte[] sbytes = new byte[buf.readInt()];
                buf.readBytes(sbytes);
                this.mobsOverrides.put(new String(sbytes, StandardCharsets.UTF_8), OverridesConfig.MobOverride.readFromByteBuf(buf));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        if (!Config.MobHandler.mobHandlerEnabled) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeInt(this.mobsToLoad.size());
            this.mobsToLoad.forEach(s -> {
                byte[] sbytes = s.getBytes(StandardCharsets.UTF_8);
                buf.writeInt(sbytes.length);
                buf.writeBytes(sbytes);
            });
            buf.writeInt(this.mobsOverrides.size());
            this.mobsOverrides.forEach((k, v) -> {
                byte[] sbytes = k.getBytes(StandardCharsets.UTF_8);
                buf.writeInt(sbytes.length);
                buf.writeBytes(sbytes);
                v.writeToByteBuf(buf);
            });
        }
    }

    public static class Handler
    implements IMessageHandler<LoadConfigPacket, IMessage> {
        public IMessage onMessage(LoadConfigPacket message, MessageContext ctx) {
            kubatech.info("Received Mob Handler config, parsing");
            MobRecipeLoader.processMobRecipeMap(message.mobsToLoad, message.mobsOverrides);
            return null;
        }
    }
}

