/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.blocks.RenderQuartzTorch;
import appeng.core.features.AEFeature;
import appeng.helpers.ICustomCollision;
import appeng.helpers.MetaRotation;
import appeng.tile.misc.TileLightDetector;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLightDetector
extends AEBaseTileBlock
implements IOrientableBlock,
ICustomCollision {
    public BlockLightDetector() {
        super(Material.field_151594_q);
        this.func_149713_g(0);
        this.isFullSize = false;
        this.isOpaque = false;
        this.setTileEntity(TileLightDetector.class);
        this.setFeature(EnumSet.of(AEFeature.LightDetector));
    }

    public int func_149709_b(IBlockAccess w, int x, int y, int z, int side) {
        if (w instanceof World && ((TileLightDetector)this.getTileEntity(w, x, y, z)).isReady()) {
            return ((World)w).func_72957_l(x, y, z) - 6;
        }
        return 0;
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        super.onNeighborChange(world, x, y, z, tileX, tileY, tileZ);
        TileLightDetector tld = (TileLightDetector)this.getTileEntity(world, x, y, z);
        if (tld != null) {
            tld.updateLight();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World w, int x, int y, int z, Random r) {
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderQuartzTorch getRenderer() {
        return new RenderQuartzTorch();
    }

    @Override
    public boolean isValidOrientation(World w, int x, int y, int z, ForgeDirection forward, ForgeDirection up) {
        return this.canPlaceAt(w, x, y, z, up.getOpposite());
    }

    private boolean canPlaceAt(World w, int x, int y, int z, ForgeDirection dir) {
        return w.isSideSolid(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite(), false);
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, int x, int y, int z, Entity e, boolean isVisual) {
        ForgeDirection up = this.getOrientable((IBlockAccess)w, x, y, z).getUp();
        double xOff = -0.3 * (double)up.offsetX;
        double yOff = -0.3 * (double)up.offsetY;
        double zOff = -0.3 * (double)up.offsetZ;
        return Collections.singletonList(AxisAlignedBB.func_72330_a((double)(xOff + 0.3), (double)(yOff + 0.3), (double)(zOff + 0.3), (double)(xOff + 0.7), (double)(yOff + 0.7), (double)(zOff + 0.7)));
    }

    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List out, Entity e) {
    }

    public void func_149695_a(World w, int x, int y, int z, Block id) {
        ForgeDirection up = this.getOrientable((IBlockAccess)w, x, y, z).getUp();
        if (!this.canPlaceAt(w, x, y, z, up.getOpposite())) {
            this.dropTorch(w, x, y, z);
        }
    }

    private void dropTorch(World w, int x, int y, int z) {
        w.func_147480_a(x, y, z, true);
        w.func_147471_g(x, y, z);
    }

    public boolean func_149742_c(World w, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.canPlaceAt(w, x, y, z, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean usesMetadata() {
        return true;
    }

    @Override
    public IOrientable getOrientable(IBlockAccess w, int x, int y, int z) {
        return new MetaRotation(w, x, y, z);
    }
}

