/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.element;

import forge.com.gitlab.cdagaming.craftpresence.config.Module;
import forge.com.gitlab.cdagaming.craftpresence.config.element.PresenceData;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.io.Serializable;

public class ModuleData
extends Module
implements Serializable {
    private static final long serialVersionUID = -5846802181463006850L;
    private static final ModuleData DEFAULT = new ModuleData();
    private String textOverride;
    private String iconOverride;
    private PresenceData data;

    public ModuleData(String textOverride, String iconOverride, PresenceData data) {
        this.setTextOverride(textOverride);
        this.setIconOverride(iconOverride);
        this.setData(data);
    }

    public ModuleData(ModuleData other) {
        this(other.textOverride, other.iconOverride, other.data);
    }

    public ModuleData(String textOverride, String iconOverride) {
        this(textOverride, iconOverride, null);
    }

    public ModuleData() {
        this(null, null);
    }

    @Override
    public ModuleData getDefaults() {
        return new ModuleData(DEFAULT);
    }

    @Override
    public ModuleData copy() {
        return new ModuleData(this);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof ModuleData && !this.equals(target)) {
            ModuleData data = (ModuleData)target;
            this.setTextOverride(data.getTextOverride());
            this.setIconOverride(data.getIconOverride());
            this.setData(data.getData());
        }
    }

    public String getTextOverride() {
        return this.textOverride;
    }

    public ModuleData setTextOverride(String textOverride) {
        this.textOverride = textOverride;
        return this;
    }

    public String getIconOverride() {
        return this.iconOverride;
    }

    public ModuleData setIconOverride(String iconOverride) {
        this.iconOverride = iconOverride;
        return this;
    }

    public PresenceData getData() {
        return this.data != null ? new PresenceData(this.data) : null;
    }

    public ModuleData setData(PresenceData data) {
        if (data != null) {
            this.data = new PresenceData(data);
        }
        return this;
    }

    @Override
    public Object getProperty(String name) {
        return StringUtils.getField(ModuleData.class, (Object)this, name);
    }

    @Override
    public void setProperty(String name, Object value) {
        StringUtils.updateField(ModuleData.class, (Object)this, value, name);
    }
}

