/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.integrations.versioning;

public class VersionTokenizer {
    private final String versionString;
    private final int length;
    private int position;
    private int number;
    private String suffix;
    private boolean hasValue;

    public VersionTokenizer(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("versionString is null");
        }
        this.versionString = versionString;
        this.length = versionString.length();
    }

    public int getNumber() {
        return this.number;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public boolean next() {
        char c;
        char c2;
        this.number = 0;
        this.suffix = "";
        this.hasValue = false;
        if (this.position >= this.length) {
            return false;
        }
        this.hasValue = true;
        while (this.position < this.length && (c2 = this.versionString.charAt(this.position)) >= '0' && c2 <= '9') {
            this.number = this.number * 10 + (c2 - 48);
            ++this.position;
        }
        int suffixStart = this.position;
        while (this.position < this.length && (c = this.versionString.charAt(this.position)) != '.') {
            ++this.position;
        }
        this.suffix = this.versionString.substring(suffixStart, this.position);
        if (this.position < this.length) {
            ++this.position;
        }
        return true;
    }
}

