/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.integrations.pack.multimc;

import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.pack.Pack;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.SystemUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;

public class MultiMCUtils
extends Pack {
    public MultiMCUtils() {
        this.setPackType(this.getLauncherType());
    }

    @Override
    public boolean isEnabled() {
        return CraftPresence.CONFIG.generalSettings.detectMultiMCManifest;
    }

    @Override
    public boolean load() {
        return this.findWithSystem() || this.findWithLegacy();
    }

    @Override
    public void setPackIcon(String packIcon) {
        super.setPackIcon(this.parseIcon(packIcon));
    }

    private String parseIcon(String original) {
        String defaultIcon = this.getDefaultIcon();
        if (StringUtils.isNullOrEmpty(original)) {
            return defaultIcon;
        }
        return !original.equals("default") ? original : defaultIcon;
    }

    private String getDefaultIcon() {
        if (Objects.equals(this.getPackType(), "prism")) {
            return "prismlauncher";
        }
        return "infinity";
    }

    private boolean findWithSystem() {
        block2: {
            try {
                this.setPackData(System.getProperty("multimc.instance.title"), System.getProperty("multimc.instance.icon"));
            }
            catch (Exception ex) {
                if (!this.showException(ex)) break block2;
                ex.printStackTrace();
            }
        }
        return this.hasPackName() && this.hasPackIcon();
    }

    private boolean findWithLegacy() {
        block9: {
            Path instanceFile = Paths.get(new File(SystemUtils.USER_DIR).getParent() + File.separator + "instance.cfg", new String[0]);
            if (Files.exists(instanceFile, new LinkOption[0])) {
                try (InputStream inputStream = Files.newInputStream(instanceFile, new OpenOption[0]);){
                    Properties configFile = new Properties();
                    configFile.load(inputStream);
                    this.setPackData(configFile.getProperty("name"), configFile.getProperty("iconKey"));
                }
                catch (Exception ex) {
                    if (!this.showException(ex)) break block9;
                    ex.printStackTrace();
                }
            }
        }
        return this.hasPackName() && this.hasPackIcon();
    }

    private String getLauncherType() {
        File prismLocation = new File(new File(SystemUtils.USER_DIR).getParentFile().getParentFile().getParentFile() + File.separator + "prismlauncher.cfg");
        if (prismLocation.exists()) {
            return "prism";
        }
        return "multimc";
    }
}

