/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config.migration;

import com.google.gson.JsonElement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import external.me.hypherionmc.moonconfig.core.AbstractConfig;
import external.me.hypherionmc.moonconfig.core.UnmodifiableConfig;
import external.me.hypherionmc.moonconfig.core.file.FileConfig;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.Button;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.PresenceData;
import fabric.com.gitlab.cdagaming.craftpresence.config.migration.DataMigrator;
import fabric.com.gitlab.cdagaming.craftpresence.impl.HashMapBuilder;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_1809;
import net.minecraft.class_1814;
import net.minecraft.class_376;
import net.minecraft.class_483;

public class HypherConverter
implements DataMigrator {
    private static final int LOWEST_SUPPORTED = 13;
    private static final String EMPTY_QUOTES = "{''}";
    private final int fileVersion;
    private final String configPath;
    private final String serverEntriesPath;
    private final String replayModPath;
    private final Map<String, String> placeholderMappings = new HashMapBuilder<String, String>().put("%player%", "{player.name}").put("%world%", "{dimension.name}").put("%mods%", "{general.mods}").put("%difficulty%", "{world.difficulty}").put("%position%", "{custom.player_info_coordinate}").put("%biome%", "{biome.name}").put("%mcver%", "{general.version}").put("%instance%", "{pack.name}").put("%launcher%", "{general.brand}").put("%server%", "{replace(server.address.short, '.', '_')}").put("%launchername%", "{toLower(general.brand)}").put("%savename%", "{world.name}").put("%playerhead%", "{player.icon}").put("%gametime12%", "{world.time.format_12}").put("%gametime%", "{world.time.format_24}").put("%day%", "{world.day}").put("%weather%", "{world.weather.name}").put("%replayframe%", "{replaymod.frames.current}").put("%replaytotal%", "{replaymod.frames.total}").put("%replaytime%", "{replaymod.time.current}").put("%replaytimeleft%", "{replaymod.time.remaining").put("%serverip%", "{server.address.short}").put("%servername%", "{server.name}").put("%players%", "{server.players.current}").put("%playersexcl%", "{server.players.current - 1}").put("%maxplayers%", "{server.players.max}").put("%motd%", "{server.motd.raw}").put("%servericon%", "{server.icon}").put("%realmname%", "{''}").put("%realmdescription%", "{''}").put("%realmgame%", "{''}").put("%realmicon%", "{''}").build();
    private int configVersion = -1;
    private int serverEntryVersion = -1;
    private int replayModVersion = -1;

    public HypherConverter(Map.Entry<Integer, String> entry) {
        this.fileVersion = entry.getKey();
        this.configPath = entry.getValue() + "simple-rpc.toml";
        this.serverEntriesPath = entry.getValue() + "server-entries.toml";
        this.replayModPath = entry.getValue() + "simple-rpc-replaymod.toml";
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public Config apply(Config instance, JsonElement rawJson, Object ... args) {
        File replayModFile;
        ModUtils.LOG.info("Simple RPC (By: HypherionSA) config data found, attempting to migrate settings to CraftPresence...", new Object[0]);
        try (FileConfig conf = FileConfig.of(this.configPath);){
            Object dimensionList;
            boolean launcherIntegration;
            conf.load();
            this.configVersion = (Integer)conf.get("general.version");
            ModUtils.LOG.debugInfo("Main Config file found (Version: %d, File Version: %d), interpreting data...", this.configVersion, this.fileVersion);
            if (this.configVersion < 13) {
                ModUtils.LOG.error("You are using an outdated Simple RPC config file (Must be at least v%d, you have v%d), skipping...", 13, this.configVersion);
                Config config = instance;
                return config;
            }
            Object clientId = this.getProperty(conf, "general.applicationID", "general.clientID");
            if (clientId != null) {
                instance.generalSettings.clientId = clientId.toString();
            }
            instance.advancedSettings.debugMode = (Boolean)conf.get("general.debugging");
            instance.generalSettings.detectATLauncherInstance = launcherIntegration = ((Boolean)conf.get("general.launcherIntegration")).booleanValue();
            instance.generalSettings.detectCurseManifest = launcherIntegration;
            instance.generalSettings.detectMCUpdaterInstance = launcherIntegration;
            instance.generalSettings.detectTechnicPack = launcherIntegration;
            instance.generalSettings.detectMultiMCManifest = launcherIntegration;
            boolean areOverridesEnabled = (Boolean)conf.get("dimension_overrides.enabled");
            if (conf.get("dimension_overrides.dimensions") != null && (dimensionList = conf.get("dimension_overrides.dimensions")) instanceof List) {
                for (Object entryObj : (List)conf.get("dimension_overrides.dimensions")) {
                    if (!(entryObj instanceof AbstractConfig)) continue;
                    AbstractConfig entry = (AbstractConfig)entryObj;
                    String name = entry.get("name").toString();
                    boolean isBiome = name.startsWith("biome:");
                    if (isBiome) {
                        name = name.replaceFirst("biome:", "");
                    }
                    ModuleData data = new ModuleData().setData(this.convertPresenceData(entry, areOverridesEnabled, true));
                    (isBiome ? instance.biomeSettings.biomeData : instance.dimensionSettings.dimensionData).put(name, data);
                }
            }
            if (conf.get("custom.variables") instanceof List) {
                for (Object entryObj : (List)conf.get("custom.variables")) {
                    if (!(entryObj instanceof AbstractConfig)) continue;
                    AbstractConfig entry = (AbstractConfig)entryObj;
                    String name = entry.get("name").toString();
                    String value = entry.get("value").toString();
                    instance.displaySettings.dynamicVariables.put(name, this.processPlaceholder(value));
                }
            }
            instance.advancedSettings.enablePerGui = true;
            instance.advancedSettings.guiSettings.guiData.put(class_1809.class.getSimpleName(), new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("realms_list"))));
            instance.advancedSettings.guiSettings.guiData.put(class_376.class.getSimpleName(), new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("server_list"))));
            instance.advancedSettings.guiSettings.guiData.put(class_1814.class.getSimpleName(), new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("join_game"))));
            instance.advancedSettings.guiSettings.guiData.put(class_483.class.getSimpleName(), new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("join_game"))));
            instance.statusMessages.loadingData.setData(this.convertPresenceData((AbstractConfig)conf.get("init")));
            instance.statusMessages.mainMenuData.setData(this.convertPresenceData((AbstractConfig)conf.get("main_menu")));
            instance.statusMessages.singleplayerData.setData(this.convertPresenceData((AbstractConfig)conf.get("single_player"), !areOverridesEnabled));
            instance.serverSettings.serverData.get("default").setData(this.convertPresenceData((AbstractConfig)conf.get("multi_player"), !areOverridesEnabled));
            instance.displaySettings.presenceData = this.convertPresenceData((AbstractConfig)conf.get("generic"));
            instance.save();
        }
        File serverEntriesFile = new File(this.serverEntriesPath);
        if (serverEntriesFile.exists()) {
            try (FileConfig conf = FileConfig.of(serverEntriesFile);){
                conf.load();
                this.serverEntryVersion = (Integer)conf.get("version");
                ModUtils.LOG.debugInfo("Server Entries file found (Version: %d, File Version: %d), interpreting data...", this.serverEntryVersion, this.fileVersion);
                boolean areOverridesEnabled = (Boolean)conf.get("enabled");
                if (conf.get("entry") instanceof List) {
                    for (Object entryObj : (List)conf.get("entry")) {
                        if (!(entryObj instanceof AbstractConfig)) continue;
                        AbstractConfig entry = (AbstractConfig)entryObj;
                        instance.serverSettings.serverData.put((String)entry.get("ip"), new ModuleData().setData(this.convertPresenceData(entry, areOverridesEnabled, true)));
                    }
                }
                instance.save();
            }
        }
        if ((replayModFile = new File(this.replayModPath)).exists()) {
            try (FileConfig conf = FileConfig.of(replayModFile);){
                conf.load();
                this.replayModVersion = (Integer)conf.get("general.version");
                ModUtils.LOG.debugInfo("Replay Mod Integration file found (Version: %d, File Version: %d), interpreting data...", this.replayModVersion, this.fileVersion);
                instance.advancedSettings.enablePerGui = true;
                instance.advancedSettings.guiSettings.guiData.put("GuiReplayViewer", new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("replay_viewer"))));
                instance.advancedSettings.guiSettings.guiData.put("GuiReplayOverlay", new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("replay_editor"))));
                instance.advancedSettings.guiSettings.guiData.put("GuiVideoRenderer", new ModuleData().setData(this.convertPresenceData((AbstractConfig)conf.get("replay_render"))));
                instance.save();
            }
        }
        ModUtils.LOG.info("Migration complete, thanks for using our mods! ~~ CDAGaming and HypherionSA", new Object[0]);
        return instance;
    }

    private String processPlaceholder(String original, boolean addMetadata) {
        String result = original;
        if (addMetadata) {
            result = "'" + original + "'";
        }
        if (!StringUtils.isNullOrEmpty(result)) {
            for (Map.Entry<String, String> entry : this.placeholderMappings.entrySet()) {
                result = StringUtils.replace(result, entry.getKey(), entry.getValue(), false, false, true);
            }
        }
        return result;
    }

    private String processPlaceholder(String original) {
        return this.processPlaceholder(original, false);
    }

    private PresenceData convertPresenceData(AbstractConfig entry, boolean isEnabled, boolean useAsMain) {
        PresenceData data = new PresenceData();
        data.enabled = isEnabled;
        data.useAsMain = useAsMain;
        data.details = this.processPlaceholder((String)entry.get("description"));
        data.gameState = this.processPlaceholder((String)entry.get("state"));
        if (this.isActive(ConfigFlag.USE_IMAGE_POOLS)) {
            data.largeImageKey = this.combineData((List)entry.get("largeImageKey"));
            data.smallImageKey = this.combineData((List)entry.get("smallImageKey"));
        } else {
            data.largeImageKey = this.processPlaceholder((String)entry.get("largeImageKey"));
            data.smallImageKey = this.processPlaceholder((String)entry.get("smallImageKey"));
        }
        data.largeImageText = this.processPlaceholder((String)entry.get("largeImageText"));
        data.smallImageText = this.processPlaceholder((String)entry.get("smallImageText"));
        data.startTimestamp = "{data.general.time}";
        int buttonIndex = 1;
        if (entry.get("buttons") instanceof List) {
            for (Object buttonEntryObj : (List)entry.get("buttons")) {
                if (!(buttonEntryObj instanceof AbstractConfig)) continue;
                AbstractConfig buttonEntry = (AbstractConfig)buttonEntryObj;
                Button buttonData = new Button(this.processPlaceholder((String)buttonEntry.get("label")), this.processPlaceholder((String)buttonEntry.get("url")));
                data.addButton("button_" + buttonIndex, buttonData);
                ++buttonIndex;
            }
        }
        return data;
    }

    private String combineData(List<String> items) {
        StringBuilder dataBuilder = new StringBuilder();
        if (!items.isEmpty()) {
            if (items.size() > 1) {
                dataBuilder.append("{randomString(");
                for (int i = 0; i < items.size(); ++i) {
                    String output = this.processPlaceholder(items.get(i), true);
                    boolean hasExpr = Pattern.compile("\\{(.*?)}").matcher(output).find();
                    dataBuilder.append(hasExpr ? "getResult(" : "").append(output).append(hasExpr ? ")" : "");
                    if (i >= items.size() - 1) continue;
                    dataBuilder.append(",");
                }
                dataBuilder.append(")}");
            } else {
                dataBuilder.append(this.processPlaceholder(items.get(0)));
            }
        }
        return dataBuilder.toString();
    }

    private PresenceData convertPresenceData(AbstractConfig entry, boolean useAsMain) {
        return this.convertPresenceData(entry, entry.getOrElse("enabled", Boolean.valueOf(true)), useAsMain);
    }

    private PresenceData convertPresenceData(AbstractConfig entry) {
        return this.convertPresenceData(entry, true);
    }

    private boolean isActive(ConfigFlag flag) {
        return !(this.configVersion >= 0 && this.configVersion < flag.configVersion || this.serverEntryVersion >= 0 && this.serverEntryVersion < flag.serverEntryVersion || this.replayModVersion >= 0 && this.replayModVersion < flag.replayModVersion);
    }

    private Object getProperty(UnmodifiableConfig instance, String ... terms) {
        for (String term : terms) {
            if (!instance.contains(term)) continue;
            return instance.get(term);
        }
        return null;
    }

    private static enum ConfigFlag {
        USE_IMAGE_POOLS(17, 2, 1);

        private final int configVersion;
        private final int serverEntryVersion;
        private final int replayModVersion;

        private ConfigFlag(int configVersion, int serverEntryVersion, int replayModVersion) {
            this.configVersion = configVersion;
            this.serverEntryVersion = serverEntryVersion;
            this.replayModVersion = replayModVersion;
        }

        public String toString() {
            return "ConfigFlag[key=" + StringUtils.getOrDefault(this.name(), "N/A") + "; configVersion=" + this.configVersion + "; serverEntryVersion=" + this.serverEntryVersion + "; replayModVersion=" + this.replayModVersion + "]";
        }
    }
}

