/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config.category;

import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.Module;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.ColorData;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.ColorSection;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import java.io.Serializable;

public class Accessibility
extends Module
implements Serializable {
    private static final long serialVersionUID = -6804925684173174749L;
    private static final Accessibility DEFAULT = new Accessibility();
    public ColorData tooltipBackground = new ColorData(new ColorSection(16, 0, 16, 240));
    public ColorData tooltipBorder = new ColorData(new ColorSection(80, 0, 255, 80), new ColorSection(40, 0, 127, 80));
    public ColorData guiBackground = new ColorData(new ColorSection(64, 64, 64, 255), RenderUtils.DEFAULT_GUI_BACKGROUND);
    public ColorData worldGuiBackground = new ColorData(new ColorSection(16, 16, 16, 192), new ColorSection(16, 16, 16, 208));
    public ColorData buttonBackground = new ColorData(RenderUtils.DEFAULT_BUTTON_BACKGROUND);
    public String languageId;
    public boolean stripTranslationColors;
    public boolean showLoggingInChat;
    public boolean stripExtraGuiElements;
    public int configKeyCode;

    public Accessibility(Accessibility other) {
        this.languageId = ModUtils.TRANSLATOR.defaultLanguageId;
        this.stripTranslationColors = ModUtils.IS_TEXT_COLORS_BLOCKED;
        this.showLoggingInChat = false;
        this.stripExtraGuiElements = false;
        this.configKeyCode = ModUtils.MCProtocolID > 340 ? 96 : 41;
        this.transferFrom(other);
    }

    public Accessibility() {
        this.languageId = ModUtils.TRANSLATOR.defaultLanguageId;
        this.stripTranslationColors = ModUtils.IS_TEXT_COLORS_BLOCKED;
        this.showLoggingInChat = false;
        this.stripExtraGuiElements = false;
        this.configKeyCode = ModUtils.MCProtocolID > 340 ? 96 : 41;
    }

    @Override
    public Accessibility getDefaults() {
        return new Accessibility(DEFAULT);
    }

    @Override
    public Accessibility copy() {
        return new Accessibility(this);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof Accessibility && !this.equals(target)) {
            Accessibility data = (Accessibility)target;
            this.tooltipBackground = new ColorData(data.tooltipBackground);
            this.tooltipBorder = new ColorData(data.tooltipBorder);
            this.guiBackground = new ColorData(data.guiBackground);
            this.worldGuiBackground = new ColorData(data.worldGuiBackground);
            this.buttonBackground = new ColorData(data.buttonBackground);
            this.languageId = data.languageId;
            this.stripTranslationColors = data.stripTranslationColors;
            this.showLoggingInChat = data.showLoggingInChat;
            this.stripExtraGuiElements = data.stripExtraGuiElements;
            this.configKeyCode = data.configKeyCode;
        }
    }

    @Override
    public Object getProperty(String name) {
        return StringUtils.getField(Accessibility.class, (Object)this, name);
    }

    @Override
    public void setProperty(String name, Object value) {
        StringUtils.updateField(Accessibility.class, (Object)this, value, name);
    }
}

