/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.gui.GuiContainerBaseEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.vat.GuiVat;
import crazypants.enderio.machine.vat.VatRecipeManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class VatRecipeHandler
extends TemplateRecipeHandler {
    private Rectangle inTankBounds = new Rectangle(25, 1, 15, 47);
    private Rectangle outTankBounds = new Rectangle(127, 1, 15, 47);

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"enderio.nei.vat");
    }

    public String getGuiTexture() {
        return GuiContainerBaseEIO.getGuiTexture("vat").toString();
    }

    public PositionedStack getResult() {
        return null;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiVat.class;
    }

    public String getOverlayIdentifier() {
        return "EnderIOVat";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(149, 32, 16, 16), "EnderIOVat", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("liquid")) {
            this.loadCraftingRecipes((FluidStack)results[0]);
        } else if (outputId.equals("EnderIOVat") && ((Object)((Object)this)).getClass() == VatRecipeHandler.class) {
            List<IRecipe> recipes = VatRecipeManager.getInstance().getRecipes();
            for (IRecipe recipe : recipes) {
                FluidStack output = recipe.getOutputs()[0].getFluidOutput();
                InnerVatRecipe res = new InnerVatRecipe(recipe.getEnergyRequired(), recipe.getInputs(), output);
                this.arecipes.add(res);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack fluid = FluidUtil.getFluidFromItem((ItemStack)result);
        if (fluid != null) {
            this.loadCraftingRecipes(fluid);
        }
    }

    public void loadCraftingRecipes(FluidStack result) {
        List<IRecipe> recipes = VatRecipeManager.getInstance().getRecipes();
        for (IRecipe recipe : recipes) {
            FluidStack output = recipe.getOutputs()[0].getFluidOutput();
            if (!output.isFluidEqual(result)) continue;
            InnerVatRecipe res = new InnerVatRecipe(recipe.getEnergyRequired(), recipe.getInputs(), output);
            this.arecipes.add(res);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("liquid")) {
            this.loadUsageRecipes((FluidStack)ingredients[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        FluidStack fluid = FluidUtil.getFluidFromItem((ItemStack)ingredient);
        if (fluid != null) {
            this.loadUsageRecipes(fluid);
        }
        List<IRecipe> recipes = VatRecipeManager.getInstance().getRecipes();
        for (IRecipe recipe : recipes) {
            if (!recipe.isValidInput(0, ingredient) && !recipe.isValidInput(1, ingredient)) continue;
            FluidStack output = recipe.getOutputs()[0].getFluidOutput();
            InnerVatRecipe res = new InnerVatRecipe(recipe.getEnergyRequired(), recipe.getInputs(), output);
            res.setIngredientPermutation(res.inputs, ingredient);
            this.arecipes.add(res);
        }
    }

    public void loadUsageRecipes(FluidStack ingredient) {
        List<IRecipe> recipes = VatRecipeManager.getInstance().getRecipes();
        for (IRecipe recipe : recipes) {
            if (!recipe.isValidInput(ingredient)) continue;
            FluidStack output = recipe.getOutputs()[0].getFluidOutput();
            InnerVatRecipe res = new InnerVatRecipe(recipe.getEnergyRequired(), recipe.getInputs(), output);
            this.arecipes.add(res);
        }
    }

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)22, (int)0, (int)27, (int)11, (int)123, (int)52);
    }

    public void drawExtras(int recipeIndex) {
        InnerVatRecipe rec = (InnerVatRecipe)((Object)this.arecipes.get(recipeIndex));
        if (rec.inFluid != null && rec.inFluid.getFluid() != null) {
            RenderUtil.renderGuiTank((FluidStack)rec.inFluid, (int)((InnerVatRecipe)rec).inFluid.amount, (int)((InnerVatRecipe)rec).inFluid.amount, (double)this.inTankBounds.x, (double)this.inTankBounds.y, (double)0.0, (double)this.inTankBounds.width, (double)this.inTankBounds.height);
        }
        if (rec.result != null && rec.result.getFluid() != null) {
            RenderUtil.renderGuiTank((FluidStack)rec.result, (int)((InnerVatRecipe)rec).result.amount, (int)((InnerVatRecipe)rec).result.amount, (double)this.outTankBounds.x, (double)this.outTankBounds.y, (double)0.0, (double)this.outTankBounds.width, (double)this.outTankBounds.height);
        }
        String energyString = PowerDisplayUtil.formatPower(rec.energy) + " " + PowerDisplayUtil.abrevation();
        GuiDraw.drawStringC((String)energyString, (int)86, (int)54, (int)0x808080, (boolean)false);
        Fluid outputFluid = rec.result.getFluid();
        List<PositionedStack> stacks = rec.getIngredients();
        for (PositionedStack ps : stacks) {
            float mult = VatRecipeManager.getInstance().getMultiplierForInput(rec.inFluid.getFluid(), ps.item, outputFluid);
            String str = "x" + mult;
            GuiDraw.drawStringC((String)str, (int)(ps.relx + 8), (int)(ps.rely + 19), (int)0x808080, (boolean)false);
        }
        int x = 149;
        int y = 32;
        EnderWidget.map.render((IWidgetIcon)EnderWidget.BUTTON, (double)x, (double)y, 16.0, 16.0, 0.0, true);
        IconEIO.map.render((IWidgetIcon)IconEIO.RECIPE, (double)(x + 1), (double)(y + 1), 14.0, 14.0, 0.0, true);
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack stack, List<String> currenttip, int recipeIndex) {
        return currenttip;
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip, int recipeIndex) {
        InnerVatRecipe rec = (InnerVatRecipe)((Object)this.arecipes.get(recipeIndex));
        Point pos = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipeIndex);
        Point relMouse = new Point(pos.x - (gui.field_146294_l - 176) / 2 - offset.x, pos.y - (gui.field_146295_m - 166) / 2 - offset.y);
        if (this.inTankBounds.contains(relMouse) || this.outTankBounds.contains(relMouse)) {
            if (this.inTankBounds.contains(relMouse)) {
                if (rec.inFluid != null && rec.inFluid.getFluid() != null) {
                    currenttip.add(rec.inFluid.getFluid().getLocalizedName(rec.inFluid));
                }
            } else if (rec.result != null && rec.result.getFluid() != null) {
                currenttip.add(rec.result.getFluid().getLocalizedName(rec.result));
            }
        }
        return super.handleTooltip(gui, currenttip, recipeIndex);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipeIndex) {
        if (button == 0 ? this.transferFluidTanks(gui, recipeIndex, false) : button == 1 && this.transferFluidTanks(gui, recipeIndex, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipeIndex);
    }

    private boolean transferFluidTanks(GuiRecipe gui, int recipeIndex, boolean usage) {
        InnerVatRecipe rec = (InnerVatRecipe)((Object)this.arecipes.get(recipeIndex));
        Point pos = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipeIndex);
        Point relMouse = new Point(pos.x - (gui.field_146294_l - 176) / 2 - offset.x, pos.y - (gui.field_146295_m - 166) / 2 - offset.y);
        if (this.inTankBounds.contains(relMouse)) {
            this.transferFluidTank(rec.inFluid, usage);
        } else if (this.outTankBounds.contains(relMouse)) {
            this.transferFluidTank(rec.result, usage);
        }
        return false;
    }

    private boolean transferFluidTank(FluidStack tank, boolean usage) {
        if (tank != null && tank.amount > 0) {
            return !(usage ? !GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.copy()}) : !GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.copy()}));
        }
        return false;
    }

    public List<ItemStack> getInputs(RecipeInput input) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(input.getInput());
        ItemStack[] eq = input.getEquivelentInputs();
        if (eq != null) {
            for (ItemStack st : eq) {
                result.add(st);
            }
        }
        return result;
    }

    public class InnerVatRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private ArrayList<PositionedStack> inputs;
        private int energy;
        private FluidStack result;
        private FluidStack inFluid;

        public int getEnergy() {
            return this.energy;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(VatRecipeHandler.this.cycleticks / 30, this.inputs);
        }

        public PositionedStack getResult() {
            return null;
        }

        public InnerVatRecipe(int energy, RecipeInput[] ingredients, FluidStack result) {
            super((TemplateRecipeHandler)VatRecipeHandler.this);
            ArrayList<ItemStack> inputsOne = new ArrayList<ItemStack>();
            ArrayList<ItemStack> inputsTwo = new ArrayList<ItemStack>();
            for (RecipeInput input : ingredients) {
                if (input.getInput() != null) {
                    List<ItemStack> equivs = VatRecipeHandler.this.getInputs(input);
                    if (input.getSlotNumber() == 0) {
                        inputsOne.addAll(equivs);
                        continue;
                    }
                    if (input.getSlotNumber() != 1) continue;
                    inputsTwo.addAll(equivs);
                    continue;
                }
                if (input.getFluidInput() == null) continue;
                this.inFluid = input.getFluidInput();
            }
            this.inputs = new ArrayList();
            if (!inputsOne.isEmpty()) {
                this.inputs.add(new PositionedStack(inputsOne, 51, 1));
            }
            if (!inputsTwo.isEmpty()) {
                this.inputs.add(new PositionedStack(inputsTwo, 100, 1));
            }
            this.energy = energy;
            this.result = result;
        }
    }
}

