/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.mechanics.enderStorage;

import com.github.technus.tectech.mechanics.enderStorage.EnderFluidContainer;
import com.github.technus.tectech.mechanics.enderStorage.EnderLinkTag;
import com.github.technus.tectech.mechanics.enderStorage.EnderLinkTank;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.IFluidHandler;

public class EnderWorldSavedData
extends WorldSavedData {
    private static EnderWorldSavedData INSTANCE;
    private static final String DATA_NAME = "tectech_EnderWorldSavedData";
    private static final String ENDER_LIQUID_TAG_LINK = "tectech_EnderWorldSavedData_EnderLiquidTagLink";
    private static final String ENDER_LIQUID_TANK_LINK = "tectech_EnderWorldSavedData_EnderLiquidTankLink";
    private static final EnderLinkTag DEFAULT_LINK_TAG;
    private Map<EnderLinkTag, EnderFluidContainer> EnderLiquidTagLink = new HashMap<EnderLinkTag, EnderFluidContainer>();
    private Map<EnderLinkTank, EnderLinkTag> EnderLiquidTankLink = new HashMap<EnderLinkTank, EnderLinkTag>();

    public EnderWorldSavedData() {
        super(DATA_NAME);
    }

    public EnderWorldSavedData(String s) {
        super(s);
    }

    public void func_76184_a(NBTTagCompound nbtTagCompound) {
        Object data;
        ObjectInputStream ois;
        ByteArrayInputStream is;
        byte[] ba;
        try {
            ba = nbtTagCompound.func_74770_j(ENDER_LIQUID_TAG_LINK);
            is = new ByteArrayInputStream(ba);
            ois = new ObjectInputStream(is);
            data = ois.readObject();
            this.EnderLiquidTagLink = (Map)data;
        }
        catch (IOException | ClassNotFoundException ignored) {
            System.out.println("ENDER_LIQUID_TAG_LINK LOAD FAILED");
            System.out.println(ignored);
        }
        try {
            ba = nbtTagCompound.func_74770_j(ENDER_LIQUID_TANK_LINK);
            is = new ByteArrayInputStream(ba);
            ois = new ObjectInputStream(is);
            data = ois.readObject();
            this.EnderLiquidTankLink = (Map)data;
        }
        catch (IOException | ClassNotFoundException ignored) {
            System.out.println("ENDER_LIQUID_TANK_LINK LOAD FAILED");
            System.out.println(ignored);
        }
    }

    public void func_76187_b(NBTTagCompound nbtTagCompound) {
        byte[] data;
        ObjectOutputStream oos;
        ByteArrayOutputStream bos;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(this.EnderLiquidTagLink);
            oos.flush();
            data = bos.toByteArray();
            nbtTagCompound.func_74773_a(ENDER_LIQUID_TAG_LINK, data);
        }
        catch (IOException ignored) {
            System.out.println("ENDER_LIQUID_TAG_LINK SAVE FAILED");
            System.out.println(ignored);
        }
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(this.EnderLiquidTankLink);
            oos.flush();
            data = bos.toByteArray();
            nbtTagCompound.func_74773_a(ENDER_LIQUID_TANK_LINK, data);
        }
        catch (IOException ignored) {
            System.out.println("ENDER_LIQUID_TANK_LINK SAVE FAILED");
            System.out.println(ignored);
        }
    }

    private static void loadInstance() {
        MapStorage storage;
        if (INSTANCE == null && (INSTANCE = (EnderWorldSavedData)(storage = DimensionManager.getWorld((int)0).field_72988_C).func_75742_a(EnderWorldSavedData.class, DATA_NAME)) == null) {
            INSTANCE = new EnderWorldSavedData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)INSTANCE);
        }
        INSTANCE.func_76185_a();
    }

    private static Map<EnderLinkTag, EnderFluidContainer> getEnderLiquidLink() {
        EnderWorldSavedData.loadInstance();
        return EnderWorldSavedData.INSTANCE.EnderLiquidTagLink;
    }

    private static Map<EnderLinkTank, EnderLinkTag> getEnderLiquidTankLink() {
        EnderWorldSavedData.loadInstance();
        return EnderWorldSavedData.INSTANCE.EnderLiquidTankLink;
    }

    public static EnderFluidContainer getEnderFluidContainer(EnderLinkTag tag) {
        if (!EnderWorldSavedData.getEnderLiquidLink().containsKey(tag)) {
            EnderWorldSavedData.getEnderLiquidLink().put(tag, new EnderFluidContainer());
        }
        return EnderWorldSavedData.getEnderLiquidLink().get(tag);
    }

    public static EnderLinkTag getEnderLinkTag(IFluidHandler handler) {
        EnderLinkTank tank = new EnderLinkTank(handler);
        if (!EnderWorldSavedData.getEnderLiquidTankLink().containsKey(tank)) {
            EnderWorldSavedData.getEnderLiquidTankLink().put(tank, DEFAULT_LINK_TAG);
        }
        return EnderWorldSavedData.getEnderLiquidTankLink().get(tank);
    }

    public static void bindEnderLinkTag(IFluidHandler handler, EnderLinkTag tag) {
        EnderLinkTank tank = new EnderLinkTank(handler);
        EnderWorldSavedData.getEnderLiquidTankLink().remove(tank);
        EnderWorldSavedData.getEnderLiquidTankLink().put(tank, tag);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_73011_w.field_76574_g == 0) {
            INSTANCE = null;
        }
    }

    static {
        DEFAULT_LINK_TAG = new EnderLinkTag("", null);
    }
}

