/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.loader.recipe;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.compatibility.gtpp.GtppAtomLoader;
import com.github.technus.tectech.loader.recipe.Assembler;
import com.github.technus.tectech.loader.recipe.AssemblyLine;
import com.github.technus.tectech.loader.recipe.CircuitAssembler;
import com.github.technus.tectech.loader.recipe.Crafting;
import com.github.technus.tectech.loader.recipe.Extractor;
import com.github.technus.tectech.loader.recipe.MachineEMBehaviours;
import com.github.technus.tectech.loader.recipe.ResearchStationAssemblyLine;
import com.github.technus.tectech.mechanics.elementalMatter.core.transformations.EMTransformationRegistry;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.EMAtomDefinition;
import com.github.technus.tectech.mechanics.elementalMatter.definitions.complex.EMHadronDefinition;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IItemContainer;

public class BaseRecipeLoader {
    private static Class CUSTOM_ITEM_LIST;

    public static IItemContainer getItemContainer(String name) {
        return (IItemContainer)Enum.valueOf(CUSTOM_ITEM_LIST, name);
    }

    public static Materials getOrDefault(String name, Materials def) {
        Materials mat = Materials.get((String)name);
        return mat == Materials._NULL || mat == null ? def : mat;
    }

    public void run(EMTransformationRegistry transformationInfo) {
        EMAtomDefinition.setTransformations(transformationInfo);
        EMHadronDefinition.setTransformations(transformationInfo);
        if (Mods.GTPlusPlus.isModLoaded()) {
            new GtppAtomLoader().setTransformations(transformationInfo);
        }
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            new Assembler().run();
            new AssemblyLine().run();
            new CircuitAssembler().run();
            new Crafting().run();
            new Extractor().run();
            new ResearchStationAssemblyLine().run();
        }
        new MachineEMBehaviours();
    }

    static {
        try {
            CUSTOM_ITEM_LIST = Class.forName("com.dreammaster.gthandler.CustomItemList");
        }
        catch (Exception e) {
            TecTech.LOGGER.error((Object)"NHCoreMod not present. Disabling all the recipes");
        }
    }
}

