/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.craftguide;

import cpw.mods.fml.common.Loader;
import java.lang.reflect.Method;
import mods.railcraft.common.plugins.craftguide.BlastFurnacePlugin;
import mods.railcraft.common.plugins.craftguide.CokeOvenPlugin;
import mods.railcraft.common.plugins.craftguide.CustomRecipesPlugin;
import mods.railcraft.common.plugins.craftguide.RecipeFilter;
import mods.railcraft.common.plugins.craftguide.RockCrusherPlugin;
import mods.railcraft.common.plugins.craftguide.RollingMachinePlugin;
import mods.railcraft.common.util.misc.Game;
import org.apache.logging.log4j.Level;

public class CraftGuidePlugin {
    private static Method register;

    public static void init() {
        if (Loader.isModLoaded((String)"craftguide")) {
            try {
                CraftGuidePlugin.registerCraftGuideObject(new BlastFurnacePlugin());
                CraftGuidePlugin.registerCraftGuideObject(new CokeOvenPlugin());
                CraftGuidePlugin.registerCraftGuideObject(new RockCrusherPlugin());
                CraftGuidePlugin.registerCraftGuideObject(new RollingMachinePlugin());
                CraftGuidePlugin.registerCraftGuideObject(new CustomRecipesPlugin());
                CraftGuidePlugin.registerCraftGuideObject(new RecipeFilter());
            }
            catch (Throwable error) {
                Game.log(Level.WARN, "Could not register CraftGuide plugins: {0}", error.getMessage());
            }
        } else {
            Game.log(Level.WARN, "Could not register CraftGuide plugins: CraftGuide missing.", new Object[0]);
        }
    }

    private static void registerCraftGuideObject(Object obj) {
        try {
            if (register == null) {
                Class<?> api = Class.forName("uristqwerty.CraftGuide.ReflectionAPI");
                register = api.getMethod("registerAPIObject", Object.class);
            }
            register.invoke(null, obj);
            Game.log(Level.DEBUG, "Successfully registered CraftGuide plugin: {0}", obj.getClass().getSimpleName());
        }
        catch (Exception e) {
            Game.log(Level.WARN, "Could not register CraftGuide plugin: {0}", obj.getClass().getSimpleName());
        }
    }
}

