/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import mods.railcraft.api.carts.IFluidCart;
import mods.railcraft.api.carts.IRefuelableCart;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.FilteredTank;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.steam.SteamBoiler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class EntityLocomotiveSteam
extends EntityLocomotive
implements IFluidHandler,
IRefuelableCart,
IFluidCart {
    public static final int SLOT_LIQUID_INPUT = 0;
    public static final int SLOT_LIQUID_OUTPUT = 1;
    public static final byte SMOKE_FLAG = 6;
    public static final byte STEAM_FLAG = 7;
    private static final byte TICKS_PER_BOILER_CYCLE = 2;
    private static final int FUEL_PER_REQUEST = 3;
    private static final int TANK_WATER = 0;
    public SteamBoiler boiler;
    protected StandardTank tankWater;
    protected StandardTank tankSteam;
    protected InventoryMapper invWaterInput;
    protected IInventory invWaterOutput = new InventoryMapper((IInventory)this, 1, 1);
    private TankManager tankManager;
    private int update = this.field_70146_Z.nextInt();

    public EntityLocomotiveSteam(World world) {
        super(world);
    }

    public EntityLocomotiveSteam(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.tankManager = new TankManager();
        this.tankWater = new FilteredTank(6000, Fluids.WATER.get());
        this.tankSteam = new FilteredTank(16000, Fluids.STEAM.get());
        this.tankManager.add(this.tankWater);
        this.tankManager.add(this.tankSteam);
        this.invWaterInput = new InventoryMapper((IInventory)this, 0, 1);
        this.invWaterInput.setStackSizeLimit(4);
        this.boiler = new SteamBoiler(this.tankWater, this.tankSteam);
        this.boiler.setEfficiencyModifier(RailcraftConfig.steamLocomotiveEfficiencyMultiplier());
        this.boiler.setTicksPerCycle(2);
    }

    @Override
    public String getWhistle() {
        return "railcraft:locomotive.steam.whistle";
    }

    @Override
    protected ItemStack getCartItemBase() {
        return EnumCart.LOCO_STEAM_SOLID.getCartItem();
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (Game.isHost(this.field_70170_p)) {
            ++this.update;
            if (this.tankWater.isEmpty()) {
                this.setMode(EntityLocomotive.LocoMode.SHUTDOWN);
            }
            this.setSteaming(this.tankSteam.getFluidAmount() > 0);
            if (this.tankSteam.getRemainingSpace() >= 160 || this.isShutdown()) {
                this.boiler.tick(1);
                this.setSmoking(this.boiler.isBurning());
                if (!this.boiler.isBurning()) {
                    this.ventSteam();
                }
            }
            if (this.update % 8 == 0) {
                FluidHelper.drainContainers(this, (IInventory)this, 0, 1);
            }
        } else {
            if (this.isSmoking() && this.field_70146_Z.nextInt(3) == 0) {
                double rads = (double)this.renderYaw * Math.PI / 180.0;
                float offset = 0.4f;
                this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t - Math.cos(rads) * (double)offset, this.field_70163_u + (double)1.2f, this.field_70161_v - Math.sin(rads) * (double)offset, 0.0, 0.0, 0.0);
            }
            if (this.isSteaming()) {
                EffectManager.instance.steamEffect(this.field_70170_p, this, this.field_70121_D.field_72338_b - this.field_70163_u - 0.3);
            }
        }
    }

    public boolean isSmoking() {
        return this.func_70083_f(6);
    }

    private void setSmoking(boolean smoke) {
        if (this.func_70083_f(6) != smoke) {
            this.func_70052_a(6, smoke);
        }
    }

    public boolean isSteaming() {
        return this.func_70083_f(7);
    }

    private void setSteaming(boolean steam) {
        if (this.func_70083_f(7) != steam) {
            this.func_70052_a(7, steam);
        }
    }

    private void ventSteam() {
        this.tankSteam.drain(4, true);
    }

    @Override
    public int getMoreGoJuice() {
        FluidStack steam = this.tankSteam.getFluid();
        if (steam != null && steam.amount >= this.tankSteam.getCapacity() / 2) {
            this.tankSteam.drain(160, true);
            return 3;
        }
        return 0;
    }

    @Override
    public void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        this.tankManager.writeTanksToNBT(data);
        this.boiler.writeToNBT(data);
    }

    @Override
    public void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        this.tankManager.readTanksFromNBT(data);
        this.boiler.readFromNBT(data);
    }

    public boolean isSafeToFill() {
        return !this.boiler.isSuperHeated() || !this.tankWater.isEmpty();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        FluidStack water;
        if (doFill && Fluids.WATER.is(resource) && this.boiler.isSuperHeated() && ((water = this.tankWater.getFluid()) == null || water.amount <= 0)) {
            this.explode();
        }
        return this.tankWater.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return Fluids.WATER.is(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        return this.tankManager.getTankInfo();
    }

    @Override
    public boolean canPassFluidRequests(Fluid fluid) {
        return Fluids.WATER.is(fluid);
    }

    @Override
    public boolean canAcceptPushedFluid(EntityMinecart requester, Fluid fluid) {
        return Fluids.WATER.is(fluid);
    }

    @Override
    public boolean canProvidePulledFluid(EntityMinecart requester, Fluid fluid) {
        return false;
    }

    @Override
    public void setFilling(boolean filling) {
    }
}

