/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.railcraft.client.particles.ParticleHelperCallback;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ParticleHelper {
    private static final Random rand = new Random();

    @SideOnly(value=Side.CLIENT)
    public static boolean addHitEffects(World world, Block block, MovingObjectPosition target, EffectRenderer effectRenderer, ParticleHelperCallback callback) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        int sideHit = target.field_72310_e;
        if (block != WorldPlugin.getBlock((IBlockAccess)world, x, y, z)) {
            return true;
        }
        int meta = world.func_72805_g(x, y, z);
        float b = 0.1f;
        double px = (double)x + rand.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(b * 2.0f)) + (double)b + block.func_149704_x();
        double py = (double)y + rand.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(b * 2.0f)) + (double)b + block.func_149665_z();
        double pz = (double)z + rand.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(b * 2.0f)) + (double)b + block.func_149706_B();
        if (sideHit == 0) {
            py = (double)y + block.func_149665_z() - (double)b;
        }
        if (sideHit == 1) {
            py = (double)y + block.func_149669_A() + (double)b;
        }
        if (sideHit == 2) {
            pz = (double)z + block.func_149706_B() - (double)b;
        }
        if (sideHit == 3) {
            pz = (double)z + block.func_149693_C() + (double)b;
        }
        if (sideHit == 4) {
            px = (double)x + block.func_149704_x() - (double)b;
        }
        if (sideHit == 5) {
            px = (double)x + block.func_149753_y() + (double)b;
        }
        EntityDiggingFX fx = new EntityDiggingFX(world, px, py, pz, 0.0, 0.0, 0.0, block, sideHit, meta);
        fx.func_110125_a(block.func_149673_e((IBlockAccess)world, x, y, z, 0));
        if (callback != null) {
            callback.addHitEffects(fx, world, x, y, z, meta);
        }
        effectRenderer.func_78873_a(fx.func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean addDestroyEffects(World world, Block block, int x, int y, int z, int meta, EffectRenderer effectRenderer, ParticleHelperCallback callback) {
        if (block != WorldPlugin.getBlock((IBlockAccess)world, x, y, z)) {
            return true;
        }
        int its = 4;
        for (int i = 0; i < its; ++i) {
            for (int j = 0; j < its; ++j) {
                for (int k = 0; k < its; ++k) {
                    double px = (double)x + ((double)i + 0.5) / (double)its;
                    double py = (double)y + ((double)j + 0.5) / (double)its;
                    double pz = (double)z + ((double)k + 0.5) / (double)its;
                    int random = rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(world, px, py, pz, px - (double)x - 0.5, py - (double)y - 0.5, pz - (double)z - 0.5, block, random, meta);
                    fx.func_110125_a(block.func_149673_e((IBlockAccess)world, x, y, z, 0));
                    if (callback != null) {
                        callback.addDestroyEffects(fx, world, x, y, z, meta);
                    }
                    effectRenderer.func_78873_a((EntityFX)fx.func_70596_a(x, y, z));
                }
            }
        }
        return true;
    }
}

