/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.utills;

import com.brandon3055.draconicevolution.common.utills.LogHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;

public class UpdateChecker {
    private final UpdateCheckThread thread = new UpdateCheckThread();
    private int delay = 300;
    private boolean playerNotified = false;

    public UpdateChecker() {
        this.thread.start();
    }

    @SubscribeEvent
    public void tickStart(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        if (!this.playerNotified && this.thread.isComplete()) {
            this.playerNotified = true;
            FMLCommonHandler.instance().bus().unregister((Object)this);
            if (!this.thread.getVersion().equals("1.1.16-GTNH")) {
                event.player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.LIGHT_PURPLE + "[Draconic Evolution]" + EnumChatFormatting.RESET + " New version available:"));
                event.player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "Draconic Evolution v" + this.thread.getVersion()));
                if (!StringUtils.func_151246_b((String)this.thread.getNote())) {
                    event.player.func_146105_b((IChatComponent)new ChatComponentText(this.thread.getNote()));
                }
            } else if (this.thread.getSnapshot() > 0) {
                event.player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "[Draconic Evolution]" + EnumChatFormatting.RESET + " New snapshot version available:"));
                event.player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.BLUE + "Draconic Evolution v" + this.thread.getVersion() + "-snapshot_" + this.thread.getSnapshot()));
                if (!StringUtils.func_151246_b((String)this.thread.getNote())) {
                    event.player.func_146105_b((IChatComponent)new ChatComponentText(this.thread.getNote()));
                }
            }
        } else if (this.thread.isFailed()) {
            this.playerNotified = true;
            FMLCommonHandler.instance().bus().unregister((Object)this);
            event.player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "[Draconic Evolution]" + EnumChatFormatting.RED + " Version check failed"));
            if (!StringUtils.func_151246_b((String)this.thread.getNote())) {
                event.player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + this.thread.getNote()));
            }
        }
    }

    public class UpdateCheckThread
    extends Thread {
        private String version = null;
        private int snapshot = -1;
        private String note = null;
        private boolean complete = false;
        private boolean failed = false;

        @Override
        public void run() {
            LogHelper.info("[Update Checker] Thread Started");
            try {
                String line;
                URL versionURL = new URL("https://raw.githubusercontent.com/brandon3055/Draconic-Evolution/master/VERSION.txt");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(versionURL.openStream()));
                while ((line = bufferedReader.readLine()) != null) {
                    if (!line.contains(":")) continue;
                    String value = line.substring(line.indexOf(":") + 1);
                    if (line.contains("Version")) {
                        this.version = value;
                        continue;
                    }
                    if (line.contains("Snapshot")) {
                        this.snapshot = Integer.parseInt(value);
                        continue;
                    }
                    if (!line.contains("ReleaseNote")) continue;
                    this.note = value;
                }
                if (this.version != null && this.snapshot >= 0) {
                    this.complete = true;
                } else {
                    this.note = "[Invalid Response]";
                    this.failed = true;
                }
                LogHelper.info("[Update Checker] Thread Finished");
            }
            catch (Exception e) {
                LogHelper.info("[Update Checker] Check Failed");
                this.failed = true;
                this.note = e.getClass().toString();
                e.printStackTrace();
            }
        }

        public String getVersion() {
            return this.version;
        }

        public int getSnapshot() {
            return this.snapshot;
        }

        public String getNote() {
            return this.note;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

