/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.UIInfos;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SteamVariant;
import gregtech.api.gui.GT_GUIContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_Item_Machines;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.common.power.Power;
import gregtech.nei.NEIHandlerAbsoluteTooltip;
import gregtech.nei.NEIRecipeInfo;
import gregtech.nei.NEI_TransferRectHost;
import gregtech.nei.RecipeMapHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.SoftReference;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.Range;
import org.lwjgl.opengl.GL11;

public class GT_NEI_DefaultHandler
extends RecipeMapHandler {
    public static final int sOffsetX = 5;
    public static final int sOffsetY = 11;
    private static final ConcurrentMap<GT_Recipe.GT_Recipe_Map, SortedRecipeListCache> CACHE = new ConcurrentHashMap<GT_Recipe.GT_Recipe_Map, SortedRecipeListCache>();
    protected Power mPower;
    private String mRecipeName;
    private NEIHandlerAbsoluteTooltip mRecipeNameTooltip;
    private static final int RECIPE_NAME_WIDTH = 140;
    public static int cycleTicksStatic = Math.abs((int)System.currentTimeMillis());
    private static int drawTicks;
    protected static final int PROGRESSBAR_CYCLE_TICKS = 200;
    protected final ModularWindow modularWindow;
    protected final ItemStackHandler itemInputsInventory;
    protected final ItemStackHandler itemOutputsInventory;
    protected final ItemStackHandler specialSlotInventory;
    protected final ItemStackHandler fluidInputsInventory;
    protected final ItemStackHandler fluidOutputsInventory;
    protected static final Pos2d WINDOW_OFFSET;

    public GT_NEI_DefaultHandler(GT_Recipe.GT_Recipe_Map aRecipeMap) {
        super(aRecipeMap);
        Rectangle transferRect = new Rectangle(aRecipeMap.neiTransferRect);
        transferRect.translate(GT_NEI_DefaultHandler.WINDOW_OFFSET.x, GT_NEI_DefaultHandler.WINDOW_OFFSET.y);
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(transferRect, this.getOverlayIdentifier(), new Object[0]));
        if (this.mRecipeMap.useModularUI) {
            this.itemInputsInventory = new ItemStackHandler(this.mRecipeMap.mUsualInputCount);
            this.itemOutputsInventory = new ItemStackHandler(this.mRecipeMap.mUsualOutputCount);
            this.specialSlotInventory = new ItemStackHandler(1);
            this.fluidInputsInventory = new ItemStackHandler(this.mRecipeMap.getUsualFluidInputCount());
            this.fluidOutputsInventory = new ItemStackHandler(this.mRecipeMap.getUsualFluidOutputCount());
            ModularWindow.Builder builder = this.mRecipeMap.createNEITemplate((IItemHandlerModifiable)this.itemInputsInventory, (IItemHandlerModifiable)this.itemOutputsInventory, (IItemHandlerModifiable)this.specialSlotInventory, (IItemHandlerModifiable)this.fluidInputsInventory, (IItemHandlerModifiable)this.fluidOutputsInventory, () -> Float.valueOf((float)GT_NEI_DefaultHandler.getDrawTicks() % 200.0f / 200.0f), WINDOW_OFFSET);
            this.modularWindow = builder.build();
            UIInfos.initializeWindow((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ModularWindow)this.modularWindow);
        } else {
            this.fluidOutputsInventory = null;
            this.fluidInputsInventory = null;
            this.specialSlotInventory = null;
            this.itemOutputsInventory = null;
            this.itemInputsInventory = null;
            this.modularWindow = null;
        }
    }

    @Deprecated
    public List<GT_Recipe> getSortedRecipes() {
        ArrayList<GT_Recipe> result = new ArrayList<GT_Recipe>(this.mRecipeMap.mRecipeList);
        Collections.sort(result);
        return result;
    }

    private SortedRecipeListCache getCacheHolder() {
        return CACHE.computeIfAbsent(this.mRecipeMap, m -> new SortedRecipeListCache());
    }

    public List<CachedDefaultRecipe> getCache() {
        List<CachedDefaultRecipe> cache;
        SortedRecipeListCache cacheHolder = this.getCacheHolder();
        if (cacheHolder.getCachedRecipesVersion() != GT_Mod.gregtechproxy.getReloadCount() || (cache = cacheHolder.getCachedRecipes()) == null) {
            cache = this.mRecipeMap.mRecipeList.stream().filter(r -> !r.mHidden).sorted().map(x$0 -> new CachedDefaultRecipe((GT_Recipe)x$0)).collect(Collectors.toList());
            cacheHolder.setCachedRecipes(cache);
            cacheHolder.setCachedRecipesVersion(GT_Mod.gregtechproxy.getReloadCount());
        }
        return cache;
    }

    public TemplateRecipeHandler newInstance() {
        return new GT_NEI_DefaultHandler(this.mRecipeMap);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            if (results.length > 0 && results[0] instanceof Power) {
                this.mPower = (Power)results[0];
                if (this.mRecipeMap.useComparatorForNEI) {
                    this.loadTieredCraftingRecipesWithPower(this.mPower);
                } else {
                    this.loadTieredCraftingRecipesUpTo(this.mPower.getTier());
                }
            } else {
                this.arecipes.addAll(this.getCache());
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack aResult) {
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation(aResult);
        ArrayList<ItemStack> tResults = new ArrayList<ItemStack>();
        tResults.add(aResult);
        tResults.add(GT_OreDictUnificator.get(true, aResult));
        if (tPrefixMaterial != null && !tPrefixMaterial.mBlackListed && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tResults.add(GT_OreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        if (aResult.func_77977_a().startsWith("gt.blockores")) {
            for (int i = 0; i < 8; ++i) {
                tResults.add(new ItemStack(aResult.func_77973_b(), 1, aResult.func_77960_j() % 1000 + i * 1000));
            }
        }
        this.addFluidStacks(aResult, tResults);
        for (CachedDefaultRecipe recipe : this.getCache()) {
            if (!tResults.stream().anyMatch(stack -> recipe.contains(recipe.mOutputs, (ItemStack)stack))) continue;
            this.arecipes.add(recipe);
        }
    }

    private void addFluidStacks(ItemStack aStack, ArrayList<ItemStack> tResults) {
        FluidStack tFluidStack;
        FluidStack tFluid = GT_Utility.getFluidForFilledItem(aStack, true);
        if (tFluid != null) {
            tFluidStack = tFluid;
            tResults.add(GT_Utility.getFluidDisplayStack(tFluid, false));
        } else {
            tFluidStack = GT_Utility.getFluidFromDisplayStack(aStack);
        }
        if (tFluidStack != null) {
            tResults.addAll(GT_Utility.getContainersFromFluid(tFluidStack));
        }
    }

    private void loadTieredCraftingRecipesWithPower(Power power) {
        this.arecipes.addAll(this.getTieredRecipes(power));
    }

    private List<CachedDefaultRecipe> getTieredRecipes(Power power) {
        List<CachedDefaultRecipe> recipes = this.getCache();
        if (recipes.size() > 0) {
            recipes = recipes.stream().filter(recipe -> power.compareTo(GT_Utility.getTier(recipe.mRecipe.mEUt), recipe.mRecipe.mSpecialValue) >= 0).collect(Collectors.toList());
        }
        return recipes;
    }

    private void loadTieredCraftingRecipesUpTo(byte upperTier) {
        this.arecipes.addAll(this.getTieredRecipes(upperTier));
    }

    private List<CachedDefaultRecipe> getTieredRecipes(byte upperTier) {
        List<CachedDefaultRecipe> recipes = this.getCache();
        if (recipes.size() > 0) {
            Range<Integer> indexRange = this.getCacheHolder().getIndexRangeForTiers((byte)0, upperTier);
            recipes = recipes.subList((Integer)indexRange.getMinimum(), (Integer)indexRange.getMaximum() + 1);
        }
        return recipes;
    }

    public void loadUsageRecipes(ItemStack aInput) {
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation(aInput);
        ArrayList<ItemStack> tInputs = new ArrayList<ItemStack>();
        tInputs.add(aInput);
        tInputs.add(GT_OreDictUnificator.get(false, aInput));
        if (tPrefixMaterial != null && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tInputs.add(GT_OreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        this.addFluidStacks(aInput, tInputs);
        for (CachedDefaultRecipe recipe : this.getCache()) {
            if (!tInputs.stream().anyMatch(stack -> recipe.contains(recipe.mInputs, (ItemStack)stack))) continue;
            this.arecipes.add(recipe);
        }
    }

    public IUsageHandler getUsageAndCatalystHandler(String inputId, Object ... ingredients) {
        if (inputId.equals("item")) {
            ItemStack candidate = (ItemStack)ingredients[0];
            GT_NEI_DefaultHandler handler = (GT_NEI_DefaultHandler)this.newInstance();
            if (RecipeCatalysts.containsCatalyst((IRecipeHandler)handler, (ItemStack)candidate)) {
                IMetaTileEntity gtTileEntity = GT_Item_Machines.getMetaTileEntity(candidate);
                Power power = gtTileEntity != null ? gtTileEntity.getPower() : null;
                handler.loadCraftingRecipes(this.getOverlayIdentifier(), power);
                return handler;
            }
        }
        return this.getUsageHandler(inputId, ingredients);
    }

    public ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        GT_NEI_DefaultHandler handler = (GT_NEI_DefaultHandler)super.getRecipeHandler(outputId, results);
        if (results.length > 0 && results[0] instanceof Power) {
            handler.mPower = (Power)results[0];
        }
        return handler;
    }

    public String getOverlayIdentifier() {
        return this.mRecipeMap.mNEIName;
    }

    public void drawBackground(int recipe) {
        if (this.modularWindow != null) {
            this.drawUI(this.modularWindow);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiDraw.changeTexture((String)this.getGuiTexture());
            GuiDraw.drawTexturedModalRect((int)-4, (int)-8, (int)1, (int)3, (int)174, (int)78);
        }
    }

    public void drawForeground(int recipe) {
        if (this.mRecipeMap.useModularUI) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            this.drawExtras(recipe);
        } else {
            super.drawForeground(recipe);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (!NEIClientUtils.shiftKey()) {
            ++cycleTicksStatic;
        }
        ++drawTicks;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        if (this.mRecipeName == null) {
            this.mRecipeName = this.computeRecipeName();
            this.updateOverrideTextColor();
            this.mRecipeMap.updateNEITextColorOverride();
        }
        return this.mRecipeName;
    }

    private String computeRecipeName() {
        String recipeName = GT_LanguageManager.getTranslation(this.mRecipeMap.mUnlocalizedName);
        if (this.mPower != null) {
            recipeName = this.addSuffixToRecipeName(recipeName, this.mPower.getTierString() + ")");
        }
        return recipeName;
    }

    private String addSuffixToRecipeName(String aRecipeName, String suffix) {
        String separator;
        String recipeName;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int recipeNameWidth = fontRenderer.func_78256_a(aRecipeName);
        int targetWidth = 140 - fontRenderer.func_78256_a(suffix);
        if (recipeNameWidth + fontRenderer.func_78256_a(" (") <= targetWidth) {
            recipeName = aRecipeName;
            separator = " (";
        } else {
            this.setupRecipeNameTooltip(aRecipeName + " (" + suffix);
            separator = "...(";
            recipeName = this.shrinkRecipeName(aRecipeName, targetWidth - fontRenderer.func_78256_a(separator));
        }
        return recipeName + separator + suffix;
    }

    private String shrinkRecipeName(String recipeName, int targetWidth) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        while (fontRenderer.func_78256_a(recipeName = recipeName.substring(0, recipeName.length() - 2)) > targetWidth) {
        }
        return recipeName;
    }

    private void setupRecipeNameTooltip(String tooltip) {
        this.mRecipeNameTooltip = new NEIHandlerAbsoluteTooltip(tooltip, new Rectangle(13, -34, 139, 11));
    }

    public String getRecipeTabName() {
        return GT_LanguageManager.getTranslation(this.mRecipeMap.mUnlocalizedName);
    }

    public String getGuiTexture() {
        return this.mRecipeMap.mNEIGUIPath;
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack aStack, List<String> currentTip, int aRecipeIndex) {
        TemplateRecipeHandler.CachedRecipe tObject = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(aRecipeIndex);
        if (tObject instanceof CachedDefaultRecipe) {
            currentTip = this.mRecipeMap.handleNEIItemTooltip(aStack, currentTip, (CachedDefaultRecipe)tObject);
        }
        if (this.mRecipeNameTooltip != null) {
            this.mRecipeNameTooltip.handleTooltip(currentTip, aRecipeIndex);
        }
        return currentTip;
    }

    public void drawExtras(int aRecipeIndex) {
        CachedDefaultRecipe cachedRecipe = (CachedDefaultRecipe)((Object)this.arecipes.get(aRecipeIndex));
        this.drawDescription(cachedRecipe);
        this.mRecipeMap.drawNEIOverlays(cachedRecipe);
    }

    private void drawDescription(CachedDefaultRecipe cachedRecipe) {
        GT_Recipe recipe = cachedRecipe.mRecipe;
        if (this.mPower == null) {
            this.mPower = this.mRecipeMap.getPowerFromRecipeMap();
        }
        this.mPower.computePowerUsageAndDuration(recipe.mEUt, recipe.mDuration, recipe.mSpecialValue);
        this.mRecipeMap.drawNEIDescription(new NEIRecipeInfo(recipe, this.mRecipeMap, cachedRecipe, this.mPower, this.getDescriptionYOffset()));
    }

    @Deprecated
    protected String getSpecialInfo(int specialValue) {
        return "";
    }

    @Deprecated
    protected void drawLine(int lineNumber, String line) {
        this.drawText(10, this.getDescriptionYOffset() + lineNumber * 10, line, -16777216);
    }

    protected int getDescriptionYOffset() {
        return this.mRecipeMap.neiBackgroundSize.height + this.mRecipeMap.neiBackgroundOffset.y + GT_NEI_DefaultHandler.WINDOW_OFFSET.y + 3;
    }

    protected void drawUI(ModularWindow window) {
        for (IDrawable background : window.getBackground()) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)(GT_NEI_DefaultHandler.WINDOW_OFFSET.x + this.mRecipeMap.neiBackgroundOffset.x), (float)(GT_NEI_DefaultHandler.WINDOW_OFFSET.y + this.mRecipeMap.neiBackgroundOffset.y), (float)0.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            background.draw(Pos2d.ZERO, window.getSize(), 0.0f);
            GlStateManager.popMatrix();
        }
        for (Widget widget : window.getChildren()) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)widget.getPos().x, (float)widget.getPos().y, (float)0.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)window.getAlpha());
            GlStateManager.enableBlend();
            widget.drawBackground(0.0f);
            widget.draw(0.0f);
            GlStateManager.popMatrix();
        }
    }

    public static int getDrawTicks() {
        return drawTicks;
    }

    @Deprecated
    public String trans(String aKey, String aEnglish) {
        return GT_Utility.trans(aKey, aEnglish);
    }

    static {
        WINDOW_OFFSET = new Pos2d(-5, -11);
        GuiContainerManager.addInputHandler((IContainerInputHandler)new GT_RectHandler());
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)new GT_RectHandler());
    }

    private class SortedRecipeListCache {
        private int mCachedRecipesVersion = -1;
        @Nullable
        private SoftReference<List<CachedDefaultRecipe>> mCachedRecipes;
        private Map<Byte, Range<Integer>> mTierIndexes;
        private Range<Byte> mTierRange;

        private SortedRecipeListCache() {
        }

        public int getCachedRecipesVersion() {
            return this.mCachedRecipesVersion;
        }

        public void setCachedRecipesVersion(int aCachedRecipesVersion) {
            this.mCachedRecipesVersion = aCachedRecipesVersion;
        }

        @Nullable
        public List<CachedDefaultRecipe> getCachedRecipes() {
            return this.mCachedRecipes == null ? null : this.mCachedRecipes.get();
        }

        public void setCachedRecipes(@Nonnull List<CachedDefaultRecipe> aCachedRecipes) {
            this.mCachedRecipes = new SoftReference<List<CachedDefaultRecipe>>(aCachedRecipes);
        }

        public Range<Integer> getIndexRangeForTiers(byte lowerTier, byte upperTier) {
            if (this.mTierIndexes == null) {
                this.computeTierIndexes();
            }
            return Range.between((Comparable)Integer.valueOf(this.getLowIndexForTier(lowerTier)), (Comparable)Integer.valueOf(this.getHighIndexForTier(upperTier)));
        }

        private void computeTierIndexes() {
            this.mTierIndexes = new HashMap<Byte, Range<Integer>>(GT_Values.V.length + 1, 1.0f);
            assert (this.mCachedRecipes != null);
            Iterator<CachedDefaultRecipe> iterator = Objects.requireNonNull(this.mCachedRecipes.get()).iterator();
            int index = 0;
            int minIndex = 0;
            int maxIndex = -1;
            byte previousTier = -1;
            byte lowestTier = 0;
            while (iterator.hasNext()) {
                CachedDefaultRecipe recipe = iterator.next();
                byte recipeTier = GT_Utility.getTier(recipe.mRecipe.mEUt / GT_NEI_DefaultHandler.this.mRecipeMap.mAmperage);
                if (recipeTier != previousTier) {
                    if (maxIndex != -1) {
                        this.mTierIndexes.put(previousTier, (Range<Integer>)Range.between((Comparable)Integer.valueOf(minIndex), (Comparable)Integer.valueOf(maxIndex)));
                    } else {
                        lowestTier = recipeTier;
                    }
                    minIndex = index;
                    previousTier = recipeTier;
                }
                maxIndex = index++;
                if (iterator.hasNext()) continue;
                this.mTierIndexes.put(recipeTier, (Range<Integer>)Range.between((Comparable)Integer.valueOf(minIndex), (Comparable)Integer.valueOf(maxIndex)));
                this.mTierRange = Range.between((Comparable)Byte.valueOf(lowestTier), (Comparable)Byte.valueOf(recipeTier));
            }
        }

        private int getLowIndexForTier(byte lowerTier) {
            byte lowTier = (byte)Math.max(((Byte)this.mTierRange.getMinimum()).byteValue(), lowerTier);
            while (this.mTierIndexes.get(lowTier) == null) {
                lowTier = (byte)(lowTier + 1);
            }
            return (Integer)this.mTierIndexes.get(lowTier).getMinimum();
        }

        private int getHighIndexForTier(byte upperTier) {
            byte highTier = (byte)Math.min(((Byte)this.mTierRange.getMaximum()).byteValue(), upperTier);
            while (this.mTierIndexes.get(highTier) == null) {
                highTier = (byte)(highTier - 1);
            }
            return (Integer)this.mTierIndexes.get(highTier).getMaximum();
        }
    }

    public class CachedDefaultRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final GT_Recipe mRecipe;
        public final List<PositionedStack> mOutputs;
        public final List<PositionedStack> mInputs;

        private void drawNEIItemGrid(ItemStack[] ItemArray, int x_coord_origin, int y_coord_origin, int x_dir_max_items, int y_max_dir_max_items, GT_Recipe Recipe, boolean is_input) {
            if (ItemArray.length > x_dir_max_items * y_max_dir_max_items) {
                GT_Log.err.println("Recipe cannot be properly displayed in NEI due to too many items.");
            }
            int x_max = x_coord_origin + x_dir_max_items * 18;
            int x_coord = x_coord_origin;
            int y_coord = y_coord_origin;
            int special_counter = 0;
            for (ItemStack item : ItemArray) {
                if (item == GT_Values.NI) continue;
                if (is_input) {
                    this.mInputs.add(new FixedPositionedStack((Object)item, GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, x_coord, y_coord, true));
                } else {
                    this.mOutputs.add(new FixedPositionedStack(item, GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, x_coord, y_coord, Recipe.getOutputChance(special_counter), GT_NEI_DefaultHandler.this.mRecipeMap.mNEIUnificateOutput));
                    ++special_counter;
                }
                if ((x_coord += 18) != x_max) continue;
                x_coord = x_coord_origin;
                y_coord += 18;
            }
        }

        public CachedDefaultRecipe(GT_Recipe aRecipe) {
            ArrayList<PositionedStack> maybeOut;
            ArrayList<PositionedStack> maybeIn;
            super((TemplateRecipeHandler)GT_NEI_DefaultHandler.this);
            this.mRecipe = aRecipe;
            try {
                maybeIn = GT_NEI_DefaultHandler.this.mRecipeMap.getInputPositionedStacks(aRecipe);
            }
            catch (NullPointerException npe) {
                maybeIn = null;
                GT_Log.err.println("CachedDefaultRecipe - Invalid InputPositionedStacks " + aRecipe);
                npe.printStackTrace(GT_Log.err);
            }
            try {
                maybeOut = GT_NEI_DefaultHandler.this.mRecipeMap.getOutputPositionedStacks(aRecipe);
            }
            catch (NullPointerException npe) {
                maybeOut = null;
                GT_Log.err.println("CachedDefaultRecipe - Invalid OutputPositionedStacks " + aRecipe);
                npe.printStackTrace(GT_Log.err);
            }
            if (maybeOut != null && maybeIn != null) {
                this.mOutputs = maybeOut;
                this.mInputs = maybeIn;
                return;
            }
            try {
                maybeIn = aRecipe.getInputPositionedStacks();
            }
            catch (NullPointerException npe) {
                maybeIn = null;
                GT_Log.err.println("CachedDefaultRecipe - Invalid InputPositionedStacks " + aRecipe);
                npe.printStackTrace(GT_Log.err);
            }
            try {
                maybeOut = aRecipe.getOutputPositionedStacks();
            }
            catch (NullPointerException npe) {
                maybeOut = null;
                GT_Log.err.println("CachedDefaultRecipe - Invalid OutputPositionedStacks " + aRecipe);
                npe.printStackTrace(GT_Log.err);
            }
            if (maybeOut != null && maybeIn != null) {
                this.mOutputs = maybeOut;
                this.mInputs = maybeIn;
                return;
            }
            this.mOutputs = new ArrayList<PositionedStack>();
            this.mInputs = new ArrayList<PositionedStack>();
            if (GT_NEI_DefaultHandler.this.mRecipeMap.useModularUI) {
                for (Widget child : GT_NEI_DefaultHandler.this.modularWindow.getChildren()) {
                    int i2;
                    if (!(child instanceof SlotWidget)) continue;
                    SlotWidget widget = (SlotWidget)child;
                    if (widget.getMcSlot().getItemHandler() == GT_NEI_DefaultHandler.this.itemInputsInventory) {
                        i2 = widget.getMcSlot().getSlotIndex();
                        Object input = aRecipe instanceof GT_Recipe.GT_Recipe_WithAlt ? ((GT_Recipe.GT_Recipe_WithAlt)aRecipe).getAltRepresentativeInput(i2) : aRecipe.getRepresentativeInput(i2);
                        if (input == null) continue;
                        this.mInputs.add(new FixedPositionedStack(input, GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, widget.getPos().x + 1, widget.getPos().y + 1, true));
                        continue;
                    }
                    if (widget.getMcSlot().getItemHandler() == GT_NEI_DefaultHandler.this.itemOutputsInventory) {
                        i2 = widget.getMcSlot().getSlotIndex();
                        if (aRecipe.mOutputs.length <= i2 || aRecipe.mOutputs[i2] == null) continue;
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.mOutputs[i2], GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, widget.getPos().x + 1, widget.getPos().y + 1, aRecipe.getOutputChance(i2), GT_NEI_DefaultHandler.this.mRecipeMap.mNEIUnificateOutput));
                        continue;
                    }
                    if (widget.getMcSlot().getItemHandler() == GT_NEI_DefaultHandler.this.specialSlotInventory) {
                        if (aRecipe.mSpecialItems == null) continue;
                        this.mInputs.add(new FixedPositionedStack(aRecipe.mSpecialItems, GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, widget.getPos().x + 1, widget.getPos().y + 1));
                        continue;
                    }
                    if (widget.getMcSlot().getItemHandler() == GT_NEI_DefaultHandler.this.fluidInputsInventory) {
                        i2 = widget.getMcSlot().getSlotIndex();
                        if (aRecipe.mFluidInputs.length <= i2 || aRecipe.mFluidInputs[i2] == null || aRecipe.mFluidInputs[i2].getFluid() == null) continue;
                        this.mInputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[i2], true), GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, widget.getPos().x + 1, widget.getPos().y + 1));
                        continue;
                    }
                    if (widget.getMcSlot().getItemHandler() != GT_NEI_DefaultHandler.this.fluidOutputsInventory || aRecipe.mFluidOutputs.length <= (i2 = widget.getMcSlot().getSlotIndex()) || aRecipe.mFluidOutputs[i2] == null || aRecipe.mFluidOutputs[i2].getFluid() == null) continue;
                    this.mOutputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[i2], true), GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, widget.getPos().x + 1, widget.getPos().y + 1));
                }
                UIHelper.forEachSlots((i, backgrounds, pos) -> {
                    if (i >= GT_NEI_DefaultHandler.this.mRecipeMap.mUsualInputCount && aRecipe.mInputs[i] != null) {
                        this.mInputs.add(new FixedPositionedStack((Object)aRecipe.mInputs[i], GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, pos.x + 1, pos.y + 1, true));
                    }
                }, (i, backgrounds, pos) -> {
                    if (i >= GT_NEI_DefaultHandler.this.mRecipeMap.mUsualOutputCount && aRecipe.mOutputs[i] != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.mOutputs[i], GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, pos.x + 1, pos.y + 1, aRecipe.getOutputChance(i), GT_NEI_DefaultHandler.this.mRecipeMap.mNEIUnificateOutput));
                    }
                }, (i, backgrounds, pos) -> {}, (i, backgrounds, pos) -> {
                    if (i >= GT_NEI_DefaultHandler.this.mRecipeMap.getUsualFluidInputCount() && aRecipe.mFluidInputs[i] != null && aRecipe.mFluidInputs[i].getFluid() != null) {
                        this.mInputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[i], true), GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, pos.x + 1, pos.y + 1));
                    }
                }, (i, backgrounds, pos) -> {
                    if (i >= GT_NEI_DefaultHandler.this.mRecipeMap.getUsualFluidOutputCount() && aRecipe.mFluidOutputs[i] != null && aRecipe.mFluidOutputs[i].getFluid() != null) {
                        this.mOutputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[i], true), GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, pos.x + 1, pos.y + 1));
                    }
                }, null, null, GT_NEI_DefaultHandler.this.mRecipeMap, aRecipe.mInputs.length, aRecipe.mOutputs.length, aRecipe.mFluidInputs.length, aRecipe.mFluidOutputs.length, SteamVariant.NONE, WINDOW_OFFSET);
            } else {
                switch (GT_NEI_DefaultHandler.this.mRecipeMap.mUsualInputCount) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.drawNEIItemGrid(aRecipe.mInputs, 48, 14, 1, 1, aRecipe, true);
                        break;
                    }
                    case 2: {
                        this.drawNEIItemGrid(aRecipe.mInputs, 30, 14, 2, 1, aRecipe, true);
                        break;
                    }
                    case 3: {
                        this.drawNEIItemGrid(aRecipe.mInputs, 12, 14, 3, 1, aRecipe, true);
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.drawNEIItemGrid(aRecipe.mInputs, 12, 14, 3, 2, aRecipe, true);
                        break;
                    }
                    case 6: {
                        this.drawNEIItemGrid(aRecipe.mInputs, 12, 5, 3, 2, aRecipe, true);
                        break;
                    }
                    default: {
                        this.drawNEIItemGrid(aRecipe.mInputs, 12, -4, 3, 3, aRecipe, true);
                    }
                }
                switch (GT_NEI_DefaultHandler.this.mRecipeMap.mUsualOutputCount) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.drawNEIItemGrid(aRecipe.mOutputs, 102, 14, 1, 1, aRecipe, false);
                        break;
                    }
                    case 2: {
                        this.drawNEIItemGrid(aRecipe.mOutputs, 102, 14, 2, 1, aRecipe, false);
                        break;
                    }
                    case 3: {
                        this.drawNEIItemGrid(aRecipe.mOutputs, 102, 14, 3, 1, aRecipe, false);
                        break;
                    }
                    case 4: {
                        this.drawNEIItemGrid(aRecipe.mOutputs, 102, 5, 2, 2, aRecipe, false);
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.drawNEIItemGrid(aRecipe.mOutputs, 102, 5, 3, 2, aRecipe, false);
                        break;
                    }
                    default: {
                        this.drawNEIItemGrid(aRecipe.mOutputs, 102, -4, 3, 3, aRecipe, false);
                    }
                }
                if (aRecipe.mSpecialItems != null) {
                    this.mInputs.add(new FixedPositionedStack(aRecipe.mSpecialItems, GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, 120, 52));
                }
                if (aRecipe.mFluidInputs.length > 0 && aRecipe.mFluidInputs[0] != null && aRecipe.mFluidInputs[0].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[0], true), GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, 48, 52));
                    if (aRecipe.mFluidInputs.length > 1 && aRecipe.mFluidInputs[1] != null && aRecipe.mFluidInputs[1].getFluid() != null) {
                        this.mInputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[1], true), GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, 30, 52));
                    }
                }
                if (aRecipe.mFluidOutputs.length > 1) {
                    if (aRecipe.mFluidOutputs[0] != null && aRecipe.mFluidOutputs[0].getFluid() != null) {
                        this.mOutputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[0], true), GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, 120, 5));
                    }
                    if (aRecipe.mFluidOutputs[1] != null && aRecipe.mFluidOutputs[1].getFluid() != null) {
                        this.mOutputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[1], true), GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, 138, 5));
                    }
                    if (aRecipe.mFluidOutputs.length > 2 && aRecipe.mFluidOutputs[2] != null && aRecipe.mFluidOutputs[2].getFluid() != null) {
                        this.mOutputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[2], true), GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, 102, 23));
                    }
                    if (aRecipe.mFluidOutputs.length > 3 && aRecipe.mFluidOutputs[3] != null && aRecipe.mFluidOutputs[3].getFluid() != null) {
                        this.mOutputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[3], true), GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, 120, 23));
                    }
                    if (aRecipe.mFluidOutputs.length > 4 && aRecipe.mFluidOutputs[4] != null && aRecipe.mFluidOutputs[4].getFluid() != null) {
                        this.mOutputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[4], true), GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, 138, 23));
                    }
                } else if (aRecipe.mFluidOutputs.length > 0 && aRecipe.mFluidOutputs[0] != null && aRecipe.mFluidOutputs[0].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack((Object)GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[0], true), GT_NEI_DefaultHandler.this.mRecipeMap.renderRealStackSizes, 102, 52));
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(cycleTicksStatic / 10, this.mInputs);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.mOutputs;
        }
    }

    public static class GT_RectHandler
    implements IContainerInputHandler,
    IContainerTooltipHandler {
        public boolean mouseClicked(GuiContainer gui, int mouseX, int mouseY, int button) {
            NEI_TransferRectHost host;
            if (this.canHandle(gui) && this.hostRectContainsMouse(host = (NEI_TransferRectHost)gui, this.getMousePos(gui, mouseX, mouseY))) {
                if (button == 0) {
                    return this.handleTransferRectMouseClick(host, false);
                }
                if (button == 1) {
                    return this.handleTransferRectMouseClick(host, true);
                }
            }
            return false;
        }

        private Point getMousePos(GuiContainer gui, int mouseX, int mouseY) {
            return new Point(mouseX - ((GT_GUIContainer)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], mouseY - ((GT_GUIContainer)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1]);
        }

        private boolean hostRectContainsMouse(NEI_TransferRectHost host, Point mousePos) {
            return host.getNeiTransferRect().contains(mousePos);
        }

        private boolean handleTransferRectMouseClick(NEI_TransferRectHost gui, boolean usage) {
            String mNEI = gui.getNeiTransferRectString();
            Object[] args = gui.getNeiTransferRectArgs();
            return usage ? GuiUsageRecipe.openRecipeGui((String)mNEI, (Object[])new Object[0]) : GuiCraftingRecipe.openRecipeGui((String)mNEI, (Object[])args);
        }

        public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public boolean canHandle(GuiContainer gui) {
            return gui instanceof NEI_TransferRectHost && GT_Utility.isStringValid(((NEI_TransferRectHost)gui).getNeiTransferRectString());
        }

        public List<String> handleTooltip(GuiContainer gui, int mouseX, int mouseY, List<String> currentTip) {
            NEI_TransferRectHost host;
            if (this.canHandle(gui) && currentTip.isEmpty() && this.hostRectContainsMouse(host = (NEI_TransferRectHost)gui, this.getMousePos(gui, mouseX, mouseY))) {
                currentTip.add(host.getNeiTransferRectTooltip());
            }
            return currentTip;
        }

        public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currentTip) {
            return currentTip;
        }

        public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mouseX, int mouseY, List<String> currentTip) {
            return currentTip;
        }

        public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        }

        public void onMouseClicked(GuiContainer gui, int mouseX, int mouseY, int button) {
        }

        public void onMouseUp(GuiContainer gui, int mouseX, int mouseY, int button) {
        }

        public boolean mouseScrolled(GuiContainer gui, int mouseX, int mouseY, int scrolled) {
            return false;
        }

        public void onMouseScrolled(GuiContainer gui, int mouseX, int mouseY, int scrolled) {
        }

        public void onMouseDragged(GuiContainer gui, int mouseX, int mouseY, int button, long heldTime) {
        }
    }

    public static class FixedPositionedStack
    extends PositionedStack {
        public static final DecimalFormat chanceFormat = new DecimalFormat("##0.##%");
        public final int mChance;
        public final int realStackSize;
        public final boolean renderRealStackSize;

        @Deprecated
        public FixedPositionedStack(Object object, int x, int y) {
            this(object, true, x, y, 0, true);
        }

        @Deprecated
        public FixedPositionedStack(Object object, int x, int y, boolean aUnificate) {
            this(object, true, x, y, 0, aUnificate);
        }

        @Deprecated
        public FixedPositionedStack(Object object, int x, int y, int aChance) {
            this(object, true, x, y, aChance, true);
        }

        @Deprecated
        public FixedPositionedStack(Object object, int x, int y, int aChance, boolean aUnificate) {
            this(object, true, x, y, aChance, aUnificate);
        }

        public FixedPositionedStack(Object object, boolean renderRealStackSizes, int x, int y) {
            this(object, renderRealStackSizes, x, y, 0, true);
        }

        public FixedPositionedStack(Object object, boolean renderRealStackSizes, int x, int y, boolean aUnificate) {
            this(object, renderRealStackSizes, x, y, 0, aUnificate);
        }

        public FixedPositionedStack(Object object, boolean renderRealStackSize, int x, int y, int aChance, boolean aUnificate) {
            super(aUnificate ? GT_OreDictUnificator.getNonUnifiedStacks(object) : object, x, y, true);
            this.mChance = aChance;
            this.realStackSize = this.item != null ? this.item.field_77994_a : 0;
            this.renderRealStackSize = renderRealStackSize;
            if (!renderRealStackSize) {
                for (ItemStack stack : this.items) {
                    stack.field_77994_a = 1;
                }
            }
        }

        public boolean isChanceBased() {
            return this.mChance > 0 && this.mChance < 10000;
        }

        public String getChanceText() {
            return chanceFormat.format((float)this.mChance / 10000.0f);
        }

        public boolean isNotConsumed() {
            return !ItemList.Display_Fluid.isStackEqual(this.item, true, true) && this.item.field_77994_a == 0;
        }
    }
}

