/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei;

import gregtech.api.enums.GT_Values;
import gregtech.nei.INEISpecialInfoFormatter;
import gregtech.nei.NEIRecipeInfo;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class FusionSpecialValueFormatter
implements INEISpecialInfoFormatter {
    public static final FusionSpecialValueFormatter INSTANCE = new FusionSpecialValueFormatter();
    private static final int M = 1000000;

    @Override
    public List<String> format(NEIRecipeInfo recipeInfo, Function<Integer, String> applyPrefixAndSuffix) {
        int euToStart = recipeInfo.recipe.mSpecialValue;
        int voltage = recipeInfo.recipe.mEUt;
        int tier = FusionSpecialValueFormatter.getFusionTier(euToStart, voltage);
        return Collections.singletonList(applyPrefixAndSuffix.apply(euToStart) + " (MK " + tier + ")");
    }

    public static int getFusionTier(int startupPower, long voltage) {
        int tier = startupPower <= 160000000 ? 1 : (startupPower <= 320000000 ? 2 : (startupPower <= 640000000 ? 3 : 4));
        if (voltage > GT_Values.V[6]) {
            tier = voltage <= GT_Values.V[7] ? Math.max(tier, 2) : (voltage <= GT_Values.V[8] ? Math.max(tier, 3) : 4);
        }
        return tier;
    }
}

