/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.postload.recipes;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class ImplosionCompressorRecipes
implements Runnable {
    @Override
    public void run() {
        this.addImplosionRecipe(ItemList.IC2_Compressed_Coal_Chunk.get(1L, new Object[0]), 8, new ItemStack[]{ItemList.IC2_Industrial_Diamond.get(1L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 4L)});
        this.addImplosionRecipe(ItemList.Ingot_IridiumAlloy.get(1L, new Object[0]), 8, new ItemStack[]{GT_OreDictUnificator.get(OrePrefixes.plateAlloy, Materials.Iridium, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 4L)});
        if (Mods.GalacticraftMars.isModLoaded()) {
            this.addImplosionRecipe(ItemList.Ingot_Heavy1.get(1L, new Object[0]), 8, new ItemStack[]{GT_ModHandler.getModItem(Mods.GalacticraftCore.ID, "item.heavyPlating", 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.StainlessSteel, 1L)});
            this.addImplosionRecipe(ItemList.Ingot_Heavy2.get(1L, new Object[0]), 16, new ItemStack[]{GT_ModHandler.getModItem(Mods.GalacticraftMars.ID, "item.null", 1L, 3), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.TungstenSteel, 2L)});
            this.addImplosionRecipe(ItemList.Ingot_Heavy3.get(1L, new Object[0]), 24, new ItemStack[]{GT_ModHandler.getModItem(Mods.GalacticraftMars.ID, "item.itemBasicAsteroids", 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Platinum, 3L)});
        }
    }

    public void addImplosionRecipe(ItemStack input, int explosiveAmount, ItemStack[] outputs) {
        int tExplosives = Math.min(explosiveAmount, 64);
        int tGunpowder = tExplosives << 1;
        int tDynamite = Math.max(1, tExplosives >> 1);
        int tTNT = tExplosives;
        int tITNT = Math.max(1, tExplosives >> 2);
        if (tGunpowder < 65) {
            GT_Values.RA.stdBuilder().itemInputs(input, ItemList.Block_Powderbarrel.get(tGunpowder, new Object[0])).itemOutputs(outputs).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
        }
        if (tDynamite < 17) {
            GT_Values.RA.stdBuilder().itemInputs(input, GT_ModHandler.getIC2Item("dynamite", (long)tDynamite, null)).itemOutputs(outputs).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
        }
        GT_Values.RA.stdBuilder().itemInputs(input, new ItemStack(Blocks.field_150335_W, tTNT)).itemOutputs(outputs).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
        GT_Values.RA.stdBuilder().itemInputs(input, GT_ModHandler.getIC2Item("industrialTnt", tITNT)).itemOutputs(outputs).noFluidInputs().noFluidOutputs().duration(20).eut(TierEU.RECIPE_LV).addTo(GT_Recipe.GT_Recipe_Map.sImplosionRecipes);
    }
}

