/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHeatingCoil;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Single_Recipe_Check;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_LargeChemicalReactor
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_LargeChemicalReactor>
implements ISurvivalConstructable {
    private static final int CASING_INDEX = 176;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_MetaTileEntity_LargeChemicalReactor> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "cxc", "ccc"}, {"c~c", "xPx", "cxc"}, {"ccc", "cxc", "ccc"}})).addElement('P', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)1)).addElement('c', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_LargeChemicalReactor.class).atLeast(GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy).casingIndex(176).dot(1).buildAndChain(StructureUtility.onElementPass(GT_MetaTileEntity_LargeChemicalReactor::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)0)))).addElement('x', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_LargeChemicalReactor.class).atLeast(GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy).casingIndex(176).dot(1).buildAndChain(CoilStructureElement.INSTANCE, StructureUtility.onElementPass(GT_MetaTileEntity_LargeChemicalReactor::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)0)))).build();
    private int mCasingAmount;
    private int mCoilAmount;

    public GT_MetaTileEntity_LargeChemicalReactor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeChemicalReactor(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeChemicalReactor(this.mName);
    }

    @Override
    public GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Chemical Reactor").addInfo("Controller block for the Large Chemical Reactor").addInfo("Does not lose efficiency when overclocked").addInfo("Accepts fluids instead of fluid cells").addSeparator().beginStructureBlock(3, 3, 3, false).addController("Front center").addCasingInfoRange("Chemically Inert Machine Casing", 8, 22, false).addOtherStructurePart("PTFE Pipe Machine Casing", "Center").addOtherStructurePart("Heating Coil", "Adjacent to the PTFE Pipe Machine Casing", 1).addEnergyHatch("Any casing", 1, 2).addMaintenanceHatch("Any casing", 1, 2).addInputBus("Any casing", 1, 2).addInputHatch("Any casing", 1, 2).addOutputBus("Any casing", 1, 2).addOutputHatch("Any casing", 1, 2).addStructureInfo("You can have multiple hatches/busses").toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48]};
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sMultiblockChemicalRecipes;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        GT_Recipe tRecipe;
        long tVoltage = this.getMaxInputVoltage();
        byte tier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
        if (this.mLockedToSingleRecipe && this.mSingleRecipeCheck != null) {
            if (!this.mSingleRecipeCheck.checkRecipeInputsSingleStack(true)) {
                return false;
            }
            tRecipe = this.mSingleRecipeCheck.getRecipe();
        } else {
            ArrayList<ItemStack> tInputList = this.getStoredInputs();
            ArrayList<FluidStack> tFluidList = this.getStoredFluids();
            ItemStack[] inputs = tInputList.toArray(new ItemStack[0]);
            FluidStack[] fluids = tFluidList.toArray(new FluidStack[0]);
            if (inputs.length == 0 && fluids.length == 0) {
                return false;
            }
            GT_Single_Recipe_Check.Builder tSingleRecipeCheckBuilder = null;
            if (this.mLockedToSingleRecipe) {
                tSingleRecipeCheckBuilder = GT_Single_Recipe_Check.builder(this).setBefore(inputs, fluids);
            }
            if ((tRecipe = GT_Recipe.GT_Recipe_Map.sMultiblockChemicalRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, false, GT_Values.V[tier], fluids, inputs)) == null || !this.canOutputAll(tRecipe) || !tRecipe.isRecipeInputEqual(true, fluids, inputs)) {
                return false;
            }
            if (this.mLockedToSingleRecipe) {
                this.mSingleRecipeCheck = tSingleRecipeCheckBuilder.setAfter(inputs, fluids).setRecipe(tRecipe).build();
            }
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.calculateOverclockedNessMultiInternal(tRecipe.mEUt, tRecipe.mDuration, 1, tVoltage, true);
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mOutputItems = tRecipe.mOutputs;
        this.mOutputFluids = tRecipe.mFluidOutputs;
        this.updateSlots();
        return true;
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_LargeChemicalReactor> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasingAmount = 0;
        this.mCoilAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 1, 0) && this.mCasingAmount >= 8 && this.mCoilAmount == 1 && !this.mEnergyHatches.isEmpty() && this.mMaintenanceHatches.size() == 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.mCoilAmount = 0;
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        this.mCoilAmount = 0;
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    private static enum CoilStructureElement implements IStructureElement<GT_MetaTileEntity_LargeChemicalReactor>
    {
        INSTANCE;


        public boolean check(GT_MetaTileEntity_LargeChemicalReactor t, World world, int x, int y, int z) {
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof IHeatingCoil && ((IHeatingCoil)block).getCoilHeat(world.func_72805_g(x, y, z)) != HeatingCoilLevel.None) {
                return t.mCoilAmount++ == 0;
            }
            return false;
        }

        public boolean spawnHint(GT_MetaTileEntity_LargeChemicalReactor t, World world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)GregTech_API.sBlockCasings5, (int)0);
            return true;
        }

        public boolean placeBlock(GT_MetaTileEntity_LargeChemicalReactor t, World world, int x, int y, int z, ItemStack trigger) {
            if (t.mCoilAmount > 0) {
                return false;
            }
            boolean b = world.func_147465_d(x, y, z, GregTech_API.sBlockCasings5, 0, 3);
            if (b) {
                t.mCoilAmount++;
            }
            return b;
        }

        public IStructureElement.PlaceResult survivalPlaceBlock(GT_MetaTileEntity_LargeChemicalReactor t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
            return this.survivalPlaceBlock(t, world, x, y, z, trigger, AutoPlaceEnvironment.fromLegacy((IItemSource)s, (EntityPlayer)actor, chatter));
        }

        public IStructureElement.BlocksToPlace getBlocksToPlace(GT_MetaTileEntity_LargeChemicalReactor gt_metaTileEntity_largeChemicalReactor, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            return IStructureElement.BlocksToPlace.create((Iterable)IntStream.range(0, 8).mapToObj(i -> new ItemStack(GregTech_API.sBlockCasings5, 1, i)).collect(Collectors.toList()));
        }

        public IStructureElement.PlaceResult survivalPlaceBlock(GT_MetaTileEntity_LargeChemicalReactor t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            if (t.mCoilAmount > 0) {
                return IStructureElement.PlaceResult.SKIP;
            }
            if (this.check(t, world, x, y, z)) {
                return IStructureElement.PlaceResult.SKIP;
            }
            if (!StructureLibAPI.isBlockTriviallyReplaceable((World)world, (int)x, (int)y, (int)z, (EntityPlayer)env.getActor())) {
                return IStructureElement.PlaceResult.REJECT;
            }
            ItemStack result = env.getSource().takeOne((Predicate)ItemStackPredicate.from((Block)GregTech_API.sBlockCasings5), true);
            if (result == null) {
                return IStructureElement.PlaceResult.REJECT;
            }
            IStructureElement.PlaceResult ret = StructureUtility.survivalPlaceBlock((ItemStack)result, (ItemStackPredicate.NBTMode)ItemStackPredicate.NBTMode.EXACT, null, (boolean)true, (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
            if (ret == IStructureElement.PlaceResult.ACCEPT) {
                t.mCoilAmount++;
            }
            return ret;
        }
    }
}

