/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_AbstractMultiFurnace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_ElectricBlastFurnace
extends GT_MetaTileEntity_AbstractMultiFurnace<GT_MetaTileEntity_ElectricBlastFurnace>
implements ISurvivalConstructable {
    private int mHeatingCapacity = 0;
    protected final ArrayList<GT_MetaTileEntity_Hatch_Output> mPollutionOutputHatches = new ArrayList();
    protected final FluidStack[] pollutionFluidStacks = new FluidStack[]{Materials.CarbonDioxide.getGas(1000L), Materials.CarbonMonoxide.getGas(1000L), Materials.SulfurDioxide.getGas(1000L)};
    protected static final int CASING_INDEX = 11;
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_MetaTileEntity_ElectricBlastFurnace> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ttt", "tmt", "ttt"}, {"CCC", "C-C", "CCC"}, {"CCC", "C-C", "CCC"}, {"b~b", "bbb", "bbb"}})).addElement('t', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_ElectricBlastFurnace.class).atLeast(GT_HatchElement.OutputHatch.withAdder(GT_MetaTileEntity_ElectricBlastFurnace::addOutputHatchToTopList).withCount(t -> t.mPollutionOutputHatches.size())).casingIndex(11).dot(1).buildAndChain(GregTech_API.sBlockCasings1, 11)).addElement('m', GT_HatchElement.Muffler.newAny(11, 2)).addElement('C', GT_StructureUtility.ofCoil(GT_MetaTileEntity_AbstractMultiFurnace::setCoilLevel, GT_MetaTileEntity_AbstractMultiFurnace::getCoilLevel)).addElement('b', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_ElectricBlastFurnace.class).atLeast(GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy).casingIndex(11).dot(1).buildAndChain(GregTech_API.sBlockCasings1, 11)).build();

    public GT_MetaTileEntity_ElectricBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ElectricBlastFurnace(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ElectricBlastFurnace(this.mName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Blast Furnace").addInfo("Controller block for the Electric Blast Furnace").addInfo("You can use some fluids to reduce recipe time. Place the circuit in the Input Bus").addInfo("Each 900K over the min. Heat required reduces power consumption by 5% (multiplicatively)").addInfo("Each 1800K over the min. Heat required grants one perfect overclock").addInfo("For each perfect overclock the EBF will reduce recipe time 4 times (instead of 2) (100% efficiency)").addInfo("Additionally gives +100K for every tier past MV").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 4, 3, true).addController("Front bottom").addCasingInfoRange("Heat Proof Machine Casing", 0, 15, false).addOtherStructurePart("Heating Coils", "Two middle Layers").addEnergyHatch("Any bottom layer casing", 3).addMaintenanceHatch("Any bottom layer casing", 3).addMufflerHatch("Top middle", 2).addInputBus("Any bottom layer casing", 3).addInputHatch("Any bottom layer casing", 3).addOutputBus("Any bottom layer casing", 3).addOutputHatch("Liquid form of fluids, Any bottom layer casing").addOutputHatch("Gas form of fluids, Any top layer casing", 1).addStructureInfo("Recovery amount scales with Muffler Hatch tier").toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return GT_Mod.gregtechproxy.mPollutionEBFPerSecond;
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sBlastRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_ElectricBlastFurnace> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        if (this.inputSeparation) {
            FluidStack[] tFluids = this.getStoredFluids().toArray(new FluidStack[0]);
            for (GT_MetaTileEntity_Hatch_InputBus tBus : this.mInputBusses) {
                ItemStack[] tItems;
                ArrayList<ItemStack> tInputs = new ArrayList<ItemStack>();
                tBus.mRecipeMap = this.getRecipeMap();
                if (GT_MetaTileEntity_ElectricBlastFurnace.isValidMetaTileEntity(tBus)) {
                    for (int i = tBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                        if (tBus.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                        tInputs.add(tBus.getBaseMetaTileEntity().func_70301_a(i));
                    }
                }
                if (!this.processRecipe(tItems = tInputs.toArray(new ItemStack[0]), tFluids)) continue;
                return true;
            }
            return false;
        }
        return this.processRecipe(this.getCompactedInputs(), this.getCompactedFluids());
    }

    protected boolean processRecipe(ItemStack[] tItems, FluidStack[] tFluids) {
        if (tItems.length == 0) {
            return false;
        }
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sBlastRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tItems);
        if (tRecipe == null) {
            return false;
        }
        if (this.mHeatingCapacity < tRecipe.mSpecialValue) {
            return false;
        }
        if (!this.canOutputAll(tRecipe.mOutputs, this.getPollutionMultiplierAppliedFluids(tRecipe.mFluidOutputs))) {
            return false;
        }
        if (!tRecipe.isRecipeInputEqual(true, tFluids, tItems)) {
            return false;
        }
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        int tHeatCapacityDivTiers = (this.mHeatingCapacity - tRecipe.mSpecialValue) / 900;
        byte overclockCount = this.calculateOverclockednessEBF(tRecipe.mEUt, tRecipe.mDuration, tVoltage);
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        if (tHeatCapacityDivTiers > 0) {
            this.mEUt = (int)((double)this.mEUt * Math.pow(0.95, tHeatCapacityDivTiers));
            this.mMaxProgresstime >>= Math.min(tHeatCapacityDivTiers / 2, overclockCount);
            if (this.mMaxProgresstime < 1) {
                this.mMaxProgresstime = 1;
            }
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0), tRecipe.getOutput(1)};
        this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
        this.updateSlots();
        return true;
    }

    protected byte calculateOverclockednessEBF(int aEUt, int aDuration, long maxInputVoltage) {
        byte mTier = (byte)Math.max(0, GT_Utility.getTier(maxInputVoltage));
        byte timesOverclocked = 0;
        if (mTier == 0) {
            long xMaxProgresstime = (long)aDuration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = aEUt >> 2;
                this.mMaxProgresstime = (int)xMaxProgresstime;
            }
        } else {
            long xEUt = aEUt;
            long tempEUt = Math.max(xEUt, GT_Values.V[1]);
            this.mMaxProgresstime = aDuration;
            while (tempEUt <= GT_Values.V[mTier - 1]) {
                tempEUt <<= 2;
                this.mMaxProgresstime >>= 1;
                xEUt = this.mMaxProgresstime == 0 ? xEUt >> 1 : xEUt << 2;
                timesOverclocked = (byte)(timesOverclocked + 1);
            }
            if (xEUt > 0x7FFFFFFEL) {
                this.mEUt = 0x7FFFFFFE;
                this.mMaxProgresstime = 0x7FFFFFFE;
            } else {
                this.mEUt = (int)xEUt;
                if (this.mEUt == 0) {
                    this.mEUt = 1;
                }
                if (this.mMaxProgresstime == 0) {
                    this.mMaxProgresstime = 1;
                }
            }
        }
        return timesOverclocked;
    }

    private FluidStack[] getPollutionMultiplierAppliedFluids(FluidStack[] original) {
        FluidStack[] fluids;
        for (FluidStack fluid : fluids = GT_Utility.copyFluidArray(original)) {
            if (!this.isPollutionFluid(fluid)) continue;
            this.multiplyPollutionFluidAmount(fluid);
        }
        return fluids;
    }

    public boolean addOutputHatchToTopList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mPollutionOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mHeatingCapacity = 0;
        this.setCoilLevel(HeatingCoilLevel.None);
        this.mPollutionOutputHatches.clear();
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 3, 0)) {
            return false;
        }
        if (this.getCoilLevel() == HeatingCoilLevel.None) {
            return false;
        }
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        this.mHeatingCapacity = (int)this.getCoilLevel().getHeat() + 100 * (GT_Utility.getTier(this.getMaxInputVoltage()) - 2);
        return true;
    }

    @Override
    public boolean addOutput(FluidStack aLiquid) {
        ArrayList tOutputHatches;
        if (aLiquid == null) {
            return false;
        }
        FluidStack tLiquid = aLiquid.copy();
        if (this.isPollutionFluid(tLiquid)) {
            tOutputHatches = this.mPollutionOutputHatches;
            this.multiplyPollutionFluidAmount(tLiquid);
        } else {
            tOutputHatches = this.mOutputHatches;
        }
        return GT_MetaTileEntity_ElectricBlastFurnace.dumpFluid(tOutputHatches, tLiquid, true) || GT_MetaTileEntity_ElectricBlastFurnace.dumpFluid(tOutputHatches, tLiquid, false);
    }

    protected boolean isPollutionFluid(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        for (FluidStack pollutionFluidStack : this.pollutionFluidStacks) {
            if (!fluidStack.isFluidEqual(pollutionFluidStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<? extends IFluidStore> getFluidOutputSlots(FluidStack[] toOutput) {
        if (Arrays.stream(toOutput).anyMatch(this::isPollutionFluid)) {
            return GT_MetaTileEntity_ElectricBlastFurnace.filterValidMetaTileEntities(this.mPollutionOutputHatches);
        }
        return GT_MetaTileEntity_ElectricBlastFurnace.filterValidMetaTileEntities(this.mOutputHatches);
    }

    public int getPollutionReduction() {
        int reduction = 100;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_ElectricBlastFurnace.isValidMetaTileEntity(tHatch)) continue;
            reduction = Math.min(tHatch.calculatePollutionReduction(100), reduction);
        }
        return reduction;
    }

    protected void multiplyPollutionFluidAmount(@Nonnull FluidStack fluid) {
        fluid.amount = fluid.amount * Math.min(100 - this.getPollutionReduction() + 5, 100) / 100;
    }

    @Override
    public String[] getInfoData() {
        int mPollutionReduction = this.getPollutionReduction();
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_ElectricBlastFurnace.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers(-this.mEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.EBF.heat") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mHeatingCapacity) + EnumChatFormatting.RESET + " K", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.inputSeparation = !this.inputSeparation;
        GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("isBussesSeparate")) {
            this.inputSeparation = aNBT.func_74767_n("isBussesSeparate");
        }
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }
}

