/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.gui.GT_GUIColorOverride;
import gregtech.api.gui.modularui.FallbackableSteamTexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.ITurnable;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.api.net.GT_Packet_ClientPreference;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.ColorsMetadataSection;
import gregtech.api.util.ColorsMetadataSectionSerializer;
import gregtech.api.util.GT_ClientPreference;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_PlayedSound;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.GT_Proxy;
import gregtech.common.entities.GT_Entity_Arrow;
import gregtech.common.entities.GT_Entity_Arrow_Potion;
import gregtech.common.render.GT_CapeRenderer;
import gregtech.common.render.GT_FlaskRenderer;
import gregtech.common.render.GT_FluidDisplayStackRenderer;
import gregtech.common.render.GT_MetaGenerated_Tool_Renderer;
import gregtech.common.render.GT_MultiTile_Renderer;
import gregtech.common.render.GT_PollutionRenderer;
import gregtech.common.render.GT_Renderer_Block;
import gregtech.common.render.GT_Renderer_Entity_Arrow;
import gregtech.common.render.items.GT_MetaGenerated_Item_Renderer;
import gregtech.common.tileentities.debug.GT_MetaTileEntity_AdvDebugStructureWriter;
import gregtech.loaders.ExtraIcons;
import gregtech.loaders.misc.GT_Bees;
import gregtech.loaders.preload.GT_PreLoad;
import ic2.api.tile.IWrenchable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class GT_Client
extends GT_Proxy
implements Runnable {
    public static final String GTNH_CAPE_LIST_URL = "https://raw.githubusercontent.com/GTNewHorizons/CustomGTCapeHook-Cape-List/master/capes.txt";
    public static final String GT_CAPE_LIST_URL = "http://gregtech.overminddl1.com/com/gregoriust/gregtech/supporterlist.txt";
    private static final List<Block> ROTATABLE_VANILLA_BLOCKS;
    private static final int[][] GRID_SWITCH_TABLE;
    private static final Transformation ROTATION_MARKER_TRANSFORM_CENTER;
    private static final Transformation[] ROTATION_MARKER_TRANSFORMS_SIDES_TRANSFORMS;
    private static final int[] ROTATION_MARKER_TRANSFORMS_SIDES;
    private static final Transformation[] ROTATION_MARKER_TRANSFORMS_CORNER;
    private static int rotationMarkerDisplayList;
    private static boolean rotationMarkerDisplayListCompiled;
    private final HashSet<String> mCapeList = new HashSet();
    public static final GT_PollutionRenderer mPollutionRenderer;
    private final GT_CapeRenderer mCapeRenderer;
    private final List<Materials> mPosR;
    private final List<Materials> mPosG;
    private final List<Materials> mPosB;
    private final List<Materials> mPosA = Collections.emptyList();
    private final List<Materials> mNegR;
    private final List<Materials> mNegG;
    private final List<Materials> mNegB;
    private final List<Materials> mNegA = Collections.emptyList();
    private final List<Materials> mMoltenPosR;
    private final List<Materials> mMoltenPosG;
    private final List<Materials> mMoltenPosB;
    private final List<Materials> mMoltenPosA = Collections.emptyList();
    private final List<Materials> mMoltenNegR;
    private final List<Materials> mMoltenNegG;
    private final List<Materials> mMoltenNegB;
    private final List<Materials> mMoltenNegA = Collections.emptyList();
    private long mAnimationTick = 0L;
    private long afterSomeTime;
    private boolean mAnimationDirection = false;
    private GT_ClientPreference mPreference;
    private boolean mFirstTick = false;
    public static final int ROTATION_MARKER_RESOLUTION = 120;
    private int mReloadCount;
    private float renderTickTime;
    public static GT_MetaGenerated_Item_Renderer metaGeneratedItemRenderer;
    private static boolean checkedForChicken;
    public static int hideValue;
    public static int changeDetected;

    public GT_Client() {
        this.mCapeRenderer = new GT_CapeRenderer(this.mCapeList);
        this.mPosR = Arrays.asList(Materials.Enderium, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.Thaumium, Materials.InfusedVis, Materials.InfusedAir, Materials.InfusedFire, Materials.FierySteel, Materials.Firestone);
        this.mPosG = Arrays.asList(Materials.Enderium, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.InfusedAir, Materials.InfusedEarth);
        this.mPosB = Arrays.asList(Materials.Enderium, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.InfusedVis, Materials.InfusedWater, Materials.Thaumium);
        this.mNegR = Arrays.asList(Materials.InfusedEntropy, Materials.NetherStar);
        this.mNegG = Arrays.asList(Materials.InfusedEntropy, Materials.NetherStar);
        this.mNegB = Arrays.asList(Materials.InfusedEntropy, Materials.NetherStar);
        this.mMoltenPosR = Arrays.asList(Materials.Enderium, Materials.NetherStar, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.Thaumium, Materials.InfusedVis, Materials.InfusedAir, Materials.InfusedFire, Materials.FierySteel, Materials.Firestone);
        this.mMoltenPosG = Arrays.asList(Materials.Enderium, Materials.NetherStar, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.Force, Materials.Pyrotheum, Materials.Sunnarium, Materials.Glowstone, Materials.InfusedAir, Materials.InfusedEarth);
        this.mMoltenPosB = Arrays.asList(Materials.Enderium, Materials.NetherStar, Materials.Vinteum, Materials.Uranium235, Materials.InfusedGold, Materials.Plutonium241, Materials.NaquadahEnriched, Materials.Naquadria, Materials.InfusedOrder, Materials.InfusedVis, Materials.InfusedWater, Materials.Thaumium);
        this.mMoltenNegR = Collections.singletonList(Materials.InfusedEntropy);
        this.mMoltenNegG = Collections.singletonList(Materials.InfusedEntropy);
        this.mMoltenNegB = Collections.singletonList(Materials.InfusedEntropy);
    }

    private static void drawGrid(DrawBlockHighlightEvent aEvent, boolean showCoverConnections, boolean aIsWrench, boolean aIsSneaking) {
        IAlignment tAlignment;
        if (!checkedForChicken) {
            try {
                Class.forName("codechicken.lib.vec.Rotation");
            }
            catch (ClassNotFoundException e) {
                return;
            }
            checkedForChicken = true;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-(aEvent.player.field_70142_S + (aEvent.player.field_70165_t - aEvent.player.field_70142_S) * (double)aEvent.partialTicks)), (double)(-(aEvent.player.field_70137_T + (aEvent.player.field_70163_u - aEvent.player.field_70137_T) * (double)aEvent.partialTicks)), (double)(-(aEvent.player.field_70136_U + (aEvent.player.field_70161_v - aEvent.player.field_70136_U) * (double)aEvent.partialTicks)));
        GL11.glTranslated((double)((float)aEvent.target.field_72311_b + 0.5f), (double)((float)aEvent.target.field_72312_c + 0.5f), (double)((float)aEvent.target.field_72309_d + 0.5f));
        int tSideHit = aEvent.target.field_72310_e;
        Rotation.sideRotations[tSideHit].glApply();
        GL11.glTranslated((double)0.0, (double)-0.501, (double)0.0);
        GL11.glLineWidth((float)2.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.25);
        GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.25);
        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.25);
        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.25);
        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.5);
        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.5);
        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.5);
        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.5);
        TileEntity tTile = aEvent.player.field_70170_p.func_147438_o(aEvent.target.field_72311_b, aEvent.target.field_72312_c, aEvent.target.field_72309_d);
        int tConnections = 0;
        if (tTile instanceof ICoverable) {
            ForgeDirection[] iCoverable = (ForgeDirection[])tTile;
            if (showCoverConnections) {
                ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
                int n = forgeDirectionArray.length;
                for (int i = 0; i < n; ++i) {
                    ForgeDirection tSide = forgeDirectionArray[i];
                    if (iCoverable.getCoverIDAtSide(tSide) == 0) continue;
                    tConnections |= tSide.flag;
                }
            } else if (tTile instanceof BaseMetaPipeEntity) {
                tConnections = ((BaseMetaPipeEntity)tTile).mConnections;
            }
        }
        if (tConnections != 0) {
            block11: for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
                if ((tConnections & tSide.flag) == 0) continue;
                switch (GRID_SWITCH_TABLE[aEvent.target.field_72310_e][tSide.ordinal()]) {
                    case 0: {
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.25);
                        continue block11;
                    }
                    case 1: {
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.5);
                        continue block11;
                    }
                    case 2: {
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.25);
                        continue block11;
                    }
                    case 3: {
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.5);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.5);
                        continue block11;
                    }
                    case 4: {
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.25);
                        continue block11;
                    }
                    case 5: {
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.5);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)0.5, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)0.25, (double)0.0, (double)-0.5);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)0.5);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.5);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.5, (double)0.0, (double)-0.25);
                        GL11.glVertex3d((double)-0.25, (double)0.0, (double)-0.5);
                    }
                }
            }
        }
        GL11.glEnd();
        if (aIsWrench && tTile instanceof IAlignmentProvider && (tAlignment = ((IAlignmentProvider)tTile).getAlignment()) != null) {
            ForgeDirection direction = tAlignment.getDirection();
            if (direction.ordinal() == tSideHit) {
                GT_Client.drawExtendedRotationMarker(ROTATION_MARKER_TRANSFORM_CENTER, aIsSneaking, false);
            } else if (direction.getOpposite().ordinal() == tSideHit) {
                for (Transformation t : ROTATION_MARKER_TRANSFORMS_CORNER) {
                    GT_Client.drawExtendedRotationMarker(t, aIsSneaking, true);
                }
            } else {
                GT_Client.drawExtendedRotationMarker(ROTATION_MARKER_TRANSFORMS_SIDES_TRANSFORMS[ROTATION_MARKER_TRANSFORMS_SIDES[tSideHit * 6 + direction.ordinal()]], aIsSneaking, true);
            }
        }
        GL11.glPopMatrix();
    }

    private static void drawExtendedRotationMarker(Transformation transform, boolean sneaking, boolean small) {
        if (sneaking) {
            GT_Client.drawFlipMarker(transform);
        } else {
            GT_Client.drawRotationMarker(transform);
        }
    }

    private static void drawRotationMarker(Transformation transform) {
        if (!rotationMarkerDisplayListCompiled) {
            rotationMarkerDisplayList = GLAllocation.func_74526_a((int)1);
            GT_Client.compileRotationMarkerDisplayList(rotationMarkerDisplayList);
            rotationMarkerDisplayListCompiled = true;
        }
        GL11.glPushMatrix();
        transform.glApply();
        GL11.glCallList((int)rotationMarkerDisplayList);
        GL11.glPopMatrix();
    }

    private static void compileRotationMarkerDisplayList(int displayList) {
        int i;
        GL11.glNewList((int)displayList, (int)4864);
        GL11.glBegin((int)2);
        for (i = 0; i <= 120; ++i) {
            GL11.glVertex3d((double)(Math.cos((double)i * Math.PI * 1.75 / 120.0) * 0.4), (double)0.0, (double)(Math.sin((double)i * Math.PI * 1.75 / 120.0) * 0.4));
        }
        for (i = 120; i >= 0; --i) {
            GL11.glVertex3d((double)(Math.cos((double)i * Math.PI * 1.75 / 120.0) * 0.24), (double)0.0, (double)(Math.sin((double)i * Math.PI * 1.75 / 120.0) * 0.24));
        }
        GL11.glVertex3d((double)0.1411145618, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.32, (double)0.0, (double)-0.178885438199);
        GL11.glVertex3d((double)0.498885438199, (double)0.0, (double)0.0);
        GL11.glEnd();
        GL11.glEndList();
    }

    private static void drawFlipMarker(Transformation transform) {
        GL11.glPushMatrix();
        transform.glApply();
        Tessellator t = Tessellator.field_78398_a;
        GL11.glLineStipple((int)4, (short)-21846);
        GL11.glEnable((int)2852);
        t.func_78371_b(3);
        t.func_78377_a(0.1, 0.0, 0.04);
        t.func_78377_a(0.1, 0.0, 0.2);
        t.func_78377_a(0.35, 0.0, 0.35);
        t.func_78377_a(0.35, 0.0, -0.35);
        t.func_78377_a(0.1, 0.0, -0.2);
        t.func_78377_a(0.1, 0.0, -0.04);
        t.func_78381_a();
        GL11.glDisable((int)2852);
        t.func_78371_b(3);
        t.func_78377_a(-0.1, 0.0, 0.04);
        t.func_78377_a(-0.1, 0.0, 0.2);
        t.func_78377_a(-0.35, 0.0, 0.35);
        t.func_78377_a(-0.35, 0.0, -0.35);
        t.func_78377_a(-0.1, 0.0, -0.2);
        t.func_78377_a(-0.1, 0.0, -0.04);
        t.func_78381_a();
        t.func_78371_b(2);
        t.func_78377_a(0.15, 0.0, -0.04);
        t.func_78377_a(0.15, 0.0, -0.1);
        t.func_78377_a(0.25, 0.0, 0.0);
        t.func_78377_a(0.15, 0.0, 0.1);
        t.func_78377_a(0.15, 0.0, 0.04);
        t.func_78377_a(-0.15, 0.0, 0.04);
        t.func_78377_a(-0.15, 0.0, 0.1);
        t.func_78377_a(-0.25, 0.0, 0.0);
        t.func_78377_a(-0.15, 0.0, -0.1);
        t.func_78377_a(-0.15, 0.0, -0.04);
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    @Override
    public boolean isServerSide() {
        return true;
    }

    @Override
    public boolean isClientSide() {
        return true;
    }

    @Override
    public boolean isBukkitSide() {
        return false;
    }

    @Override
    public EntityPlayer getThePlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public int addArmor(String aPrefix) {
        return RenderingRegistry.addNewArmourRendererPrefix((String)aPrefix);
    }

    @Override
    public void onPreLoad() {
        String[] arr;
        super.onPreLoad();
        MinecraftForge.EVENT_BUS.register((Object)new ExtraIcons());
        Minecraft.func_71410_x().func_110438_M().field_110621_c.func_110504_a((IMetadataSectionSerializer)new ColorsMetadataSectionSerializer(), ColorsMetadataSection.class);
        new GT_MetaTileEntity_AdvDebugStructureWriter.ForgeEventHandler();
        for (String tName : arr = new String[]{"renadi", "hanakocz", "MysteryDump", "Flaver4", "x_Fame", "Peluche321", "Goshen_Ithilien", "manf", "Bimgo", "leagris", "IAmMinecrafter02", "Cerous", "Devilin_Pixy", "Bkarlsson87", "BadAlchemy", "CaballoCraft", "melanclock", "Resursator", "demanzke", "AndrewAmmerlaan", "Deathlycraft", "Jirajha", "Axlegear", "kei_kouma", "Dracion", "dungi", "Dorfschwein", "Zero Tw0", "mattiagraz85", "sebastiank30", "Plem", "invultri", "grillo126", "malcanteth", "Malevolence_", "Nicholas_Manuel", "Sirbab", "kehaan", "bpgames123", "semig0d", "9000bowser", "Sovereignty89", "Kris1432", "xander_cage_", "samuraijp", "bsaa", "SpwnX", "tworf", "Kadah", "kanni", "Stute", "Hegik", "Onlyme", "t3hero", "Hotchi", "jagoly", "Nullav", "BH5432", "Sibmer", "inceee", "foxxx0", "Hartok", "TMSama", "Shlnen", "Carsso", "zessirb", "meep310", "Seldron", "yttr1um", "hohounk", "freebug", "Sylphio", "jmarler", "Saberawr", "r00teniy", "Neonbeta", "yinscape", "voooon24", "Quintine", "peach774", "lepthymo", "bildeman", "Kremnari", "Aerosalo", "OndraSter", "oscares91", "mr10movie", "Daxx367x2", "EGERTRONx", "aka13_404", "Abouttabs", "Johnstaal", "djshiny99", "megatronp", "DZCreeper", "Kane_Hart", "Truculent", "vidplace7", "simon6689", "MomoNasty", "UnknownXLV", "goreacraft", "Fluttermine", "Daddy_Cecil", "MrMaleficus", "TigersFangs", "cublikefoot", "chainman564", "NikitaBuker", "Misha999777", "25FiveDetail", "AntiCivilBoy", "michaelbrady", "xXxIceFirexXx", "Speedynutty68", "GarretSidzaka", "HallowCharm977", "mastermind1919", "The_Hypersonic", "diamondguy2798", "zF4ll3nPr3d4t0r", "CrafterOfMines57", "XxELIT3xSNIP3RxX", "SuterusuKusanagi", "xavier0014", "adamros", "alexbegt"}) {
            this.mCapeList.add(tName.toLowerCase());
        }
        new Thread(this).start();
        mPollutionRenderer.preLoad();
        this.mPreference = new GT_ClientPreference(GregTech_API.sClientDataFile);
        Materials.initClient();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        new GT_Renderer_Block();
        new GT_MultiTile_Renderer();
        metaGeneratedItemRenderer = new GT_MetaGenerated_Item_Renderer();
        for (GT_MetaGenerated_Item item : GT_MetaGenerated_Item.sInstances.values()) {
            metaGeneratedItemRenderer.registerItem(item);
        }
        if (Mods.Forestry.isModLoaded()) {
            metaGeneratedItemRenderer.registerItem(GT_Bees.combs);
        }
        new GT_MetaGenerated_Tool_Renderer();
        new GT_Renderer_Entity_Arrow(GT_Entity_Arrow.class, "arrow");
        new GT_Renderer_Entity_Arrow(GT_Entity_Arrow_Potion.class, "arrow_potions");
        new GT_FlaskRenderer();
        new GT_FluidDisplayStackRenderer();
    }

    @Override
    public void onPostLoad() {
        super.onPostLoad();
        if (GregTech_API.sClientDataFile.get((Object)"debug", "PrintMetaIDs", false)) {
            try {
                for (int i = 1; i < GregTech_API.METATILEENTITIES.length; ++i) {
                    try {
                        if (GregTech_API.METATILEENTITIES[i] == null) continue;
                        GregTech_API.METATILEENTITIES[i].getStackForm(1L).func_82840_a(null, true);
                        GT_Log.out.println("META " + i + " " + GregTech_API.METATILEENTITIES[i].getMetaName());
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace(GT_Log.err);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
        }
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager l) {
                GT_GUIColorOverride.onResourceManagerReload();
                FallbackableSteamTexture.reload();
                GregTech_API.sCoverBehaviors.values().forEach(GT_CoverBehaviorBase::reloadColorOverride);
            }
        });
    }

    @Override
    public void run() {
        Scanner tScanner;
        GT_Log.out.println("GT_Mod: Downloading Cape List.");
        try {
            tScanner = new Scanner(new URL(GT_CAPE_LIST_URL).openStream());
            try {
                while (tScanner.hasNextLine()) {
                    this.mCapeList.add(tScanner.nextLine().toLowerCase());
                }
            }
            finally {
                tScanner.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        GT_Log.out.println("GT New Horizons: Downloading Cape List.");
        try {
            tScanner = new Scanner(new URL(GTNH_CAPE_LIST_URL).openStream());
            try {
                while (tScanner.hasNextLine()) {
                    String tName = tScanner.nextLine().toLowerCase();
                    if (tName.contains(":")) {
                        if (this.mCapeList.contains(tName.substring(0, tName.indexOf(":")))) continue;
                        this.mCapeList.add(tName);
                        continue;
                    }
                    this.mCapeList.add(tName);
                }
            }
            finally {
                tScanner.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
    }

    @Override
    @SubscribeEvent
    public void onClientConnectedToServerEvent(FMLNetworkEvent.ClientConnectedToServerEvent aEvent) {
        this.mFirstTick = true;
        ++this.mReloadCount;
        GT_Values.calculateMaxPlasmaTurbineEfficiency();
    }

    @Override
    public int getReloadCount() {
        return this.mReloadCount;
    }

    @SubscribeEvent
    public void receiveRenderSpecialsEvent(RenderPlayerEvent.Specials.Pre aEvent) {
        this.mCapeRenderer.receiveRenderSpecialsEvent(aEvent);
    }

    @SubscribeEvent
    public void onPlayerTickEventClient(TickEvent.PlayerTickEvent aEvent) {
        if (aEvent.side.isClient() && aEvent.phase == TickEvent.Phase.END && !aEvent.player.field_70128_L) {
            if (this.mFirstTick) {
                this.mFirstTick = false;
                GT_Values.NW.sendToServer(new GT_Packet_ClientPreference(this.mPreference));
                if (!Minecraft.func_71410_x().func_71356_B()) {
                    GT_ModHandler.addIC2RecipesToGT(GT_ModHandler.getMaceratorRecipeList(), GT_Recipe.GT_Recipe_Map.sMaceratorRecipes, true, true, true);
                    GT_ModHandler.addIC2RecipesToGT(GT_ModHandler.getCompressorRecipeList(), GT_Recipe.GT_Recipe_Map.sCompressorRecipes, true, true, true);
                    GT_ModHandler.addIC2RecipesToGT(GT_ModHandler.getExtractorRecipeList(), GT_Recipe.GT_Recipe_Map.sExtractorRecipes, true, true, true);
                    GT_ModHandler.addIC2RecipesToGT(GT_ModHandler.getOreWashingRecipeList(), GT_Recipe.GT_Recipe_Map.sOreWasherRecipes, false, true, true);
                    GT_ModHandler.addIC2RecipesToGT(GT_ModHandler.getThermalCentrifugeRecipeList(), GT_Recipe.GT_Recipe_Map.sThermalCentrifugeRecipes, true, true, true);
                }
            }
            ++this.afterSomeTime;
            if (this.afterSomeTime >= 100L) {
                this.afterSomeTime = 0L;
                for (GT_Recipe recipe : GT_Recipe.GT_Recipe_Map.sAssemblylineVisualRecipes.mRecipeList) {
                    recipe.mHidden = false;
                }
            }
            Iterator<Map.Entry<GT_PlayedSound, Integer>> iterator = GT_Utility.sPlayedSoundMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<GT_PlayedSound, Integer> tEntry = iterator.next();
                if (tEntry.getValue() < 0) {
                    iterator.remove();
                    continue;
                }
                tEntry.setValue(tEntry.getValue() - 1);
            }
            if (!GregTech_API.mServerStarted) {
                GregTech_API.mServerStarted = true;
            }
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (Mods.GregTech.ID.equals(e.modID) && "client".equals(e.configID)) {
            GregTech_API.sClientDataFile.mConfig.save();
            this.mPreference = new GT_ClientPreference(GregTech_API.sClientDataFile);
            GT_PreLoad.loadClientConfig();
            if (e.isWorldRunning) {
                GT_Values.NW.sendToServer(new GT_Packet_ClientPreference(this.mPreference));
            }
        }
    }

    @SubscribeEvent
    public void onDrawBlockHighlight(DrawBlockHighlightEvent aEvent) {
        Block aBlock = aEvent.player.field_70170_p.func_147439_a(aEvent.target.field_72311_b, aEvent.target.field_72312_c, aEvent.target.field_72309_d);
        TileEntity aTileEntity = aEvent.player.field_70170_p.func_147438_o(aEvent.target.field_72311_b, aEvent.target.field_72312_c, aEvent.target.field_72309_d);
        if (GT_Utility.isStackInList(aEvent.currentItem, GregTech_API.sWrenchList)) {
            if (aTileEntity instanceof ITurnable || ROTATABLE_VANILLA_BLOCKS.contains(aBlock) || aTileEntity instanceof IWrenchable) {
                GT_Client.drawGrid(aEvent, false, true, aEvent.player.func_70093_af());
            }
            return;
        }
        if (!(aTileEntity instanceof ICoverable)) {
            return;
        }
        if (GT_Utility.isStackInList(aEvent.currentItem, GregTech_API.sWireCutterList) || GT_Utility.isStackInList(aEvent.currentItem, GregTech_API.sSolderingToolList) || GT_Utility.isStackInList(aEvent.currentItem, GregTech_API.sSoftHammerList) && aTileEntity instanceof MultiBlockPart && aEvent.player.func_70093_af()) {
            if (((ICoverable)aTileEntity).getCoverIDAtSide(ForgeDirection.getOrientation((int)aEvent.target.field_72310_e)) == 0) {
                GT_Client.drawGrid(aEvent, false, false, aEvent.player.func_70093_af());
            }
            return;
        }
        if (aEvent.currentItem == null && aEvent.player.func_70093_af() || GT_Utility.isStackInList(aEvent.currentItem, GregTech_API.sCrowbarList) || GT_Utility.isStackInList(aEvent.currentItem, GregTech_API.sScrewdriverList)) {
            if (((ICoverable)aTileEntity).getCoverIDAtSide(ForgeDirection.getOrientation((int)aEvent.target.field_72310_e)) == 0) {
                for (ForgeDirection tSide : ForgeDirection.VALID_DIRECTIONS) {
                    if (((ICoverable)aTileEntity).getCoverIDAtSide(tSide) <= 0) continue;
                    GT_Client.drawGrid(aEvent, true, false, true);
                    return;
                }
            }
            return;
        }
        if (GT_Utility.isStackInList(aEvent.currentItem, GregTech_API.sCovers.keySet()) && ((ICoverable)aTileEntity).getCoverIDAtSide(ForgeDirection.getOrientation((int)aEvent.target.field_72310_e)) == 0) {
            GT_Client.drawGrid(aEvent, true, false, aEvent.player.func_70093_af());
        }
        if (GT_Utility.areStacksEqual(ItemList.Tool_Cover_Copy_Paste.get(1L, new Object[0]), aEvent.currentItem, true) && ((ICoverable)aTileEntity).getCoverIDAtSide(ForgeDirection.getOrientation((int)aEvent.target.field_72310_e)) == 0) {
            GT_Client.drawGrid(aEvent, true, false, aEvent.player.func_70093_af());
        }
    }

    @SubscribeEvent
    public void receiveRenderEvent(RenderPlayerEvent.Pre aEvent) {
        if (GT_Utility.getFullInvisibility(aEvent.entityPlayer)) {
            aEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderStart(TickEvent.RenderTickEvent aEvent) {
        if (aEvent.phase == TickEvent.Phase.START) {
            this.renderTickTime = aEvent.renderTickTime;
        }
    }

    @SubscribeEvent
    public void onClientTickEvent(TickEvent.ClientTickEvent aEvent) {
        if (aEvent.phase == TickEvent.Phase.END) {
            int newHideValue;
            if (changeDetected > 0) {
                --changeDetected;
            }
            if ((newHideValue = GT_Client.shouldHeldItemHideThings()) != hideValue) {
                hideValue = newHideValue;
                changeDetected = 5;
            }
            ++this.mAnimationTick;
            if (this.mAnimationTick % 50L == 0L) {
                this.mAnimationDirection = !this.mAnimationDirection;
            }
            int tDirection = this.mAnimationDirection ? 1 : -1;
            for (Materials tMaterial : this.mPosR) {
                tMaterial.mRGBa[0] = this.getSafeRGBValue(tMaterial.mRGBa[0], tDirection);
            }
            for (Materials tMaterial : this.mPosG) {
                tMaterial.mRGBa[1] = this.getSafeRGBValue(tMaterial.mRGBa[1], tDirection);
            }
            for (Materials tMaterial : this.mPosB) {
                tMaterial.mRGBa[2] = this.getSafeRGBValue(tMaterial.mRGBa[2], tDirection);
            }
            for (Materials tMaterial : this.mPosA) {
                tMaterial.mRGBa[3] = this.getSafeRGBValue(tMaterial.mRGBa[3], tDirection);
            }
            for (Materials tMaterial : this.mNegR) {
                tMaterial.mRGBa[0] = this.getSafeRGBValue(tMaterial.mRGBa[0], -tDirection);
            }
            for (Materials tMaterial : this.mNegG) {
                tMaterial.mRGBa[1] = this.getSafeRGBValue(tMaterial.mRGBa[1], -tDirection);
            }
            for (Materials tMaterial : this.mNegB) {
                tMaterial.mRGBa[2] = this.getSafeRGBValue(tMaterial.mRGBa[2], -tDirection);
            }
            for (Materials tMaterial : this.mNegA) {
                tMaterial.mRGBa[3] = this.getSafeRGBValue(tMaterial.mRGBa[3], -tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosR) {
                tMaterial.mMoltenRGBa[0] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[0], tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosG) {
                tMaterial.mMoltenRGBa[1] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[1], tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosB) {
                tMaterial.mMoltenRGBa[2] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[2], tDirection);
            }
            for (Materials tMaterial : this.mMoltenPosA) {
                tMaterial.mMoltenRGBa[3] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[3], tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegR) {
                tMaterial.mMoltenRGBa[0] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[0], -tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegG) {
                tMaterial.mMoltenRGBa[1] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[1], -tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegB) {
                tMaterial.mMoltenRGBa[2] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[2], -tDirection);
            }
            for (Materials tMaterial : this.mMoltenNegA) {
                tMaterial.mMoltenRGBa[3] = this.getSafeRGBValue(tMaterial.mMoltenRGBa[3], -tDirection);
            }
        }
    }

    public short getSafeRGBValue(short aRBG, int aDelta) {
        int tmp = aRBG + aDelta;
        if (tmp > 255) {
            tmp = 255;
        }
        if (tmp < 0) {
            tmp = 0;
        }
        return (short)tmp;
    }

    @Override
    public long getAnimationTicks() {
        return this.mAnimationTick;
    }

    @Override
    public float getPartialRenderTicks() {
        return this.renderTickTime;
    }

    @Override
    public void doSonictronSound(ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return;
        }
        String tString = SoundResource.NOTE_HARP.toString();
        int j = this.mSoundItems.size();
        for (int i = 0; i < j; ++i) {
            if (!GT_Utility.areStacksEqual((ItemStack)this.mSoundItems.get(i), aStack)) continue;
            tString = (String)this.mSoundNames.get(i);
            break;
        }
        if (tString.startsWith(SoundResource.RANDOM_EXPLODE.toString())) {
            if (aStack.field_77994_a == 3) {
                tString = SoundResource.RANDOM_FUSE.toString();
            } else if (aStack.field_77994_a == 2) {
                tString = "random.old_explode";
            }
        }
        if (tString.startsWith("streaming.")) {
            switch (aStack.field_77994_a) {
                case 1: {
                    String string = tString + "13";
                    break;
                }
                case 2: {
                    String string = tString + "cat";
                    break;
                }
                case 3: {
                    String string = tString + "blocks";
                    break;
                }
                case 4: {
                    String string = tString + "chirp";
                    break;
                }
                case 5: {
                    String string = tString + "far";
                    break;
                }
                case 6: {
                    String string = tString + "mall";
                    break;
                }
                case 7: {
                    String string = tString + "mellohi";
                    break;
                }
                case 8: {
                    String string = tString + "stal";
                    break;
                }
                case 9: {
                    String string = tString + "strad";
                    break;
                }
                case 10: {
                    String string = tString + "ward";
                    break;
                }
                case 11: {
                    String string = tString + "11";
                    break;
                }
                case 12: {
                    String string = tString + "wait";
                    break;
                }
                default: {
                    String string = tString = tString + "wherearewenow";
                }
            }
        }
        if (tString.startsWith("streaming.")) {
            new WorldSpawnedEventBuilder.RecordEffectEventBuilder().setIdentifier(tString.substring(10)).setPosition(aX, aY, aZ).run();
        } else {
            new WorldSpawnedEventBuilder.SoundEventBuilder().setVolume(3.0f).setPitch(tString.startsWith("note.") ? (float)Math.pow(2.0, (double)(aStack.field_77994_a - 13) / 12.0) : 1.0f).setIdentifier(tString).setPosition(aX, aY, aZ).run();
        }
    }

    private static int shouldHeldItemHideThings() {
        try {
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return 0;
            }
            ItemStack tCurrentItem = player.func_71045_bC();
            if (tCurrentItem == null) {
                return 0;
            }
            int[] ids = OreDictionary.getOreIDs((ItemStack)tCurrentItem);
            int hide = 0;
            for (int i : ids) {
                if (!OreDictionary.getOreName((int)i).equals("craftingToolSolderingIron")) continue;
                hide |= 1;
                break;
            }
            if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWrenchList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sScrewdriverList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sHardHammerList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSoftHammerList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWireCutterList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSolderingToolList) || GT_Utility.isStackInList(tCurrentItem, GregTech_API.sCrowbarList) || GregTech_API.sCovers.containsKey(new GT_ItemStack(tCurrentItem))) {
                hide |= 2;
            }
            return hide;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void recieveChunkPollutionPacket(ChunkCoordIntPair chunk, int pollution) {
        mPollutionRenderer.processPacket(chunk, pollution);
    }

    static {
        GRID_SWITCH_TABLE = new int[][]{{0, 5, 3, 1, 2, 4}, {5, 0, 1, 3, 2, 4}, {1, 3, 0, 5, 2, 4}, {3, 1, 5, 0, 2, 4}, {4, 2, 3, 1, 0, 5}, {2, 4, 3, 1, 5, 0}};
        ROTATION_MARKER_TRANSFORM_CENTER = new Scale(0.5);
        ROTATION_MARKER_TRANSFORMS_SIDES_TRANSFORMS = new Transformation[]{new Scale(0.25).with((Transformation)new Translation(0.0, 0.0, 0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(0.375, 0.0, 0.0)).compile(), new Scale(0.25).with((Transformation)new Translation(0.0, 0.0, -0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(-0.375, 0.0, 0.0)).compile()};
        ROTATION_MARKER_TRANSFORMS_SIDES = new int[]{-1, -1, 2, 0, 3, 1, -1, -1, 0, 2, 3, 1, 0, 2, -1, -1, 3, 1, 2, 0, -1, -1, 3, 1, 1, 3, 2, 0, -1, -1, 3, 1, 2, 0, -1, -1};
        ROTATION_MARKER_TRANSFORMS_CORNER = new Transformation[]{new Scale(0.25).with((Transformation)new Translation(0.375, 0.0, 0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(-0.375, 0.0, 0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(0.375, 0.0, -0.375)).compile(), new Scale(0.25).with((Transformation)new Translation(-0.375, 0.0, -0.375)).compile()};
        rotationMarkerDisplayListCompiled = false;
        ROTATABLE_VANILLA_BLOCKS = Arrays.asList(Blocks.field_150331_J, Blocks.field_150320_F, Blocks.field_150460_al, Blocks.field_150470_am, Blocks.field_150409_cd, Blocks.field_150367_z, Blocks.field_150486_ae, Blocks.field_150447_bR, Blocks.field_150477_bB, Blocks.field_150438_bZ, Blocks.field_150423_aK, Blocks.field_150428_aP);
        mPollutionRenderer = new GT_PollutionRenderer();
        checkedForChicken = false;
        hideValue = 0;
        changeDetected = 0;
    }
}

