/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import com.google.common.math.LongMath;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DropDownWidget;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.fluid.FluidTankGT;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.logic.PowerLogic;
import gregtech.api.logic.interfaces.PowerLogicHost;
import gregtech.api.multitileentity.base.NonTickableMultiTileEntity;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.interfaces.IMultiBlockPart;
import gregtech.api.multitileentity.interfaces.IMultiTileEntity;
import gregtech.api.net.GT_Packet_MultiTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.common.covers.CoverInfo;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.ObjectUtils;

public abstract class MultiBlockPart
extends NonTickableMultiTileEntity
implements IMultiBlockPart,
IMultiTileEntity.IMTE_BreakBlock,
IMultiTileEntity.IMTE_HasModes,
PowerLogicHost {
    public static final int NOTHING = 0;
    public static final int ENERGY_IN = GT_Values.B[0];
    public static final int ENERGY_OUT = GT_Values.B[1];
    public static final int FLUID_IN = GT_Values.B[2];
    public static final int FLUID_OUT = GT_Values.B[3];
    public static final int ITEM_IN = GT_Values.B[4];
    public static final int ITEM_OUT = GT_Values.B[5];
    protected final List<Integer> BASIC_MODES = new ArrayList<Integer>(Arrays.asList(0, ENERGY_IN, ENERGY_OUT, FLUID_IN, FLUID_OUT, ITEM_IN, ITEM_OUT));
    protected ChunkCoordinates mTargetPos = null;
    protected IMultiBlockController target = null;
    protected int mAllowedModes = 0;
    protected byte mMode = 0;
    protected String mLockedInventory = "";
    protected int mLockedInventoryIndex = 0;
    protected FluidTankGT configurationTank = new FluidTankGT();

    public int getPartTier() {
        return 1;
    }

    public String getLockedInventory() {
        IMultiBlockController controller = this.getTarget(false);
        if (this.modeSelected(ITEM_IN) || this.modeSelected(ITEM_OUT)) {
            if (!this.getNameOfInventoryFromIndex(controller, this.mLockedInventoryIndex).equals(this.mLockedInventory)) {
                this.mLockedInventory = this.getNameOfInventoryFromIndex(controller, this.mLockedInventoryIndex);
                if (this.mLockedInventory.equals("all")) {
                    this.mLockedInventory = "";
                }
            }
        } else if (!this.getNameOfTankArrayFromIndex(controller, this.mLockedInventoryIndex).equals(this.mLockedInventory)) {
            this.mLockedInventory = this.getNameOfTankArrayFromIndex(controller, this.mLockedInventoryIndex);
            if (this.mLockedInventory.equals("all")) {
                this.mLockedInventory = "";
            }
        }
        return this.mLockedInventory.equals("") ? null : this.mLockedInventory;
    }

    public void setTarget(IMultiBlockController aTarget, int aAllowedModes) {
        this.target = aTarget;
        this.mTargetPos = this.target == null ? null : this.target.getCoords();
        this.mAllowedModes = aAllowedModes;
        if (this.target != null) {
            this.registerCovers(this.target);
        }
    }

    @Override
    protected void addDebugInfo(EntityPlayer aPlayer, int aLogLevel, ArrayList<String> tList) {
        IMultiBlockController controller = this.getTarget(false);
        if (controller != null) {
            tList.add("Has controller");
        } else {
            tList.add("No Controller");
        }
        tList.add("Casing Mode: " + this.getModeName(this.mMode));
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        currentTip.add(String.format("Mode: %s", this.getModeName(this.mMode)));
        if (this.modeSelected(FLUID_OUT)) {
            if (this.configurationTank != null && this.configurationTank.get() != null) {
                currentTip.add(String.format("Locked to: %s", this.configurationTank.get().getLocalizedName()));
            } else {
                currentTip.add("Locked to: Nothing");
            }
        }
    }

    public IMultiBlockController getTarget(boolean aCheckValidity) {
        if (this.mTargetPos == null) {
            return null;
        }
        if ((this.target == null || this.target.isDead()) && this.field_145850_b.func_72899_e(this.mTargetPos.field_71574_a, this.mTargetPos.field_71572_b, this.mTargetPos.field_71573_c)) {
            TileEntity te = this.field_145850_b.func_147438_o(this.mTargetPos.field_71574_a, this.mTargetPos.field_71572_b, this.mTargetPos.field_71573_c);
            if (te instanceof IMultiBlockController) {
                this.target = (IMultiBlockController)te;
                this.registerCovers(this.target);
            } else {
                this.mTargetPos = null;
            }
        }
        if (aCheckValidity) {
            return this.target != null && this.target.checkStructure(false) ? this.target : null;
        }
        return this.target;
    }

    public void registerCovers(IMultiBlockController controller) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            CoverInfo coverInfo = this.getCoverInfoAtSide(side);
            if (!coverInfo.isValid() || coverInfo.getTickRate() <= 0) continue;
            controller.registerCoveredPartOnSide(side, this);
        }
    }

    @Override
    public void setCoverItemAtSide(ForgeDirection side, ItemStack aCover) {
        CoverInfo coverInfo;
        super.setCoverItemAtSide(side, aCover);
        IMultiBlockController tTarget = this.getTarget(true);
        if (tTarget != null && (coverInfo = this.getCoverInfoAtSide(side)).isValid() && coverInfo.getTickRate() > 0) {
            tTarget.registerCoveredPartOnSide(side, this);
        }
    }

    public void unregisterCovers(IMultiBlockController controller) {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.getCoverInfoAtSide(side).isValid()) continue;
            controller.unregisterCoveredPartOnSide(side, this);
        }
    }

    @Override
    public boolean dropCover(ForgeDirection side, ForgeDirection droppedSide, boolean aForced) {
        boolean res = super.dropCover(side, droppedSide, aForced);
        IMultiBlockController tTarget = this.getTarget(true);
        if (tTarget != null) {
            tTarget.unregisterCoveredPartOnSide(side, this);
        }
        return res;
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("gt.amode")) {
            this.mAllowedModes = aNBT.func_74762_e("gt.amode");
        }
        if (aNBT.func_74764_b("gt.mode")) {
            this.mMode = aNBT.func_74771_c("gt.mode");
        }
        if (aNBT.func_74764_b("gt.target")) {
            this.mTargetPos = new ChunkCoordinates(aNBT.func_74762_e("gt.target.x"), (int)aNBT.func_74765_d("gt.target.y"), aNBT.func_74762_e("gt.target.z"));
        }
        if (aNBT.func_74764_b("gt.locked.inv")) {
            this.mLockedInventory = aNBT.func_74779_i("gt.locked.inv");
        }
        if (aNBT.func_74764_b("gt.locked.inv.index")) {
            this.mLockedInventoryIndex = aNBT.func_74762_e("gt.locked.inv.index");
        }
        if (aNBT.func_74764_b("gt.locked.fluid")) {
            this.configurationTank.readFromNBT(aNBT, "gt.locked.fluid");
        }
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound aNBT) {
        if (this.mAllowedModes != 0) {
            aNBT.func_74768_a("gt.amode", this.mAllowedModes);
        }
        if (this.mMode != 0) {
            aNBT.func_74768_a("gt.mode", (int)this.mMode);
        }
        if (this.mTargetPos != null) {
            aNBT.func_74757_a("gt.target", true);
            aNBT.func_74768_a("gt.target.x", this.mTargetPos.field_71574_a);
            aNBT.func_74777_a("gt.target.y", (short)this.mTargetPos.field_71572_b);
            aNBT.func_74768_a("gt.target.z", this.mTargetPos.field_71573_c);
        }
        if (this.mLockedInventory != null) {
            aNBT.func_74778_a("gt.locked.inv", this.mLockedInventory);
        }
        if (this.mLockedInventoryIndex != 0) {
            aNBT.func_74768_a("gt.locked.inv.index", this.mLockedInventoryIndex);
        }
        this.configurationTank.writeToNBT(aNBT, "gt.locked.fluid");
    }

    @Override
    public GT_Packet_MultiTileEntity getClientDataPacket() {
        GT_Packet_MultiTileEntity packet = super.getClientDataPacket();
        packet.setModes(this.getMode(), this.getAllowedModes());
        if (this.getTargetPos() != null) {
            ChunkCoordinates aTarget = this.getTargetPos();
            packet.setTargetPos(aTarget.field_71574_a, (short)aTarget.field_71572_b, aTarget.field_71573_c);
        }
        packet.setInventoryIndex(this.getLockedInventoryIndex());
        return packet;
    }

    @Override
    public void setLockedInventoryIndex(int aIndex) {
        this.mLockedInventoryIndex = aIndex;
    }

    @Override
    public int getLockedInventoryIndex() {
        return this.mLockedInventoryIndex;
    }

    @Override
    public void setTargetPos(ChunkCoordinates aTargetPos) {
        this.mTargetPos = aTargetPos;
        IMultiBlockController mTarget = this.getTarget(false);
        this.setTarget(mTarget, this.mAllowedModes);
    }

    @Override
    public ChunkCoordinates getTargetPos() {
        return this.mTargetPos;
    }

    @Override
    public void setMode(byte aMode) {
        this.mMode = aMode;
    }

    @Override
    public byte getMode() {
        return this.mMode;
    }

    @Override
    public int getAllowedModes() {
        return this.mAllowedModes;
    }

    @Override
    public void setAllowedModes(int aAllowedModes) {
        this.mAllowedModes = aAllowedModes;
    }

    public boolean hasMode(int aMode) {
        return (this.mAllowedModes & aMode) != 0;
    }

    public boolean modeSelected(int ... aModes) {
        for (int aMode : aModes) {
            if (!this.hasMode(aMode) || this.mMode != this.getModeOrdinal(aMode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean breakBlock() {
        IMultiBlockController tTarget = this.getTarget(false);
        if (tTarget != null) {
            this.unregisterCovers(tTarget);
            tTarget.onStructureChange();
        }
        return false;
    }

    @Override
    public void onBlockAdded() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.getTileEntityAtSide(side);
            if (te instanceof MultiBlockPart) {
                MultiBlockPart part = (MultiBlockPart)te;
                IMultiBlockController tController = part.getTarget(false);
                if (tController == null) continue;
                tController.onStructureChange();
                continue;
            }
            if (!(te instanceof IMultiBlockController)) continue;
            IMultiBlockController controller = (IMultiBlockController)te;
            controller.onStructureChange();
        }
    }

    @Override
    public ITexture getTexture(ForgeDirection side) {
        ITexture texture = super.getTexture(side);
        if (this.mMode != 0 && side == this.facing) {
            if (this.mMode == this.getModeOrdinal(ITEM_IN)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN), TextureFactory.of(Textures.BlockIcons.ITEM_IN_SIGN), this.getCoverTexture(side));
            }
            if (this.mMode == this.getModeOrdinal(ITEM_OUT)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT), TextureFactory.of(Textures.BlockIcons.ITEM_OUT_SIGN), this.getCoverTexture(side));
            }
            if (this.mMode == this.getModeOrdinal(FLUID_IN)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN), TextureFactory.of(Textures.BlockIcons.FLUID_IN_SIGN), this.getCoverTexture(side));
            }
            if (this.mMode == this.getModeOrdinal(FLUID_OUT)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT), TextureFactory.of(Textures.BlockIcons.FLUID_OUT_SIGN), this.getCoverTexture(side));
            }
            if (this.mMode == this.getModeOrdinal(ENERGY_IN)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ENERGY_IN_MULTI), this.getCoverTexture(side));
            }
            if (this.mMode == this.getModeOrdinal(ENERGY_OUT)) {
                return TextureFactory.of(texture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ENERGY_OUT_MULTI), this.getCoverTexture(side));
            }
        }
        return TextureFactory.of(texture, this.getCoverTexture(side));
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return false;
    }

    protected String getModeName(int aMode) {
        if (aMode == 0) {
            return "Nothing";
        }
        if (aMode == this.getModeOrdinal(ITEM_IN)) {
            return "Item Input";
        }
        if (aMode == this.getModeOrdinal(ITEM_OUT)) {
            return "Item Output";
        }
        if (aMode == this.getModeOrdinal(FLUID_IN)) {
            return "Fluid Input";
        }
        if (aMode == this.getModeOrdinal(FLUID_OUT)) {
            return "Fluid Output";
        }
        if (aMode == this.getModeOrdinal(ENERGY_IN)) {
            return "Energy Input";
        }
        if (aMode == this.getModeOrdinal(ENERGY_OUT)) {
            return "Energy Output";
        }
        return "Unknown";
    }

    protected byte getModeOrdinal(int aMode) {
        return (byte)(LongMath.log2((long)aMode, (RoundingMode)RoundingMode.UNNECESSARY) + 1);
    }

    protected byte getNextAllowedMode(List<Integer> allowedModes) {
        if (this.mAllowedModes == 0) {
            return 0;
        }
        int numModes = allowedModes.size();
        for (int i = 1; i <= numModes; i = (int)((byte)(i + 1))) {
            byte curMode = (byte)((this.mMode + i) % numModes);
            if (curMode != 0 && !this.hasMode(1 << curMode - 1)) continue;
            return curMode;
        }
        return 0;
    }

    @Override
    public boolean onMalletRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, ForgeDirection wrenchSide, float aX, float aY, float aZ) {
        if (this.mAllowedModes == 0) {
            return true;
        }
        if (this.mMode == 0) {
            this.facing = wrenchSide;
        }
        this.mMode = this.getNextAllowedMode(this.BASIC_MODES);
        if (aPlayer.func_70093_af()) {
            this.facing = wrenchSide;
        }
        GT_Utility.sendChatToPlayer(aPlayer, "Mode set to `" + this.getModeName(this.mMode) + "' (" + this.mMode + ")");
        this.sendClientData((EntityPlayerMP)aPlayer);
        return true;
    }

    @Override
    public void setLightValue(byte aLightValue) {
    }

    @Override
    public byte getComparatorValue(ForgeDirection side) {
        return 0;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.part";
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluidStack, boolean aDoFill) {
        if (!this.modeSelected(FLUID_IN)) {
            return 0;
        }
        if (aFluidStack == null || this.isWrongFluid(aFluidStack.getFluid())) {
            return 0;
        }
        if (!(aDirection == ForgeDirection.UNKNOWN || this.facing.compareTo((Enum)aDirection) == 0 && this.coverLetsFluidIn(aDirection, aFluidStack.getFluid()))) {
            return 0;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller == null ? 0 : controller.fill(this, aDirection, aFluidStack, aDoFill);
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluidStack, boolean aDoDrain) {
        if (!this.modeSelected(FLUID_OUT)) {
            return null;
        }
        if (aFluidStack == null || this.isWrongFluid(aFluidStack.getFluid())) {
            return null;
        }
        if (!(aDirection == ForgeDirection.UNKNOWN || this.facing.compareTo((Enum)aDirection) == 0 && this.coverLetsFluidOut(aDirection, aFluidStack.getFluid()))) {
            return null;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller == null ? null : controller.drain(this, aDirection, aFluidStack, aDoDrain);
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, int aAmountToDrain, boolean aDoDrain) {
        if (!this.modeSelected(FLUID_OUT)) {
            return null;
        }
        IMultiBlockController controller = this.getTarget(true);
        if (controller == null) {
            return null;
        }
        FluidStack aFluidStack = null;
        aFluidStack = this.getLockedFluid() != null ? controller.getDrainableFluid(aDirection, this.getLockedFluid()) : controller.getDrainableFluid(aDirection);
        if (aFluidStack == null || this.isWrongFluid(aFluidStack.getFluid())) {
            return null;
        }
        if (!(aDirection == ForgeDirection.UNKNOWN || this.facing.compareTo((Enum)aDirection) == 0 && this.coverLetsFluidOut(aDirection, aFluidStack.getFluid()))) {
            return null;
        }
        return controller.drain(this, aDirection, aFluidStack, aDoDrain);
    }

    @Override
    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        if (!this.modeSelected(FLUID_IN)) {
            return false;
        }
        if (!(aDirection == ForgeDirection.UNKNOWN || this.facing.compareTo((Enum)aDirection) == 0 && this.coverLetsFluidIn(aDirection, aFluid))) {
            return false;
        }
        if (this.isWrongFluid(aFluid)) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.canFill(this, aDirection, aFluid);
    }

    @Override
    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        if (!this.modeSelected(FLUID_OUT)) {
            return false;
        }
        if (!(aDirection == ForgeDirection.UNKNOWN || this.facing.compareTo((Enum)aDirection) == 0 && this.coverLetsFluidOut(aDirection, aFluid))) {
            return false;
        }
        if (this.isWrongFluid(aFluid)) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.canDrain(this, aDirection, aFluid);
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aDirection) {
        if (!this.modeSelected(FLUID_IN, FLUID_OUT) || aDirection != ForgeDirection.UNKNOWN && this.facing.compareTo((Enum)aDirection) != 0) {
            return GT_Values.emptyFluidTankInfo;
        }
        IMultiBlockController controller = this.getTarget(true);
        if (controller == null) {
            return GT_Values.emptyFluidTankInfo;
        }
        CoverInfo coverInfo = this.getCoverInfoAtSide(aDirection);
        if (controller.isLiquidInput(aDirection) && coverInfo.letsFluidIn(null, controller) || controller.isLiquidOutput(aDirection) && coverInfo.letsFluidOut(null, controller)) {
            return controller.getTankInfo(this, aDirection);
        }
        return GT_Values.emptyFluidTankInfo;
    }

    @Override
    public PowerLogic getPowerLogic(ForgeDirection side) {
        if (this.facing == side) {
            return null;
        }
        if (!this.modeSelected(ENERGY_IN, ENERGY_OUT)) {
            return null;
        }
        IMultiBlockController controller = this.getTarget(true);
        if (controller == null) {
            return null;
        }
        return controller.getPowerLogic(this, side);
    }

    @Override
    public boolean isEnetInput() {
        return this.modeSelected(ENERGY_IN);
    }

    @Override
    public boolean isEnetOutput() {
        return this.modeSelected(ENERGY_OUT);
    }

    @Override
    public boolean hasInventoryBeenModified() {
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.hasInventoryBeenModified(this);
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.isValidSlot(this, aIndex);
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        if (!this.modeSelected(ITEM_IN, ITEM_OUT)) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.addStackToSlot(this, aIndex, aStack);
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack, int aAmount) {
        if (!this.modeSelected(ITEM_IN, ITEM_OUT)) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.addStackToSlot(this, aIndex, aStack, aAmount);
    }

    @Override
    public int[] func_94128_d(int ordinalSide) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        if (!this.modeSelected(ITEM_IN, ITEM_OUT) || this.facing != ForgeDirection.UNKNOWN && this.facing.compareTo((Enum)side) != 0) {
            return GT_Values.emptyIntArray;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getAccessibleSlotsFromSide(this, side) : GT_Values.emptyIntArray;
    }

    @Override
    public boolean func_102007_a(int aSlot, ItemStack aStack, int ordinalSide) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        if (!this.modeSelected(ITEM_IN, ITEM_OUT) || this.facing != ForgeDirection.UNKNOWN && (this.facing.compareTo((Enum)side) != 0 || !this.coverLetsItemsIn(side, aSlot))) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.canInsertItem(this, aSlot, aStack, side);
    }

    @Override
    public boolean func_102008_b(int aSlot, ItemStack aStack, int ordinalSide) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        if (!this.modeSelected(ITEM_IN, ITEM_OUT) || this.facing != ForgeDirection.UNKNOWN && (this.facing.compareTo((Enum)side) != 0 || !this.coverLetsItemsOut(side, aSlot))) {
            return false;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.canExtractItem(this, aSlot, aStack, side);
    }

    @Override
    public int func_70302_i_() {
        if (!this.modeSelected(ITEM_IN, ITEM_OUT)) {
            return 0;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getSizeInventory(this) : 0;
    }

    @Override
    public ItemStack func_70301_a(int aSlot) {
        if (!this.modeSelected(ITEM_IN, ITEM_OUT)) {
            return null;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getStackInSlot(this, aSlot) : null;
    }

    @Override
    public ItemStack func_70298_a(int aSlot, int aDecrement) {
        if (!this.modeSelected(ITEM_IN, ITEM_OUT)) {
            return null;
        }
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.decrStackSize(this, aSlot, aDecrement) : null;
    }

    @Override
    public ItemStack func_70304_b(int aSlot) {
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getStackInSlotOnClosing(this, aSlot) : null;
    }

    @Override
    public void func_70299_a(int aSlot, ItemStack aStack) {
        IMultiBlockController controller = this.getTarget(true);
        if (controller != null) {
            controller.setInventorySlotContents(this, aSlot, aStack);
        }
    }

    public String func_145825_b() {
        IMultiBlockController controller = this.getTarget(true);
        if (controller != null) {
            return controller.getInventoryName(this);
        }
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getCustomName(), this.getTileEntityName()});
    }

    @Override
    public int func_70297_j_() {
        IMultiBlockController controller = this.getTarget(true);
        return controller != null ? controller.getInventoryStackLimit(this) : 0;
    }

    @Override
    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        IMultiBlockController controller = this.getTarget(true);
        return controller != null && controller.isItemValidForSlot(this, aSlot, aStack);
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public String getLocalName() {
        if (this.modeSelected(ITEM_IN)) {
            return "Input Inventory";
        }
        if (this.modeSelected(ITEM_OUT)) {
            return "Output Inventory";
        }
        if (this.modeSelected(FLUID_IN)) {
            return "Fluid Input Hatch";
        }
        if (this.modeSelected(FLUID_OUT)) {
            return "Fluid Output Hatch";
        }
        return "Unknown";
    }

    @Override
    public boolean hasGui(ForgeDirection side) {
        if (this.modeSelected(ENERGY_IN, ENERGY_OUT) && this.facing == side) {
            return false;
        }
        return this.getTarget(true) != null;
    }

    protected void addItemInventory(ModularWindow.Builder builder, UIBuildContext buildContext) {
        IMultiBlockController controller = this.getTarget(false);
        if (controller == null) {
            return;
        }
        IItemHandlerModifiable inv = controller.getInventoryForGUI(this);
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int rows = 0;
        while (rows * 4 < Math.min(inv.getSlots(), 128)) {
            int columnsToMake = Math.min(Math.min(inv.getSlots(), 128) - rows * 4, 4);
            for (int column = 0; column < columnsToMake; ++column) {
                scrollable.widget(new SlotWidget(inv, rows * 4 + column).setPos(column * 18, rows * 18).setSize(18, 18));
            }
            ++rows;
        }
        builder.widget(scrollable.setSize(76, 72).setPos(52, 18));
        DropDownWidget dropDown = new DropDownWidget();
        dropDown.addDropDownItemsSimple(controller.getInventoryNames(this), (buttonWidget, index, label, setSelected) -> buttonWidget.setOnClick((clickData, widget) -> {
            if (this.getNameOfInventoryFromIndex(controller, index).equals("all")) {
                this.mLockedInventory = "";
                this.mLockedInventoryIndex = 0;
            } else {
                this.mLockedInventory = this.getNameOfInventoryFromIndex(controller, index);
                this.mLockedInventoryIndex = index;
            }
            setSelected.run();
        }), true);
        builder.widget(dropDown.setSelected(this.mLockedInventoryIndex).setExpandedMaxHeight(60).setDirection(DropDownWidget.Direction.DOWN).setPos(53, 5).setSize(70, 11));
    }

    protected String getNameOfInventoryFromIndex(IMultiBlockController controller, int index) {
        List invNames = controller.getInventoryIDs(this);
        if (index > invNames.size()) {
            return (String)invNames.get(0);
        }
        return (String)invNames.get(index);
    }

    protected String getNameOfTankArrayFromIndex(IMultiBlockController controller, int index) {
        List tankNames = controller.getTankArrayIDs(this);
        if (index > tankNames.size()) {
            return (String)tankNames.get(0);
        }
        return (String)tankNames.get(index);
    }

    protected boolean isWrongFluid(Fluid fluid) {
        if (fluid == null) {
            return true;
        }
        Fluid lockedFluid = this.getLockedFluid();
        if (lockedFluid != null) {
            return !fluid.equals(lockedFluid);
        }
        return false;
    }

    protected Fluid getLockedFluid() {
        if (this.configurationTank.get() != null && this.configurationTank.get().getFluid() != null) {
            return this.configurationTank.get().getFluid();
        }
        return null;
    }

    protected void addFluidInventory(ModularWindow.Builder builder, UIBuildContext buildContext) {
        IMultiBlockController controller = this.getTarget(false);
        if (controller == null) {
            return;
        }
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(7, 4).setSize(85, 95));
        if (this.modeSelected(FLUID_OUT)) {
            ((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GT_UITextures.PICTURE_SCREEN_BLACK).setPos(this.getGUIWidth() - 77, 4).setSize(70, 40))).widget(new TextWidget("Locked Fluid").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(this.getGUIWidth() - 72, 8));
        }
        IFluidTank[] tanks = controller.getFluidTanksForGUI(this);
        Scrollable scrollable = new Scrollable().setVerticalScroll();
        int rows = 0;
        while (rows * 4 < tanks.length) {
            int columnsToMake = Math.min(tanks.length - rows * 4, 4);
            for (int column = 0; column < columnsToMake; ++column) {
                FluidSlotWidget fluidSlot = new FluidSlotWidget(tanks[rows * 4 + column]);
                if (this.modeSelected(FLUID_OUT)) {
                    fluidSlot.setInteraction(true, false);
                }
                scrollable.widget(fluidSlot.setPos(column * 18, rows * 18).setSize(18, 18));
            }
            ++rows;
        }
        builder.widget(scrollable.setSize(76, 72).setPos(12, 21));
        DropDownWidget dropDown = new DropDownWidget();
        dropDown.addDropDownItemsSimple(controller.getTankArrayNames(this), (buttonWidget, index, label, setSelected) -> buttonWidget.setOnClick((clickData, widget) -> {
            if (this.getNameOfTankArrayFromIndex(controller, index).equals("all")) {
                this.mLockedInventory = "";
                this.mLockedInventoryIndex = 0;
            } else {
                this.mLockedInventory = this.getNameOfTankArrayFromIndex(controller, index);
                this.mLockedInventoryIndex = index;
            }
            setSelected.run();
        }), true);
        builder.widget(dropDown.setSelected(this.mLockedInventoryIndex).setExpandedMaxHeight(60).setDirection(DropDownWidget.Direction.DOWN).setPos(13, 8).setSize(70, 11));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        if (this.modeSelected(ITEM_IN, ITEM_OUT)) {
            this.addItemInventory(builder, buildContext);
            return;
        }
        if (this.modeSelected(FLUID_IN, FLUID_OUT)) {
            this.addFluidInventory(builder, buildContext);
            if (this.modeSelected(FLUID_OUT)) {
                builder.widget(SlotGroup.ofFluidTanks(Collections.singletonList(this.configurationTank), (int)1).startFromSlot(0).endAtSlot(0).phantom(true).build().setPos(this.getGUIWidth() - 72, 20));
            }
            return;
        }
    }

    @Override
    public ModularWindow createWindow(UIBuildContext buildContext) {
        if (this.isServerSide()) {
            this.issueClientUpdate();
        }
        System.out.println("MultiBlockPart::createWindow");
        if (this.modeSelected(0, ENERGY_IN, ENERGY_OUT) || this.mMode == 0) {
            IMultiBlockController controller = this.getTarget(false);
            if (controller == null) {
                return super.createWindow(buildContext);
            }
            return controller.createWindowGUI(buildContext);
        }
        return super.createWindow(buildContext);
    }

    @Override
    protected int getGUIHeight() {
        return super.getGUIHeight() + 20;
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        if (this.modeSelected(ITEM_IN, ITEM_OUT)) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(152, 74));
        } else if (this.modeSelected(FLUID_IN, FLUID_OUT)) {
            builder.widget(new DrawableWidget().setDrawable((IDrawable)this.getGUITextureSet().getGregTechLogo()).setSize(17, 17).setPos(152, 82));
        } else {
            super.addGregTechLogo(builder);
        }
    }
}

