/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.trapdoor.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.AABBUtils;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class SlidingTrapDoorMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        int dir = tileEntity.getDirection();
        float w = 0.09375f;
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)w, (double)1.0);
        if (topBlock) {
            aabb.func_72317_d(0.0, 0.8125, 0.0);
        }
        if (tileEntity.isOpened()) {
            aabb.func_72317_d(0.0, 0.0, -0.8125);
        }
        switch (dir) {
            case 2: {
                dir = 1;
                break;
            }
            case 3: {
                dir = 3;
                break;
            }
            case 0: {
                dir = 2;
                break;
            }
            default: {
                dir = 0;
            }
        }
        AABBUtils.rotate((AxisAlignedBB)aabb, (int)dir);
        return aabb;
    }

    private Transformation getTransformation(DoorTileEntity tileEntity) {
        Translation translation = new Translation(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.8125f);
        translation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        translation.forTicks(tileEntity.getDescriptor().getOpeningTime());
        return translation;
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model, this.getTransformation(tileEntity))};
    }

    @Override
    public boolean isSpecial() {
        return true;
    }
}

