/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.renderer;

import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.BlockState;
import net.malisis.doors.door.block.BigDoor;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.tileentity.BigDoorTileEntity;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class BigDoorRenderer
extends MalisisRenderer {
    private ResourceLocation rl;
    private MalisisModel model;
    private Shape frame;
    private Shape doorLeft;
    private Shape doorRight;
    private AnimationRenderer ar = new AnimationRenderer();
    private BigDoorTileEntity tileEntity;
    private ForgeDirection direction;

    public BigDoorRenderer() {
        this.getBlockDamage = true;
    }

    protected void initialize() {
        this.rl = new ResourceLocation("malisisdoors", "models/big_door.obj");
        this.model = new MalisisModel(this.rl);
        this.frame = this.model.getShape("Frame");
        this.doorLeft = this.model.getShape("Left");
        this.doorRight = this.model.getShape("Right");
        this.rp = new RenderParameters();
        this.rp.useBlockBounds.set((Object)false);
    }

    public void render() {
        if (((MalisisRenderer)this).tileEntity == null) {
            return;
        }
        this.tileEntity = (BigDoorTileEntity)((MalisisRenderer)this).tileEntity;
        this.direction = Door.intToDir(this.tileEntity.getDirection());
        this.setup();
        if (this.renderType == RenderType.ISBRH_WORLD) {
            this.getBlockDamage = true;
            this.renderBlock();
        } else if (this.renderType == RenderType.TESR_WORLD) {
            this.renderTileEntity();
        }
    }

    private void renderBlock() {
        BlockState state = this.tileEntity.getFrameState();
        if (!state.getBlock().canRenderInPass(BigDoor.renderPass)) {
            return;
        }
        this.set(state.getBlock(), state.getMetadata());
        this.rp.icon.reset();
        this.rp.useWorldSensitiveIcon.set((Object)false);
        this.drawShape(this.frame, this.rp);
    }

    private void renderTileEntity() {
        this.ar.setStartTime(this.tileEntity.getTimer().getStart());
        if (this.tileEntity.getMovement() != null) {
            Animation[] anims = this.tileEntity.getMovement().getAnimations(this.tileEntity, this.model, this.rp);
            this.ar.animate(anims);
        }
        this.next(9);
        this.rp.icon.reset();
        this.drawShape(this.doorLeft, this.rp);
        this.drawShape(this.doorRight, this.rp);
    }

    private void setup() {
        this.model.resetState();
        if (this.direction == ForgeDirection.SOUTH) {
            this.model.rotate(180.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (this.direction == ForgeDirection.EAST) {
            this.model.rotate(-90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else if (this.direction == ForgeDirection.WEST) {
            this.model.rotate(90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.rp.brightness.set((Object)this.block.func_149677_c(this.world, this.x, this.y, this.z));
    }

    protected boolean isCurrentBlockDestroyProgress(DestroyBlockProgress dbp) {
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }
}

