/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon;

import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonDir;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonElementType;

public final class DungeonElement {
    public final byte x;
    public final byte y;
    public final byte size;
    public final DungeonElementType type;
    private final boolean[] connections;

    public DungeonElement(int x, int y, DungeonElementType type) {
        this.x = (byte)x;
        this.y = (byte)y;
        this.size = (byte)(type == DungeonElementType.ROOM || type == DungeonElementType.DESCEND || type == DungeonElementType.END ? 3 : 1);
        this.type = type;
        this.connections = new boolean[4];
    }

    public DungeonElement connect(DungeonDir dir) {
        this.connections[dir.ordinal()] = true;
        return this;
    }

    public boolean checkConnection(DungeonDir dir) {
        return this.connections[dir.ordinal()];
    }

    public boolean hasConnection() {
        for (int a = 0; a < 4; ++a) {
            if (!this.connections[a]) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof DungeonElement) {
            DungeonElement other = (DungeonElement)o;
            return this.x == other.x && this.y == other.y && this.type == other.type;
        }
        return false;
    }

    public int hashCode() {
        return this.x * 117 + this.y;
    }
}

