/*
 * Decompiled with CFR 0.152.
 */
package net.glease.ggfab;

import java.io.File;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public enum ConfigurationHandler {
    INSTANCE;

    private Configuration config;
    private float laserOCPenaltyFactor;

    void init(File f) {
        this.config = new Configuration(f);
        this.loadConfig();
        this.setLanguageKeys();
    }

    private void setLanguageKeys() {
        for (String categoryName : this.config.getCategoryNames()) {
            ConfigCategory category = this.config.getCategory(categoryName);
            category.setLanguageKey("ggfab.config." + categoryName);
            for (Map.Entry entry : category.entrySet()) {
                ((Property)entry.getValue()).setLanguageKey(String.format("%s.%s", category.getLanguagekey(), entry.getKey()));
            }
        }
    }

    private void loadConfig() {
        this.laserOCPenaltyFactor = this.config.getFloat("advasslinePenaltyFactor", "common.balancing", 0.3f, 0.0f, 10.0f, "Laser overclock penalty factor. This will incredibly change the game balance. Even a small step from 0.2 to 0.3 can have very significant impact. Tweak with caution!");
        this.config.save();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public float getLaserOCPenaltyFactor() {
        return this.laserOCPenaltyFactor;
    }
}

