/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.witch;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.SpecialMobData;
import toast.specialMobs.entity.witch.Entity_SpecialWitch;

public class EntityShadowsWitch
extends Entity_SpecialWitch {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "witch/shadows.png")};
    public byte spiderCount;

    public EntityShadowsWitch(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.getSpecialData().immuneToPotions.add(Potion.field_76440_q.field_76415_H);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70638_az() != null && this.field_70146_Z.nextInt(10) == 0 && this.func_70638_az().func_70644_a(Potion.field_76440_q)) {
            this.func_70638_az().func_82170_o(Potion.field_76439_r.field_76415_H);
        }
        super.func_70636_d();
    }

    @Override
    protected EntityPotion adjustSplashPotion(EntityPotion thrownPotion, EntityLivingBase target, float range, float distance) {
        if (this.adjustSplashPotionByType(thrownPotion, target, range, distance)) {
            return thrownPotion;
        }
        if (target.func_110143_aJ() >= 4.0f && !target.func_70644_a(Potion.field_76440_q)) {
            return new EntityPotion(this.field_70170_p, (EntityLivingBase)this, this.makeShadowPotion());
        }
        if (target.func_110143_aJ() >= 8.0f && !target.func_70644_a(Potion.field_76436_u)) {
            thrownPotion.func_82340_a(16388);
            return thrownPotion;
        }
        if (distance <= 3.0f && !target.func_70644_a(Potion.field_76437_t) && this.field_70146_Z.nextFloat() < 0.25f) {
            thrownPotion.func_82340_a(16392);
            return thrownPotion;
        }
        return thrownPotion;
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151100_aR, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        this.func_70099_a(this.makeShadowPotion(), 0.0f);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74774_a("Spiders", this.spiderCount);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_74764_b("Spiders")) {
            this.spiderCount = saveTag.func_74771_c("Spiders");
        } else if (tag.func_74764_b("Spiders")) {
            this.spiderCount = tag.func_74771_c("Spiders");
        }
    }

    private ItemStack makeShadowPotion() {
        ItemStack potion = new ItemStack((Item)Items.field_151068_bn, 1, 16396);
        EffectHelper.setItemName(potion, "Splash Potion of Blindness", 15);
        EffectHelper.addPotionEffect(potion, Potion.field_76440_q, 200, 0);
        return potion;
    }
}

