/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.mixins.fml;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameData;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import net.minecraft.init.Blocks;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(targets={"cpw.mods.fml.common.registry.ObjectHolderRef"}, remap=false)
public class ObjectHolderRef {
    @Shadow(remap=false)
    private Field field;
    @Shadow(remap=false)
    private String injectedObject;
    @Shadow(remap=false)
    private boolean isBlock;
    @Shadow(remap=false)
    private boolean isItem;
    private MethodHandle fieldSetter = null;

    @Overwrite(remap=false)
    private static void makeWritable(Field f) {
        try {
            f.setAccessible(true);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Overwrite(remap=false)
    public void apply() {
        Object thing;
        if (this.fieldSetter == null) {
            try {
                this.fieldSetter = MethodHandles.lookup().unreflectSetter(this.field);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.isBlock) {
            thing = GameData.getBlockRegistry().func_82594_a(this.injectedObject);
            if (thing == Blocks.field_150350_a) {
                thing = null;
            }
        } else {
            thing = this.isItem ? GameData.getItemRegistry().func_82594_a(this.injectedObject) : null;
        }
        if (thing == null) {
            FMLLog.getLogger().log(Level.DEBUG, "Unable to lookup {} for {}. This means the object wasn't registered. It's likely just mod options.", new Object[]{this.injectedObject, this.field});
            return;
        }
        try {
            this.fieldSetter.invoke(thing);
            FMLLog.finer((String)("Set field " + this.field.toString() + " to " + thing), (Object[])new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.log((Level)Level.WARN, (Throwable)e, (String)"Unable to set %s with value %s (%s)", (Object[])new Object[]{this.field, thing, this.injectedObject});
        }
    }
}

