/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.blocks.tileEntity.base.GT_MetaTileEntity_TooltipMultiBlockBase_EM;
import goodgenerator.crossmod.LoadedList;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class UniversalChemicalFuelEngine
extends GT_MetaTileEntity_TooltipMultiBlockBase_EM
implements IConstructable,
ISurvivalConstructable {
    protected final double DIESEL_EFFICIENCY_COEFFICIENT = 0.04;
    protected final double GAS_EFFICIENCY_COEFFICIENT = 0.04;
    protected final double ROCKET_EFFICIENCY_COEFFICIENT = 0.005;
    protected final double EFFICIENCY_CEILING = 1.5;
    private long lEUt;
    private long tEff;
    private IStructureDefinition<UniversalChemicalFuelEngine> multiDefinition = null;

    public UniversalChemicalFuelEngine(String name) {
        super(name);
    }

    public UniversalChemicalFuelEngine(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public final boolean addMaintenance(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        return false;
    }

    public final boolean addMuffler(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMufflerHatches.add((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity);
        }
        return false;
    }

    public final boolean addInputHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        return false;
    }

    public final boolean addDynamoHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_DynamoMulti) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eDynamoMulti.add((GT_MetaTileEntity_Hatch_DynamoMulti)aMetaTileEntity);
        }
        return false;
    }

    public IStructureDefinition<UniversalChemicalFuelEngine> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"TTTTT", "TTMMT", "TTMMT", "TTMMT", "TTMMT", "TTMMT", "TTMMT", "TTMMT", "TTTTT"}, {"TTTTT", "SPCCI-", "SPCCI-", "SPCCI-", "SPCCI-", "SPCCI-", "SPCCI-", "SPCCI-", "TTTTT"}, {"TT~TT", "SPGGI-", "SPGGI-", "SPGGI-", "SPGGI-", "SPGGI-", "SPGGI-", "SPGGI-", "TTETT"}, {"TTWTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT"}})).addElement('T', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)2)).addElement('W', GT_StructureUtility.buildHatchAdder(UniversalChemicalFuelEngine.class).atLeast(new IHatchElement[]{GT_HatchElement.Maintenance}).casingIndex(50).dot(1).build()).addElement('M', GT_StructureUtility.buildHatchAdder(UniversalChemicalFuelEngine.class).atLeast(new IHatchElement[]{GT_HatchElement.Muffler}).casingIndex(50).dot(2).build()).addElement('S', GT_StructureUtility.buildHatchAdder(UniversalChemicalFuelEngine.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch}).casingIndex(50).dot(3).build()).addElement('E', GT_StructureUtility.buildHatchAdder(UniversalChemicalFuelEngine.class).atLeast(new IHatchElement[]{GT_HatchElement.Dynamo}).casingIndex(50).dot(4).build()).addElement('P', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)14)).addElement('C', StructureUtility.ofBlock((Block)Loaders.titaniumPlatedCylinder, (int)0)).addElement('G', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)4)).addElement('I', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)13)).build();
        }
        return this.multiDefinition;
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.structureCheck_EM(this.mName, 2, 2, 0);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(this.mName, 2, 2, 0, stackSize, hintsOnly);
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return DescTextLocalization.addText("UniversalChemicalFuelEngine.hint", 11);
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return (int)Math.sqrt(this.mEUt) / 20;
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Chemical Engine").addInfo("Controller block for the Chemical Engine").addInfo("BURNING BURNING BURNING").addInfo("Use combustible liquid to generate power.").addInfo("You need to supply Combustion Promoter to keep it running.").addInfo("This engine will consume all the fuel and combustion promoter in the hatch every second.").addInfo("The efficiency is determined by the proportion of Combustion Promoter to fuel.").addInfo("The proportion is bigger, and the efficiency will be higher.").addInfo("It creates sqrt(Current Output Power) pollution every second").addInfo("If you forget to supply Combustion Promoter, this engine will swallow all the fuel " + EnumChatFormatting.YELLOW + "without outputting energy" + EnumChatFormatting.GRAY + ".").addInfo("The efficiency is up to 150%.").addInfo("The structure is too complex!").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().beginStructureBlock(5, 4, 9, false).addMaintenanceHatch("Hint block with dot 1").addMufflerHatch("Hint block with dot 2").addInputHatch("Hint block with dot 3").addDynamoHatch("Hint block with dot 4").toolTipFinisher("Good Generator");
        return tt;
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        int FuelAmount;
        FluidStack tFuel;
        ArrayList tFluids = this.getStoredFluids();
        Collection tDieselFuels = GT_Recipe.GT_Recipe_Map.sDieselFuels.mRecipeList;
        Collection tGasFuels = GT_Recipe.GT_Recipe_Map.sTurbineFuels.mRecipeList;
        int PromoterAmount = this.findLiquidAmount(this.getPromoter(), tFluids);
        for (GT_Recipe recipe : tDieselFuels) {
            tFuel = this.findFuel(recipe);
            if (tFuel == null || (FuelAmount = this.findLiquidAmount(tFuel, tFluids)) == 0) continue;
            this.calculateEfficiency(FuelAmount, PromoterAmount, 0.04);
            this.consumeAllLiquid(tFuel);
            this.consumeAllLiquid(this.getPromoter());
            this.mEUt = (int)((double)(FuelAmount * recipe.mSpecialValue) / 20.0);
            this.lEUt = (long)((double)((long)FuelAmount * (long)recipe.mSpecialValue) / 20.0);
            this.mMaxProgresstime = 20;
            this.updateSlots();
            return true;
        }
        for (GT_Recipe recipe : tGasFuels) {
            tFuel = this.findFuel(recipe);
            if (tFuel == null || (FuelAmount = this.findLiquidAmount(tFuel, tFluids)) == 0) continue;
            this.calculateEfficiency(FuelAmount, PromoterAmount, 0.04);
            this.consumeAllLiquid(tFuel);
            this.consumeAllLiquid(this.getPromoter());
            this.mEUt = (int)((double)(FuelAmount * recipe.mSpecialValue) / 20.0);
            this.lEUt = (long)((double)((long)FuelAmount * (long)recipe.mSpecialValue) / 20.0);
            this.mMaxProgresstime = 20;
            this.updateSlots();
            return true;
        }
        if (LoadedList.GTPP) {
            Collection tRocketFuels = GTPP_Recipe.GTPP_Recipe_Map.sRocketFuels.mRecipeList;
            for (GT_Recipe recipe : tRocketFuels) {
                int FuelAmount2;
                FluidStack tFuel2 = this.findFuel(recipe);
                if (tFuel2 == null || (FuelAmount2 = this.findLiquidAmount(tFuel2, tFluids)) == 0) continue;
                this.calculateEfficiency(FuelAmount2, PromoterAmount, 0.005);
                this.consumeAllLiquid(tFuel2);
                this.consumeAllLiquid(this.getPromoter());
                this.mEUt = (int)((double)(FuelAmount2 * recipe.mSpecialValue * 3) / 20.0);
                this.lEUt = (long)((double)((long)FuelAmount2 * (long)recipe.mSpecialValue * 3L) / 20.0);
                this.mMaxProgresstime = 20;
                this.updateSlots();
                return true;
            }
        }
        return false;
    }

    public boolean onRunningTick(ItemStack stack) {
        super.onRunningTick(stack);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.addAutoEnergy();
        }
        return true;
    }

    public String[] getInfoData() {
        String[] info = super.getInfoData();
        info[4] = "Probably makes: " + EnumChatFormatting.RED + this.lEUt + EnumChatFormatting.RESET + " EU/t";
        info[6] = "Problems: " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " Efficiency: " + EnumChatFormatting.YELLOW + (double)this.tEff / 100.0 + EnumChatFormatting.RESET + " %";
        return info;
    }

    void addAutoEnergy() {
        GT_MetaTileEntity_Hatch_Dynamo tHatch;
        long exEU = this.lEUt * this.tEff / 10000L;
        if (!this.mDynamoHatches.isEmpty()) {
            tHatch = (GT_MetaTileEntity_Hatch_Dynamo)this.mDynamoHatches.get(0);
            if (tHatch.maxEUOutput() * tHatch.maxAmperesOut() >= exEU) {
                tHatch.setEUVar(Math.min(tHatch.maxEUStore(), tHatch.getBaseMetaTileEntity().getStoredEU() + exEU));
            } else {
                tHatch.doExplosion(tHatch.maxEUOutput());
            }
        }
        if (!this.eDynamoMulti.isEmpty()) {
            tHatch = (GT_MetaTileEntity_Hatch_DynamoMulti)this.eDynamoMulti.get(0);
            if (tHatch.maxEUOutput() * tHatch.maxAmperesOut() >= exEU) {
                tHatch.setEUVar(Math.min(tHatch.maxEUStore(), tHatch.getBaseMetaTileEntity().getStoredEU() + exEU));
            } else {
                tHatch.doExplosion(tHatch.maxEUOutput());
            }
        }
    }

    public FluidStack getPromoter() {
        return FluidRegistry.getFluidStack((String)"combustionpromotor", (int)1);
    }

    public FluidStack findFuel(GT_Recipe aFuel) {
        if (aFuel.mInputs != null && aFuel.mInputs.length > 0) {
            return GT_Utility.getFluidForFilledItem((ItemStack)aFuel.mInputs[0], (boolean)true);
        }
        return aFuel.mFluidInputs[0];
    }

    public void calculateEfficiency(int aFuel, int aPromoter, double coefficient) {
        if (aPromoter == 0) {
            this.tEff = 0L;
            return;
        }
        this.tEff = (int)(Math.exp(-coefficient * (double)aFuel / (double)aPromoter) * 1.5 * 10000.0);
    }

    public int findLiquidAmount(FluidStack liquid, List<FluidStack> input) {
        int cnt = 0;
        for (FluidStack fluid : input) {
            if (!fluid.isFluidEqual(liquid)) continue;
            cnt += fluid.amount;
        }
        if (cnt < 0) {
            cnt = 0;
        }
        return cnt;
    }

    public void consumeAllLiquid(FluidStack liquid) {
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            FluidStack tLiquid;
            if (!UniversalChemicalFuelEngine.isValidMetaTileEntity((MetaTileEntity)tHatch) || (tLiquid = tHatch.getFluid()) == null || !tLiquid.isFluidEqual(liquid)) continue;
            tHatch.drain(tLiquid.amount, true);
        }
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50], TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE_GLOW}).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50], TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_GLOW}).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50]};
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new UniversalChemicalFuelEngine(this.mName);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 2, 0, elementBudget, source, actor, false, true);
    }
}

