/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.mothership;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.astronomy.AngleDistance;
import de.katzenpapst.amunra.block.IMetaBlock;
import de.katzenpapst.amunra.block.SubBlock;
import de.katzenpapst.amunra.block.machine.mothershipEngine.MothershipEngineJetBase;
import de.katzenpapst.amunra.helper.AstronomyHelper;
import de.katzenpapst.amunra.helper.BlockMassHelper;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.mothership.Mothership;
import de.katzenpapst.amunra.mothership.MothershipChunkProvider;
import de.katzenpapst.amunra.mothership.MothershipWorldChunkManager;
import de.katzenpapst.amunra.mothership.MothershipWorldProviderSaveFile;
import de.katzenpapst.amunra.mothership.fueldisplay.MothershipFuelRequirements;
import de.katzenpapst.amunra.network.packet.PacketSimpleAR;
import de.katzenpapst.amunra.tick.TickHandlerServer;
import de.katzenpapst.amunra.tile.ITileMothershipEngine;
import de.katzenpapst.amunra.vec.Vector2int;
import de.katzenpapst.amunra.vec.Vector3int;
import java.util.HashSet;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.client.IRenderHandler;

public class MothershipWorldProvider
extends WorldProviderSpace
implements IZeroGDimension,
ISolarLevel,
IExitHeight {
    protected long dayLength = 24000L;
    protected float thermalLevel = 0.0f;
    protected double solarLevel = 1.0;
    protected boolean mustSendPacketToClients = false;
    protected boolean haveReadFromNBT = false;
    protected boolean hasLoadedWorldData = false;
    protected int ticksSinceLastUpdate = 0;
    public static final int MIN_TICKS_BETWEEN_UPDATES = 200;
    protected MothershipWorldProviderSaveFile mothershipSaveFile;
    protected HashSet<Vector2int> checkedChunks = new HashSet();
    protected HashSet<Vector3int> engineLocations = new HashSet();
    protected boolean needParentParamUpdate = false;
    protected float totalMass;
    protected long totalNumBlocks;
    protected TransitData potentialTransitData;
    protected boolean isAsyncUpdateRunning = false;
    protected boolean isInTransit = false;
    protected Mothership mothershipObj;

    public float getTotalMass() {
        return this.totalMass;
    }

    public long getNumBlocks() {
        return this.totalNumBlocks;
    }

    public TransitData getTheoreticalTransitData() {
        return this.potentialTransitData;
    }

    public void setDimension(int dim) {
        if (TickHandlerServer.mothershipData == null) {
            throw new RuntimeException("Premature Mothership dimension creation! This *MIGHT* be due to a configuration error. Please try changing I:mothershipProviderID in GalacticraftAmunRa.cfg and try again. If error persists, please report a bug including a complete list of your mods");
        }
        this.mothershipObj = TickHandlerServer.mothershipData.getByDimensionId(dim);
        if (this.mothershipObj == null) {
            throw new RuntimeException("Mothership with dim ID " + dim + " has no celestial body. This is bad!");
        }
        super.setDimension(dim);
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        if (this.mothershipObj.isInTransit()) {
            return 0.0f;
        }
        if (AstronomyHelper.isStar(this.mothershipObj.getParent())) {
            return 1.0f;
        }
        if (AstronomyHelper.getSolarSystem(this.mothershipObj.getParent()).equals(AmunRa.instance.systemAmunRa)) {
            float factor = this.field_76579_a.getSunBrightnessFactor(par1) + this.getAmunBrightnessFactor(par1);
            if (factor > 1.0f) {
                factor = 1.0f;
            }
            return factor;
        }
        return this.field_76579_a.getSunBrightnessBody(par1);
    }

    protected float getAmunBrightnessFactor(float partialTicks) {
        CelestialBody curBody = this.getCelestialBody();
        if (curBody instanceof Moon) {
            curBody = ((Moon)curBody).getParentPlanet();
        }
        AngleDistance ad = AstronomyHelper.projectBodyToSky(curBody, (CelestialBody)AmunRa.instance.starAmun, partialTicks, this.field_76579_a.func_72820_D());
        float brightnessFactor = 1.0f - (MathHelper.func_76134_b((float)(this.field_76579_a.func_72826_c(partialTicks) * (float)Math.PI * 2.0f + ad.angle)) * 2.0f + 0.5f);
        if (brightnessFactor < 0.0f) {
            brightnessFactor = 0.0f;
        }
        if (brightnessFactor > 1.0f) {
            brightnessFactor = 1.0f;
        }
        brightnessFactor = 1.0f - brightnessFactor;
        return (float)((double)brightnessFactor * 0.5 / (double)ad.distance);
    }

    public CelestialBody getCelestialBody() {
        return this.mothershipObj;
    }

    public long getDayLength() {
        return this.dayLength;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return MothershipChunkProvider.class;
    }

    public float func_76563_a(long par1, float par3) {
        if (this.getDayLength() == 0L) {
            return 0.0f;
        }
        return super.func_76563_a(par1, par3);
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return MothershipWorldChunkManager.class;
    }

    public boolean isDaytime() {
        if (!this.mothershipObj.isInTransit() && this.mothershipObj.getParent() instanceof Star) {
            return true;
        }
        float a = this.field_76579_a.func_72826_c(0.0f);
        return a < 0.42f || a > 0.58f;
    }

    public String func_80007_l() {
        return this.mothershipObj == null ? "Mothership" : this.mothershipObj.getLocalizedName();
    }

    public void updateWeather() {
        if (this.ticksSinceLastUpdate <= 200) {
            ++this.ticksSinceLastUpdate;
        }
        this.field_76579_a.func_72912_H().func_76080_g(0);
        this.field_76579_a.func_72912_H().func_76084_b(false);
        this.field_76579_a.func_72912_H().func_76090_f(0);
        this.field_76579_a.func_72912_H().func_76069_a(false);
        this.field_76579_a.field_73004_o = 0.0f;
        this.field_76579_a.field_73017_q = 0.0f;
        if (!this.field_76579_a.field_72995_K && !this.hasLoadedWorldData) {
            this.mothershipSaveFile = MothershipWorldProviderSaveFile.getSaveFile(this.field_76579_a);
            this.readFromNBT(this.mothershipSaveFile.data);
            if (this.mustSendPacketToClients) {
                this.mustSendPacketToClients = false;
                NBTTagCompound newNbt = new NBTTagCompound();
                this.writeToNBT(newNbt);
                AmunRa.packetPipeline.sendToDimension(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.C_MOTHERSHIP_DATA, this.field_76574_g, newNbt), this.field_76574_g);
            }
            this.hasLoadedWorldData = true;
        }
    }

    public boolean startTransit(CelestialBody target, boolean cheat) {
        if (this.field_76579_a.field_72995_K) {
            return false;
        }
        if (cheat) {
            if (!this.mothershipObj.startTransit(target, 100L)) {
                return false;
            }
            this.applyTransitParams();
            return true;
        }
        this.updateMothership(true);
        TransitDataWithDuration td = this.getTransitDataTo(target);
        if (td.isEmpty()) {
            return false;
        }
        long travelTime = td.duration;
        if (!this.mothershipObj.startTransit(target, travelTime)) {
            return false;
        }
        this.applyTransitParams();
        for (Vector3int loc : this.engineLocations) {
            double curThrust;
            ITileMothershipEngine engine;
            TileEntity tile = this.field_76579_a.func_147438_o(loc.x, loc.y, loc.z);
            if (!(tile instanceof ITileMothershipEngine) || !(engine = (ITileMothershipEngine)tile).isEnabled() || engine.getDirection() != td.direction || (curThrust = engine.getThrust()) <= 0.0) continue;
            engine.beginTransit(travelTime);
        }
        return true;
    }

    public boolean isInTransit() {
        return this.mothershipObj.isInTransit();
    }

    public void endTransit() {
        this.mothershipObj.endTransit();
        if (this.field_76579_a.field_72995_K) {
            return;
        }
        for (Vector3int loc : this.engineLocations) {
            ITileMothershipEngine engine;
            TileEntity t = this.field_76579_a.func_147438_o(loc.x, loc.y, loc.z);
            if (!(t instanceof ITileMothershipEngine) || !(engine = (ITileMothershipEngine)t).isInUse()) continue;
            engine.endTransit();
        }
        this.updateParamsFromParent(true);
    }

    protected void applyTransitParams() {
        this.dayLength = 0L;
        this.thermalLevel = 0.0f;
        this.solarLevel = 0.0;
        this.saveData(true);
    }

    protected void updateParamsFromParent(boolean save) {
        if (this.mothershipObj.isInTransit()) {
            return;
        }
        CelestialBody parent = this.mothershipObj.getParent();
        if (AstronomyHelper.isStar(parent)) {
            this.dayLength = 0L;
            this.thermalLevel = 5.0f;
            this.solarLevel = 10.0;
        } else {
            WorldProvider p;
            this.thermalLevel = AstronomyHelper.getThermalLevel(parent);
            this.solarLevel = AstronomyHelper.getSolarEnergyMultiplier(parent, false);
            this.dayLength = 24000L;
            if (parent.getReachable() && (p = WorldUtil.getProviderForDimensionServer((int)parent.getDimensionID())) instanceof WorldProviderSpace) {
                this.dayLength = ((WorldProviderSpace)p).getDayLength();
            }
        }
        if (save) {
            this.saveData(true);
        }
    }

    public CelestialBody getParent() {
        return ((Mothership)this.getCelestialBody()).getParent();
    }

    public String getSaveFolder() {
        return "DIM_MOTHERSHIP" + this.field_76574_g;
    }

    public double getSolarEnergyMultiplier() {
        return this.solarLevel;
    }

    public float getThermalLevelModifier() {
        return this.thermalLevel;
    }

    public double getHorizon() {
        return 0.0;
    }

    protected TransitData calcTheoreticalTransitData() {
        TransitData[] tDatas = new TransitData[4];
        for (Vector3int loc : this.engineLocations) {
            double curThrust;
            ITileMothershipEngine engine;
            TileEntity tile = this.field_76579_a.func_147438_o(loc.x, loc.y, loc.z);
            if (!(tile instanceof ITileMothershipEngine) || !(engine = (ITileMothershipEngine)tile).isEnabled()) continue;
            int direction = engine.getDirection();
            if (tDatas[direction] == null) {
                tDatas[direction] = new TransitData(direction, 0.0);
            }
            if ((curThrust = engine.getThrust()) <= 0.0) continue;
            tDatas[direction].thrust += curThrust;
        }
        int resultDirection = -1;
        double maxThrust = 0.0;
        for (int i = 0; i < tDatas.length; ++i) {
            if (tDatas[i] == null || tDatas[i].isEmpty() || !(tDatas[i].thrust > maxThrust)) continue;
            maxThrust = tDatas[i].thrust;
            resultDirection = i;
        }
        if (resultDirection == -1) {
            return new TransitData();
        }
        return tDatas[resultDirection];
    }

    public MothershipFuelRequirements getPotentialFuelReqs(CelestialBody target) {
        TransitDataWithDuration data = this.getTransitDataTo(target, true);
        return data.fuelReqData;
    }

    public TransitDataWithDuration getTransitDataTo(CelestialBody target) {
        return this.getTransitDataTo(target, false);
    }

    public TransitDataWithDuration getTransitDataTo(CelestialBody target, boolean potentialData) {
        TransitData generalData = this.calcTheoreticalTransitData();
        double distance = this.mothershipObj.getTravelDistanceTo(target);
        long travelTime = AstronomyHelper.getTravelTimeAU(this.totalMass, generalData.thrust, distance);
        HashSet<Vector3int> curEngineLocations = (HashSet<Vector3int>)this.engineLocations.clone();
        boolean success = false;
        MothershipFuelRequirements fuelReqs = new MothershipFuelRequirements();
        TransitData newData = null;
        while (!success) {
            HashSet<Vector3int> nextEngineLocations = new HashSet<Vector3int>();
            success = true;
            newData = new TransitData();
            newData.direction = generalData.direction;
            fuelReqs.clear();
            for (Vector3int loc : curEngineLocations) {
                ITileMothershipEngine engine;
                TileEntity tile = this.field_76579_a.func_147438_o(loc.x, loc.y, loc.z);
                if (!(tile instanceof ITileMothershipEngine) || (engine = (ITileMothershipEngine)tile).getDirection() != generalData.direction || !engine.isEnabled()) continue;
                if (!potentialData) {
                    if (!engine.canRunForDuration(travelTime)) {
                        success = false;
                        continue;
                    }
                    nextEngineLocations.add(loc);
                    newData.thrust += engine.getThrust();
                    fuelReqs.merge(engine.getFuelRequirements(travelTime));
                    continue;
                }
                newData.thrust += engine.getThrust();
                fuelReqs.merge(engine.getFuelRequirements(travelTime));
            }
            if (success) continue;
            curEngineLocations = nextEngineLocations;
            travelTime = AstronomyHelper.getTravelTimeAU(this.totalMass, newData.thrust, distance);
            generalData = newData;
        }
        TransitDataWithDuration result = new TransitDataWithDuration();
        result.duration = travelTime;
        result.direction = newData.direction;
        result.thrust = newData.thrust;
        if (!fuelReqs.isEmpty()) {
            result.fuelReqData = fuelReqs;
        }
        return result;
    }

    public void asyncSendMothershipDataToClient() {
        if (this.ticksSinceLastUpdate <= 200) {
            this.sendDataToClients();
        } else {
            this.asyncMothershipUpdate();
        }
    }

    public void asyncMothershipUpdate() {
        if (this.isAsyncUpdateRunning) {
            return;
        }
        this.isAsyncUpdateRunning = true;
        MothershipWorldProvider self = this;
        Runnable r = () -> {
            self.updateMothership(true);
            self.isAsyncUpdateRunning = false;
            self.asyncMothershipUpdateFinished();
        };
        Thread t = new Thread(r);
        t.start();
    }

    protected void asyncMothershipUpdateFinished() {
    }

    public void updateMothership(boolean notifyClients) {
        this.checkedChunks.clear();
        this.engineLocations.clear();
        this.totalMass = 0.0f;
        this.totalNumBlocks = 0L;
        this.potentialTransitData = new TransitData();
        this.processChunk(0, 0);
        this.potentialTransitData = this.calcTheoreticalTransitData();
        this.saveData(notifyClients);
    }

    protected void saveData(boolean notifyClients) {
        if (this.mothershipSaveFile == null) {
            this.mothershipSaveFile = MothershipWorldProviderSaveFile.getSaveFile(this.field_76579_a);
        }
        this.writeToNBT(this.mothershipSaveFile.data);
        this.mothershipSaveFile.func_76185_a();
        this.ticksSinceLastUpdate = 0;
        if (notifyClients) {
            this.sendDataToClients();
        }
    }

    protected void sendDataToClients() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        AmunRa.packetPipeline.sendToDimension(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.C_MOTHERSHIP_DATA, this.field_76574_g, nbt), this.field_76574_g);
    }

    protected void processChunk(int x, int z) {
        Vector2int curCoords = new Vector2int(x, z);
        if (this.checkedChunks.contains(curCoords)) {
            return;
        }
        this.checkedChunks.add(curCoords);
        if (!this.field_76579_a.func_72863_F().func_73149_a(x, z)) {
            return;
        }
        Chunk c = this.field_76579_a.func_72964_e(x, z);
        ExtendedBlockStorage[] storage = c.func_76587_i();
        int minY = 256;
        int maxY = -1;
        for (ExtendedBlockStorage st : storage) {
            if (st == null) continue;
            if (st.func_76662_d() < minY) {
                minY = st.func_76662_d();
            }
            if (st.func_76662_d() <= maxY) continue;
            maxY = st.func_76662_d();
        }
        if (minY <= maxY) {
            maxY += 15;
            for (int blockX = 0; blockX < 16; ++blockX) {
                for (int blockZ = 0; blockZ < 16; ++blockZ) {
                    for (int blockY = minY; blockY <= maxY; ++blockY) {
                        Block b = c.func_150810_a(blockX, blockY, blockZ);
                        if (b == Blocks.field_150350_a) continue;
                        int meta = c.func_76628_c(blockX, blockY, blockZ);
                        this.processBlock(b, meta, CoordHelper.rel2abs(blockX, x), blockY, CoordHelper.rel2abs(blockZ, z));
                    }
                }
            }
        }
        this.processChunk(x + 1, z);
        this.processChunk(x - 1, z);
        this.processChunk(x, z + 1);
        this.processChunk(x, z - 1);
    }

    protected void processBlock(Block block, int meta, int x, int y, int z) {
        SubBlock actualBlock;
        float m = BlockMassHelper.getBlockMass(this.field_76579_a, block, meta, x, y, z);
        this.totalMass += m;
        ++this.totalNumBlocks;
        if (block instanceof IMetaBlock && (actualBlock = ((IMetaBlock)block).getSubBlock(meta)) instanceof MothershipEngineJetBase) {
            this.engineLocations.add(new Vector3int(x, y, z));
        }
    }

    public void sendPacketsToClient(EntityPlayerMP player) {
        if (!this.haveReadFromNBT) {
            this.mustSendPacketToClients = true;
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        AmunRa.packetPipeline.sendTo(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.C_MOTHERSHIP_DATA, this.field_76574_g, nbt), player);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.totalMass = nbt.func_74760_g("totalMass");
        this.totalNumBlocks = nbt.func_74763_f("totalNumBlocks");
        NBTTagList list = nbt.func_150295_c("engineLocations", 10);
        this.engineLocations.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound posData = list.func_150305_b(i);
            Vector3int pos = new Vector3int(posData.func_74762_e("x"), posData.func_74762_e("y"), posData.func_74762_e("z"));
            this.engineLocations.add(pos);
        }
        if (this.potentialTransitData == null) {
            this.potentialTransitData = new TransitData();
        }
        this.potentialTransitData.readFromNBT(nbt.func_74775_l("transitData"));
        if (nbt.func_74764_b("dayLength") && nbt.func_74764_b("solarLevel") && nbt.func_74764_b("solarLevel")) {
            this.dayLength = nbt.func_74763_f("dayLength");
            this.solarLevel = nbt.func_74769_h("solarLevel");
            this.thermalLevel = nbt.func_74760_g("thermalLevel");
        } else if (!this.field_76579_a.field_72995_K) {
            this.updateParamsFromParent(false);
        }
        this.haveReadFromNBT = true;
    }

    public void resetRainAndThunder() {
        super.resetRainAndThunder();
        this.mothershipObj.forceArrival();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("totalMass", this.totalMass);
        nbt.func_74772_a("totalNumBlocks", this.totalNumBlocks);
        NBTTagList list = new NBTTagList();
        for (Vector3int v : this.engineLocations) {
            NBTTagCompound pos = new NBTTagCompound();
            pos.func_74768_a("x", v.x);
            pos.func_74768_a("y", v.y);
            pos.func_74768_a("z", v.z);
            list.func_74742_a((NBTBase)pos);
        }
        nbt.func_74782_a("engineLocations", (NBTBase)list);
        NBTTagCompound tData = new NBTTagCompound();
        if (this.potentialTransitData == null) {
            this.potentialTransitData = this.calcTheoreticalTransitData();
        }
        this.potentialTransitData.writeToNBT(tData);
        nbt.func_74782_a("transitData", (NBTBase)tData);
        nbt.func_74776_a("thermalLevel", this.thermalLevel);
        nbt.func_74780_a("solarLevel", this.solarLevel);
        nbt.func_74772_a("dayLength", this.dayLength);
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public ChunkCoordinates getSpawnPoint() {
        return new ChunkCoordinates(0, 64, 0);
    }

    public ChunkCoordinates getRandomizedSpawnPoint() {
        return this.getSpawnPoint();
    }

    @SideOnly(value=Side.CLIENT)
    public void setCloudRenderer(IRenderHandler renderer) {
        super.setCloudRenderer(renderer);
    }

    public boolean isPlayerOwner(EntityPlayer player) {
        return this.mothershipObj.isPlayerOwner(player);
    }

    public boolean isPlayerLandingPermitted(EntityPlayer player) {
        return this.mothershipObj.isPlayerLandingPermitted(player);
    }

    public boolean isPlayerUsagePermitted(EntityPlayer player) {
        return this.mothershipObj.isPlayerUsagePermitted(player);
    }

    public float getGravity() {
        return 0.075f;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public double getFuelUsageMultiplier() {
        return 0.5;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= 0;
    }

    public float getFallDamageModifier() {
        return 0.4f;
    }

    public float getSoundVolReductionAmount() {
        return 50.0f;
    }

    public float getWindLevel() {
        return 0.1f;
    }

    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public double getYCoordinateToTeleport() {
        return 1200.0;
    }

    public class TransitData {
        public int direction = 0;
        public double thrust = 0.0;
        public MothershipFuelRequirements fuelReqData = null;

        public TransitData(int direction, double thrust) {
            this.direction = direction;
            this.thrust = thrust;
        }

        public TransitData() {
            this.direction = 0;
            this.thrust = 0.0;
        }

        public boolean isEmpty() {
            return this.thrust <= 0.0;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.direction = nbt.func_74762_e("direction");
            this.thrust = nbt.func_74769_h("thrust");
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("direction", this.direction);
            nbt.func_74780_a("thrust", this.thrust);
        }
    }

    public class TransitDataWithDuration
    extends TransitData {
        public long duration = 0L;

        @Override
        public boolean isEmpty() {
            return this.duration <= 0L || super.isEmpty();
        }
    }
}

