/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.core.sync.packets;

import cpw.mods.fml.common.Loader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.p455w0rd.wirelesscraftingterminal.core.sync.WCTPacket;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.INetworkInfo;
import net.p455w0rd.wirelesscraftingterminal.handlers.ConfigHandler;
import net.p455w0rd.wirelesscraftingterminal.handlers.RecipeHandler;
import net.p455w0rd.wirelesscraftingterminal.reference.Reference;

public class PacketConfigSync
extends WCTPacket {
    int wirelessTermMaxPower;
    int boosterDropChance;
    boolean easyMode;
    boolean boosterEnabled;
    boolean mineTweakerOverride;
    boolean oldMT = Reference.WCT_MINETWEAKER_OVERRIDE;
    boolean mtChanged = false;

    public PacketConfigSync(ByteBuf stream) {
        this.wirelessTermMaxPower = stream.readInt();
        this.easyMode = stream.readBoolean();
        this.boosterEnabled = stream.readBoolean();
        this.boosterDropChance = stream.readInt();
        this.mineTweakerOverride = stream.readBoolean();
    }

    public PacketConfigSync(int power, boolean mode, boolean booster, int dropChance, boolean mtOverride) {
        this.wirelessTermMaxPower = power;
        this.easyMode = mode;
        this.boosterEnabled = booster;
        this.boosterDropChance = dropChance;
        this.mineTweakerOverride = mtOverride;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(this.wirelessTermMaxPower);
        data.writeBoolean(this.easyMode);
        data.writeBoolean(this.boosterEnabled);
        data.writeInt(this.boosterDropChance);
        data.writeBoolean(this.mineTweakerOverride);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WCTPacket packet, EntityPlayer player) {
    }

    @Override
    public void clientPacketData(INetworkInfo network, WCTPacket packet, EntityPlayer player) {
        if (this.oldMT != this.mineTweakerOverride) {
            this.mtChanged = true;
        }
        Reference.WCT_MAX_POWER = this.wirelessTermMaxPower;
        Reference.WCT_EASYMODE_ENABLED = this.easyMode;
        Reference.WCT_BOOSTER_ENABLED = this.boosterEnabled;
        Reference.WCT_BOOSTER_DROPCHANCE = this.boosterDropChance;
        Reference.WCT_MINETWEAKER_OVERRIDE = this.mineTweakerOverride;
        ConfigHandler.removeBooster();
        ConfigHandler.removeBoosterIcon();
        if (!Loader.isModLoaded((String)"dreamcraft")) {
            RecipeHandler.loadRecipes(this.mtChanged);
        }
        this.mtChanged = false;
    }
}

