/*
 * Decompiled with CFR 0.152.
 */
package rwg.surface;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.surface.SurfaceBase;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.NoiseGenerator;

public class SurfaceMarshFix
extends SurfaceBase {
    private Block cliffBlock1;
    private Block cliffBlock2;

    public SurfaceMarshFix(Block top, Block filler, Block cliff1, Block cliff2) {
        super(top, filler);
        this.cliffBlock1 = cliff1;
        this.cliffBlock2 = cliff2;
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, NoiseGenerator perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float c = CliffCalculator.calc(x, y, noise);
        boolean cliff = c > 1.4f;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            ++depth;
            if (cliff && k > 64) {
                if (depth > -1 && depth < 2) {
                    blocks[(y * 16 + x) * 256 + k] = rand.nextInt(3) == 0 ? this.cliffBlock2 : this.cliffBlock1;
                    continue;
                }
                if (depth >= 10) continue;
                blocks[(y * 16 + x) * 256 + k] = this.cliffBlock1;
                continue;
            }
            if (depth == 0 && k > 61) {
                blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                continue;
            }
            if (depth >= 4) continue;
            blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
        }
    }
}

