/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.loader;

import goodgenerator.loader.ComponentAssemblyLineMiscRecipes;
import goodgenerator.loader.Loaders;
import goodgenerator.util.MyRecipeAdder;
import goodgenerator.util.StackUtils;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_IntegratedCircuit_Item;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class ComponentAssemblyLineRecipeLoader {
    private static final String[] compPrefixes = new String[]{"Electric_Motor_", "Electric_Piston_", "Electric_Pump_", "Robot_Arm_", "Conveyor_Module_", "Emitter_", "Sensor_", "Field_Generator_"};
    private static final String[] blacklistedDictPrefixes = new String[]{"circuit"};
    private static final String[] softBlacklistedDictPrefixes = new String[]{"Any", "crafting"};
    private static LinkedHashMap<List<GT_Recipe>, Pair<ItemList, Integer>> allAssemblerRecipes;
    private static LinkedHashMap<List<GT_Recipe.GT_Recipe_AssemblyLine>, Pair<ItemList, Integer>> allAsslineRecipes;
    private static final HashMap<OrePrefixes, OrePrefixes> conversion;
    private static final int INPUT_MULTIPLIER = 48;
    private static final int OUTPUT_MULTIPLIER = 64;

    public static void run() {
        ComponentAssemblyLineMiscRecipes.run();
        conversion.put(OrePrefixes.cableGt01, OrePrefixes.cableGt16);
        conversion.put(OrePrefixes.wireGt01, OrePrefixes.wireGt16);
        conversion.put(OrePrefixes.cableGt02, OrePrefixes.cableGt16);
        conversion.put(OrePrefixes.wireGt02, OrePrefixes.wireGt16);
        conversion.put(OrePrefixes.cableGt04, OrePrefixes.cableGt16);
        conversion.put(OrePrefixes.wireGt04, OrePrefixes.wireGt16);
        conversion.put(OrePrefixes.cableGt08, OrePrefixes.cableGt16);
        conversion.put(OrePrefixes.wireGt08, OrePrefixes.wireGt16);
        conversion.put(OrePrefixes.plate, OrePrefixes.plateDense);
        conversion.put(OrePrefixes.foil, OrePrefixes.plate);
        conversion.put(OrePrefixes.stick, OrePrefixes.stickLong);
        conversion.put(OrePrefixes.gearGtSmall, OrePrefixes.gearGt);
        ComponentAssemblyLineRecipeLoader.findAllRecipes();
        ComponentAssemblyLineRecipeLoader.generateAssemblerRecipes();
        ComponentAssemblyLineRecipeLoader.generateAsslineRecipes();
    }

    private static void generateAssemblerRecipes() {
        allAssemblerRecipes.forEach((recipeList, info) -> {
            for (GT_Recipe recipe : recipeList) {
                int j;
                if (recipe == null) continue;
                ArrayList<ItemStack> fixedInputs = new ArrayList<ItemStack>();
                ArrayList<FluidStack> fixedFluids = new ArrayList<FluidStack>();
                for (j = 0; j < recipe.mInputs.length; ++j) {
                    ItemStack input = recipe.mInputs[j];
                    if (!GT_Utility.isStackValid((Object)input) || input.func_77973_b() instanceof GT_IntegratedCircuit_Item) continue;
                    fixedInputs.addAll(StackUtils.multiplyAndSplitIntoStacks(input, 48));
                }
                for (j = 0; j < recipe.mFluidInputs.length; ++j) {
                    FluidStack currFluid = recipe.mFluidInputs[j].copy();
                    currFluid.amount *= 48;
                    fixedFluids.add(currFluid);
                }
                int tier = (Integer)info.getRight();
                int energy = (int)Math.min(0x7FFFFFF8L, GT_Values.VP[tier - 1]);
                MyRecipeAdder.instance.addComponentAssemblyLineRecipe(ComponentAssemblyLineRecipeLoader.compactItems(fixedInputs, (Integer)info.getRight()).toArray(new ItemStack[0]), fixedFluids.toArray(new FluidStack[0]), ((ItemList)info.getLeft()).get(64L, new Object[0]), recipe.mDuration * 64, energy, (Integer)info.getRight());
            }
        });
    }

    private static void generateAsslineRecipes() {
        allAsslineRecipes.forEach((recipeList, info) -> {
            for (GT_Recipe.GT_Recipe_AssemblyLine recipe : recipeList) {
                if (recipe == null) continue;
                int componentCircuit = -1;
                for (int i = 0; i < compPrefixes.length; ++i) {
                    if (!((ItemList)info.getLeft()).toString().startsWith(compPrefixes[i])) continue;
                    componentCircuit = i + 1;
                }
                if (componentCircuit == -1) {
                    throw new NullPointerException("Wrong circuit. Comp: " + ((ItemList)info.getLeft()).toString());
                }
                boolean addProgrammedCircuit = componentCircuit <= 7;
                ArrayList<ItemStack> fixedInputs = new ArrayList<ItemStack>();
                ArrayList<FluidStack> fixedFluids = new ArrayList<FluidStack>();
                for (int j = 0; j < recipe.mFluidInputs.length; ++j) {
                    FluidStack currFluid = recipe.mFluidInputs[j].copy();
                    currFluid.amount *= 48;
                    fixedFluids.add(currFluid);
                }
                for (ItemStack input : recipe.mInputs) {
                    if (!GT_Utility.isStackValid((Object)input)) continue;
                    int count = input.field_77994_a;
                    if (input.func_77973_b() instanceof GT_IntegratedCircuit_Item) continue;
                    ItemData data = GT_OreDictUnificator.getAssociation((ItemStack)input);
                    if (data != null && data.mPrefix == OrePrefixes.circuit) {
                        fixedInputs.addAll(StackUtils.multiplyAndSplitIntoStacks(GT_OreDictUnificator.get((OrePrefixes)data.mPrefix, (Object)data.mMaterial.mMaterial, (long)count), 48));
                        continue;
                    }
                    fixedInputs.addAll(StackUtils.multiplyAndSplitIntoStacks(input, 48));
                }
                fixedInputs = ComponentAssemblyLineRecipeLoader.compactItems(fixedInputs, (Integer)info.getRight());
                ComponentAssemblyLineRecipeLoader.replaceIntoFluids(fixedInputs, fixedFluids, 128);
                if (fixedInputs.size() > (addProgrammedCircuit ? 8 : 9)) {
                    ComponentAssemblyLineRecipeLoader.replaceIntoFluids(fixedInputs, fixedFluids, 32);
                }
                if (addProgrammedCircuit) {
                    fixedInputs.add(GT_Utility.getIntegratedCircuit((int)componentCircuit));
                }
                MyRecipeAdder.instance.addComponentAssemblyLineRecipe(fixedInputs.toArray(new ItemStack[0]), fixedFluids.toArray(new FluidStack[0]), ((ItemList)info.getLeft()).get(64L, new Object[0]), recipe.mDuration * 64, recipe.mEUt, (Integer)info.getRight());
            }
        });
    }

    private static void replaceIntoFluids(List<ItemStack> inputs, List<FluidStack> fluidOutputs, int threshold) {
        HashMap<ItemStack, Integer> totals = StackUtils.getTotalItems(inputs.toArray(new ItemStack[0]));
        ArrayList<ItemStack> newInputs = new ArrayList<ItemStack>();
        for (ItemStack input : totals.keySet()) {
            int count = totals.get(input);
            boolean isConverted = false;
            if (OreDictionary.getOreIDs((ItemStack)input).length > 0 && count > threshold) {
                FluidStack foundFluidStack = ComponentAssemblyLineRecipeLoader.tryConvertItemStackToFluidMaterial(input);
                ItemData data = GT_OreDictUnificator.getAssociation((ItemStack)input);
                if (data != null && data.mMaterial.mMaterial == Materials.SamariumMagnetic) {
                    input = GT_OreDictUnificator.get((OrePrefixes)data.mPrefix, (Object)Materials.Samarium, (long)1L);
                    foundFluidStack = ComponentAssemblyLineRecipeLoader.tryConvertItemStackToFluidMaterial(input);
                } else if (data != null && data.mMaterial.mMaterial == Materials.TengamAttuned) {
                    input = GT_OreDictUnificator.get((OrePrefixes)data.mPrefix, (Object)Materials.TengamPurified, (long)1L);
                    foundFluidStack = ComponentAssemblyLineRecipeLoader.tryConvertItemStackToFluidMaterial(input);
                }
                if (foundFluidStack != null) {
                    foundFluidStack.amount *= count;
                    boolean alreadyHasFluid = false;
                    for (FluidStack fluidstack : fluidOutputs) {
                        if (!foundFluidStack.getFluid().equals(fluidstack.getFluid())) continue;
                        fluidstack.amount += foundFluidStack.amount;
                        alreadyHasFluid = true;
                        break;
                    }
                    if (!alreadyHasFluid) {
                        fluidOutputs.add(foundFluidStack);
                    }
                    isConverted = true;
                }
            }
            if (isConverted) continue;
            newInputs.addAll(StackUtils.multiplyAndSplitIntoStacks(input, count));
        }
        inputs.clear();
        inputs.addAll(newInputs);
    }

    @Nullable
    private static FluidStack tryConvertItemStackToFluidMaterial(ItemStack input) {
        ArrayList<String> oreDicts = new ArrayList<String>();
        for (int id : OreDictionary.getOreIDs((ItemStack)input)) {
            oreDicts.add(OreDictionary.getOreName((int)id));
        }
        Object object = oreDicts.iterator();
        block3: while (object.hasNext()) {
            OrePrefixes orePrefix;
            String dict = (String)object.next();
            for (String blacklistedPrefix : blacklistedDictPrefixes) {
                if (!dict.startsWith(blacklistedPrefix)) continue;
                return null;
            }
            for (String blacklistedPrefix : softBlacklistedDictPrefixes) {
                if (dict.startsWith(blacklistedPrefix)) continue block3;
            }
            try {
                orePrefix = OrePrefixes.valueOf((String)ComponentAssemblyLineRecipeLoader.findBestPrefix(dict));
            }
            catch (Exception e) {
                continue;
            }
            String strippedOreDict = dict.substring(orePrefix.toString().length());
            if (strippedOreDict.contains("Any")) continue;
            if (strippedOreDict.contains("PTMEG")) {
                return FluidRegistry.getFluidStack((String)"molten.silicone", (int)((int)(orePrefix.mMaterialAmount / 25200L) * input.field_77994_a));
            }
            return FluidRegistry.getFluidStack((String)("molten." + strippedOreDict.toLowerCase()), (int)((int)(orePrefix.mMaterialAmount / 25200L) * input.field_77994_a));
        }
        return null;
    }

    private static String findBestPrefix(String oreDict) {
        int longestPrefixLength = 0;
        String matchingPrefix = null;
        for (OrePrefixes prefix : OrePrefixes.values()) {
            String name = prefix.toString();
            if (!oreDict.startsWith(name) || name.length() <= longestPrefixLength) continue;
            longestPrefixLength = name.length();
            matchingPrefix = name;
        }
        return matchingPrefix;
    }

    private static ArrayList<ItemStack> compactItems(List<ItemStack> items, int tier) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        HashMap<ItemStack, Integer> totals = StackUtils.getTotalItems(items);
        for (ItemStack itemstack : totals.keySet()) {
            OrePrefixes goInto;
            int totalItems = totals.get(itemstack);
            ItemData data = GT_OreDictUnificator.getAssociation((ItemStack)itemstack);
            boolean isCompacted = false;
            for (String dict : Arrays.stream(OreDictionary.getOreIDs((ItemStack)itemstack)).mapToObj(OreDictionary::getOreName).collect(Collectors.toList())) {
                if (!dict.startsWith("circuit")) continue;
                stacks.addAll(ComponentAssemblyLineRecipeLoader.getWrappedCircuits(itemstack, totalItems, dict));
                isCompacted = true;
            }
            if (data != null && !isCompacted && (goInto = conversion.get(data.mPrefix)) != null && GT_OreDictUnificator.get((OrePrefixes)goInto, (Object)data.mMaterial.mMaterial, (long)1L) != null) {
                ComponentAssemblyLineRecipeLoader.compactorHelper(data, goInto, stacks, totalItems);
                isCompacted = true;
            }
            if (GT_Utility.areStacksEqual((ItemStack)itemstack, (ItemStack)ItemList.Gravistar.get(1L, new Object[0])) && tier >= 9) {
                stacks.addAll(StackUtils.multiplyAndSplitIntoStacks(ItemList.NuclearStar.get(1L, new Object[0]), totalItems / 16));
                isCompacted = true;
            }
            if (isCompacted) continue;
            stacks.addAll(StackUtils.multiplyAndSplitIntoStacks(itemstack, totalItems));
        }
        stacks = StackUtils.mergeStacks(stacks);
        return stacks;
    }

    private static void compactorHelper(ItemData data, OrePrefixes compactInto, ArrayList<ItemStack> output, int total) {
        int materialRatio = (int)((double)compactInto.mMaterialAmount / (double)data.mPrefix.mMaterialAmount);
        output.addAll(StackUtils.multiplyAndSplitIntoStacks(GT_OreDictUnificator.get((OrePrefixes)compactInto, (Object)data.mMaterial.mMaterial, (long)1L), total / materialRatio));
    }

    private static void findAllRecipes() {
        allAssemblerRecipes = new LinkedHashMap();
        allAsslineRecipes = new LinkedHashMap();
        for (String compPrefix : compPrefixes) {
            for (int t = 1; t <= 12; ++t) {
                ArrayList<GT_Recipe.GT_Recipe_AssemblyLine> foundRecipes;
                String vName = GT_Values.VN[t];
                ItemList currentComponent = ItemList.valueOf((String)(compPrefix + vName));
                if (!currentComponent.hasBeenSet()) continue;
                if (t < 6) {
                    foundRecipes = new ArrayList<GT_Recipe.GT_Recipe_AssemblyLine>();
                    for (GT_Recipe.GT_Recipe_AssemblyLine recipe : GT_Recipe.GT_Recipe_Map.sAssemblerRecipes.mRecipeList) {
                        if (!GT_Utility.areStacksEqual((ItemStack)currentComponent.get(1L, new Object[0]), (ItemStack)recipe.mOutputs[0])) continue;
                        foundRecipes.add(recipe);
                    }
                    allAssemblerRecipes.put(foundRecipes, (Pair<ItemList, Integer>)Pair.of((Object)currentComponent, (Object)t));
                    continue;
                }
                foundRecipes = new ArrayList();
                for (GT_Recipe.GT_Recipe_AssemblyLine recipe : GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes) {
                    if (!GT_Utility.areStacksEqual((ItemStack)currentComponent.get(1L, new Object[0]), (ItemStack)recipe.mOutput)) continue;
                    foundRecipes.add(recipe);
                }
                allAsslineRecipes.put(foundRecipes, (Pair<ItemList, Integer>)Pair.of((Object)currentComponent, (Object)t));
            }
        }
    }

    private static List<ItemStack> getWrappedCircuits(ItemStack item, int total, String oreDict) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        String circuitMaterial = oreDict.substring(7);
        int tier = ComponentAssemblyLineMiscRecipes.NameToTier.get(circuitMaterial);
        if (total >= 16) {
            stacks.addAll(StackUtils.multiplyAndSplitIntoStacks(new ItemStack(Loaders.circuitWrap, 1, tier), total / 16));
        } else {
            stacks.addAll(StackUtils.multiplyAndSplitIntoStacks(item, total));
        }
        return stacks;
    }

    static {
        conversion = new HashMap();
    }
}

