/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.blocks.tileEntity.base.GT_MetaTileEntity_TooltipMultiBlockBase_EM;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class CoolantTower
extends GT_MetaTileEntity_TooltipMultiBlockBase_EM
implements IConstructable,
ISurvivalConstructable {
    protected IStructureDefinition<CoolantTower> multiDefinition = null;
    private final int CASING_INDEX = 1542;

    public CoolantTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public CoolantTower(String name) {
        super(name);
    }

    public IStructureDefinition<? extends GT_MetaTileEntity_MultiblockBase_EM> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"           ", "           ", "    BBB    ", "   B   B   ", "  B     B  ", "  B     B  ", "  B     B  ", "   B   B   ", "    BBB    ", "           ", "           "}, {"           ", "           ", "    BBB    ", "   BBBBB   ", "  BB   BB  ", "  BB   BB  ", "  BB   BB  ", "   BBBBB   ", "    BBB    ", "           ", "           "}, {"           ", "           ", "           ", "    BBB    ", "   B   B   ", "   B   B   ", "   B   B   ", "    BBB    ", "           ", "           ", "           "}, {"           ", "           ", "           ", "    BBB    ", "   B   B   ", "   B   B   ", "   B   B   ", "    BBB    ", "           ", "           ", "           "}, {"           ", "           ", "           ", "    BBB    ", "   B   B   ", "   B   B   ", "   B   B   ", "    BBB    ", "           ", "           ", "           "}, {"           ", "           ", "    BBB    ", "   BBBBB   ", "  BB   BB  ", "  BB   BB  ", "  BB   BB  ", "   BBBBB   ", "    BBB    ", "           ", "           "}, {"           ", "           ", "    BBB    ", "   B   B   ", "  B     B  ", "  B     B  ", "  B     B  ", "   B   B   ", "    BBB    ", "           ", "           "}, {"           ", "           ", "    BBB    ", "   B   B   ", "  B     B  ", "  B     B  ", "  B     B  ", "   B   B   ", "    BBB    ", "           ", "           "}, {"           ", "    BBB    ", "   BBBBB   ", "  BB   BB  ", " BB     BB ", " BB     BB ", " BB     BB ", "  BB   BB  ", "   BBBBB   ", "    BBB    ", "           "}, {"           ", "    BBB    ", "   B   B   ", "  B     B  ", " B       B ", " B       B ", " B       B ", "  B     B  ", "   B   B   ", "    BBB    ", "           "}, {"           ", "   BBBBB   ", "  BB   BB  ", " BB     BB ", " B       B ", " B       B ", " B       B ", " BB     BB ", "  BB   BB  ", "   BBBBB   ", "           "}, {"   HH~HH   ", "  HBBBBBH  ", " HB     BH ", "HB       BH", "HB       BH", "HB       BH", "HB       BH", "HB       BH", " HB     BH ", "  HBBBBBH  ", "   HHHHH   "}, {"   CCCCC   ", "  C     C  ", " C       C ", "C         C", "C         C", "C         C", "C         C", "C         C", " C       C ", "  C     C  ", "   CCCCC   "}})).addElement('B', StructureUtility.ofBlockAnyMeta((Block)GregTech_API.sBlockConcretes, (int)8)).addElement('C', GT_StructureUtility.ofFrame((Materials)Materials.TungstenCarbide)).addElement('H', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(CoolantTower.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch}).casingIndex(1542).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.ofBlockAnyMeta((Block)GregTech_API.sBlockConcretes, (int)8)})})).build();
        }
        return this.multiDefinition;
    }

    public final boolean addIOFluidToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        return false;
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mSoftHammer = true;
        this.mHardHammer = true;
        this.mSolderingTool = true;
        this.mCrowbar = true;
        return this.structureCheck_EM(this.mName, 5, 11, 0);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Coolant Tower").addInfo("Controller block for the Coolant Tower.").addInfo("Turn Steam back to Distilled Water.").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().addController("Mid of the second layer.").addInputHatch("Input Hatch", new int[]{1}).addOutputHatch("Output Hatch", new int[]{1}).toolTipFinisher("Good Generator");
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(this.mName, 5, 11, 0, stackSize, hintsOnly);
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return DescTextLocalization.addText("CoolantTower.hint", 3);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new CoolantTower(this.mName);
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aTick % 72000L == 0L) {
            this.mWrench = true;
            this.mScrewdriver = true;
            this.mSoftHammer = true;
            this.mHardHammer = true;
            this.mSolderingTool = true;
            this.mCrowbar = true;
        }
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public boolean onRunningTick(ItemStack aStack) {
        return true;
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        this.mMaxProgresstime = 100;
        int steam = 0;
        for (FluidStack steams : this.getStoredFluids()) {
            if (!GT_Utility.areFluidsEqual((FluidStack)steams, (FluidStack)GT_ModHandler.getSteam((long)1L))) continue;
            steam += steams.amount;
        }
        steam = steam / 160 * 160;
        this.depleteInput(GT_ModHandler.getSteam((long)steam));
        this.addOutput(GT_ModHandler.getDistilledWater((long)(steam / 160)));
        return true;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[12][6], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[12][6], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[12][6]};
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 5, 11, 0, elementBudget, source, actor, false, true);
    }
}

