/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib.util;

import java.util.Random;
import latmod.lib.MathHelperLM;

public class Noise {
    public static final Noise def = new Noise();
    private static final float[] perlin_cosTable = new float[720];
    private final float[] perlin = new float[4096];
    private static final int perlin_TWOPI = 720;
    private static final int perlin_PI = 360;

    public Noise(Random r) {
        if (r == null) {
            r = new Random();
        }
        for (int i = 0; i < this.perlin.length; ++i) {
            this.perlin[i] = r.nextFloat();
        }
    }

    public Noise() {
        this(null);
    }

    private float noise_fsc(double f) {
        return 0.5f * (1.0f - perlin_cosTable[(int)(f * 360.0) % 720]);
    }

    public float get(float x, float y, float z) {
        int i = (int)Math.abs(x);
        int j = (int)Math.abs(y);
        int k = (int)Math.abs(z);
        float f1 = x - (float)i;
        float f2 = y - (float)j;
        float f3 = z - (float)k;
        float f6 = 0.0f;
        float f7 = 0.5f;
        for (int m = 0; m < 4; ++m) {
            int n = i + (j << 4) + (k << 8);
            float f4 = this.noise_fsc(f1);
            float f5 = this.noise_fsc(f2);
            float f8 = this.perlin[n & 0xFFF];
            f8 += f4 * (this.perlin[n + 1 & 0xFFF] - f8);
            float f9 = this.perlin[n + 16 & 0xFFF];
            f9 += f4 * (this.perlin[n + 16 + 1 & 0xFFF] - f9);
            f8 += f5 * (f9 - f8);
            f9 = this.perlin[(n += 256) & 0xFFF];
            f9 += f4 * (this.perlin[n + 1 & 0xFFF] - f9);
            float f10 = this.perlin[n + 16 & 0xFFF];
            f10 += f4 * (this.perlin[n + 16 + 1 & 0xFFF] - f10);
            f9 += f5 * (f10 - f9);
            f8 += this.noise_fsc(f3) * (f9 - f8);
            f6 += f8 * f7;
            f7 *= 0.5f;
            i <<= 1;
            if ((double)(f1 = (float)((double)f1 * 2.0)) >= 1.0) {
                ++i;
                f1 = (float)((double)f1 - 1.0);
            }
            j <<= 1;
            if ((double)(f2 = (float)((double)f2 * 2.0)) >= 1.0) {
                ++j;
                f2 = (float)((double)f2 - 1.0);
            }
            k <<= 1;
            if (!((double)(f3 = (float)((double)f3 * 2.0)) >= 1.0)) continue;
            ++k;
            f3 = (float)((double)f3 - 1.0);
        }
        return f6;
    }

    public float getD(double x, double y, double z) {
        return this.get((float)x, (float)y, (float)z);
    }

    public float getD(double x, double y) {
        return this.get((float)x, (float)y, 0.0f);
    }

    public float getD(double x) {
        return this.get((float)x, 0.0f, 0.0f);
    }

    public float get(float x, float y) {
        return this.get(x, y, 0.0f);
    }

    public float get(float x) {
        return this.get(x, 0.0f, 0.0f);
    }

    static {
        double d = Math.PI / 360;
        for (int i = 0; i < perlin_cosTable.length; ++i) {
            Noise.perlin_cosTable[i] = (float)MathHelperLM.cos((double)i * d);
        }
    }
}

