/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib;

import java.util.HashMap;
import java.util.Map;
import latmod.lib.IntList;

public class IntMap {
    public final IntList list;

    public IntMap(int s) {
        this.list = new IntList(s * 2);
    }

    public IntMap() {
        this(0);
    }

    public int size() {
        return this.list.size() / 2;
    }

    public String toString() {
        if (this.list.isEmpty()) {
            return "{ }";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append(' ');
        for (int i = 0; i < this.list.size(); i += 2) {
            sb.append(this.list.get(i));
            sb.append('=');
            sb.append(this.list.get(i + 1));
            if (i == this.list.size() - 2) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append(' ');
        sb.append('}');
        return sb.toString();
    }

    public int[] toArray() {
        return this.list.toArray();
    }

    public void fromArray(int[] ai) {
        this.list.clear();
        this.list.addAll(ai);
    }

    private int keyIndex(int key) {
        for (int i = 0; i < this.list.size(); i += 2) {
            if (this.list.get(i) != key) continue;
            return i;
        }
        return -1;
    }

    public void put(int key, int value) {
        int index = this.keyIndex(key);
        if (index != -1) {
            this.list.set(index + 1, value);
        } else {
            this.list.add(key);
            this.list.add(value);
        }
    }

    public int get(int key) {
        return this.list.get(this.keyIndex(key) + 1);
    }

    public Map<Integer, Integer> toMap() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.list.size(); i += 2) {
            map.put(this.list.get(i), this.list.get(i + 1));
        }
        return map;
    }

    public static IntMap fromMap(Map<Integer, Integer> map) {
        if (map == null) {
            return null;
        }
        if (map.isEmpty()) {
            return new IntMap();
        }
        IntMap m = new IntMap(map.size());
        for (Map.Entry<Integer, Integer> e : map.entrySet()) {
            m.put(e.getKey(), e.getValue());
        }
        return m;
    }

    public boolean containsKey(int key) {
        return this.keyIndex(key) != -1;
    }

    public void clear() {
        this.list.clear();
    }

    public IntList getKeys() {
        IntList list1 = new IntList(this.list.size() / 2);
        if (this.list.isEmpty()) {
            return list1;
        }
        for (int i = 0; i < this.list.size(); i += 2) {
            list1.add(this.list.get(i));
        }
        return list1;
    }

    public IntList getValues() {
        IntList list1 = new IntList(this.list.size() / 2);
        if (this.list.isEmpty()) {
            return list1;
        }
        for (int i = 0; i < this.list.size(); i += 2) {
            list1.add(this.list.get(i + 1));
        }
        return list1;
    }
}

