/*
 * Decompiled with CFR 0.152.
 */
package openmods.proxy;

import com.google.common.base.Optional;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.network.IGuiHandler;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import openmods.LibConfig;
import openmods.Log;
import openmods.OpenMods;
import openmods.block.BlockSelectionHandler;
import openmods.calc.command.CommandCalc;
import openmods.calc.command.CommandCalcFactory;
import openmods.calc.command.ICommandComponent;
import openmods.config.properties.CommandConfig;
import openmods.gui.ClientGuiHandler;
import openmods.movement.PlayerMovementManager;
import openmods.proxy.IOpenModsProxy;
import openmods.source.CommandSource;
import openmods.stencil.FramebufferConstants;
import openmods.stencil.StencilPoolManager;
import openmods.utils.render.RenderUtils;

public final class OpenClientProxy
implements IOpenModsProxy {
    @Override
    public EntityPlayer getThePlayer() {
        return FMLClientHandler.instance().getClient().field_71439_g;
    }

    @Override
    public boolean isClientPlayer(Entity player) {
        return player instanceof EntityPlayerSP;
    }

    @Override
    public long getTicks(World worldObj) {
        if (worldObj != null) {
            return worldObj.func_82737_E();
        }
        World cWorld = this.getClientWorld();
        if (cWorld != null) {
            return cWorld.func_82737_E();
        }
        return 0L;
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public World getServerWorld(int id) {
        return DimensionManager.getWorld((int)id);
    }

    @Override
    public File getMinecraftDir() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @Override
    public String getLogFileName() {
        return "ForgeModLoader-client-0.log";
    }

    @Override
    public Optional<String> getLanguage() {
        return Optional.fromNullable((Object)Minecraft.func_71410_x().field_71474_y.field_74363_ab);
    }

    @Override
    public IGuiHandler wrapHandler(IGuiHandler modSpecificHandler) {
        return new ClientGuiHandler(modSpecificHandler);
    }

    @Override
    public void preInit() {
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandConfig("om_config_c", false));
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandSource("om_source_c", false, OpenMods.instance.getCollector()));
        if (LibConfig.enableCalculatorCommands) {
            ICommandComponent commandRoot = new CommandCalcFactory(new File(this.getMinecraftDir(), "scripts")).getRoot();
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCalc(commandRoot, "config", new String[0]));
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCalc(commandRoot, "eval", "="));
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCalc(commandRoot, "fun", new String[0]));
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCalc(commandRoot, "let", new String[0]));
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCalc(commandRoot, "execute", new String[0]));
        }
        RenderUtils.registerFogUpdater();
        MinecraftForge.EVENT_BUS.register((Object)new BlockSelectionHandler());
        FMLCommonHandler.instance().registerCrashCallable(new ICrashCallable(){

            public String call() throws Exception {
                StencilPoolManager.StencilPool pool = StencilPoolManager.pool();
                return String.format("Function set: %s, pool: %s, bits: %s", FramebufferConstants.getMethodSet(), pool.getType(), pool.getSize());
            }

            public String getLabel() {
                return "Stencil buffer state";
            }
        });
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        if (!PlayerMovementManager.isCallbackInjected()) {
            Log.info("EntityPlayerSP movement callback patch not applied, using legacy solution", new Object[0]);
            FMLCommonHandler.instance().bus().register((Object)new PlayerMovementManager.LegacyTickHandler());
        }
    }

    @Override
    public void setNowPlayingTitle(String nowPlaying) {
        Minecraft.func_71410_x().field_71456_v.func_73833_a(nowPlaying);
    }

    @Override
    public EntityPlayer getPlayerFromHandler(INetHandler handler) {
        if (handler instanceof NetHandlerPlayServer) {
            return ((NetHandlerPlayServer)handler).field_147369_b;
        }
        if (handler instanceof NetHandlerPlayClient) {
            return this.getThePlayer();
        }
        return null;
    }
}

