/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory.handlers.warpevents;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import shukaro.warptheory.handlers.ITimerWarpEvent;
import shukaro.warptheory.util.ChatHelper;
import shukaro.warptheory.util.FormatCodes;

public class WarpCountdownBomb
extends ITimerWarpEvent {
    private static final String COUNTDOWN = "timer";

    public WarpCountdownBomb(int minWarp) {
        super("countdownbomb", minWarp, world -> 1, COUNTDOWN);
    }

    @Override
    public void sendChatMessage(EntityPlayer player) {
    }

    @Override
    public int triggerEvent(int eventAmount, World world, EntityPlayer player) {
        this.setTimer(player, COUNTDOWN, 11);
        return 1;
    }

    @Override
    public void timerTick(World world, EntityPlayer player, String timer, int timerCount) {
        if (timer.equals(COUNTDOWN)) {
            String color = timerCount > 5 ? FormatCodes.Purple.code : FormatCodes.Red.code;
            String format = timerCount > 2 ? FormatCodes.Italic.code : FormatCodes.Bold.code;
            String text = StatCollector.func_74838_a((String)String.format("chat.warptheory.%s.%d", this.name, timerCount));
            ChatHelper.sendToPlayer(player, color + format + text);
            int numParticles = 8 * (10 - timerCount);
            double particleSpeed = 0.3;
            ((WorldServer)world).func_147487_a("fireworksSpark", player.field_70165_t, player.field_70163_u, player.field_70161_v, numParticles, 0.0, 0.0, 0.0, particleSpeed);
            if (timerCount > 0) {
                world.func_72956_a((Entity)player, "game.tnt.primed", 1.0f, 1.0f);
            } else {
                world.func_72876_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, 3.0f, true);
            }
        }
    }

    @Override
    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        if (e.world.func_82737_E() % 20L != 0L) {
            return;
        }
        super.onTick(e);
    }
}

