/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.locations;

import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.integration.model.locations.ILocationProvider;
import net.minecraftforge.fluids.Fluid;

public class UndergroundFluidLocation
implements ILocationProvider {
    private final UndergroundFluidPosition undergroundFluidPosition;
    private final int minProduction;
    private final int maxProduction;

    public UndergroundFluidLocation(UndergroundFluidPosition undergroundFluidPosition) {
        this.undergroundFluidPosition = undergroundFluidPosition;
        this.minProduction = undergroundFluidPosition.getMinProduction();
        this.maxProduction = undergroundFluidPosition.getMaxProduction();
    }

    @Override
    public int getDimensionId() {
        return this.undergroundFluidPosition.dimensionId;
    }

    @Override
    public double getBlockX() {
        return (double)this.undergroundFluidPosition.getBlockX() + 0.5;
    }

    @Override
    public double getBlockZ() {
        return (double)this.undergroundFluidPosition.getBlockZ() + 0.5;
    }

    public int getMinProduction() {
        return this.minProduction;
    }

    public int getMaxProduction() {
        return this.maxProduction;
    }

    public Fluid getFluid() {
        return this.undergroundFluidPosition.fluid;
    }
}

