/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.common;

import codechicken.core.featurehack.GameDataManipulator;
import codechicken.enderstorage.EnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.storage.item.ItemEnderChestDummy;
import codechicken.lib.inventory.InventoryUtils;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;

public class EnderStorageRecipe
implements IRecipe {
    public static String[] oreDictionaryNames = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};

    public boolean func_77569_a(InventoryCrafting ic, World var2) {
        for (int row = 0; row < 2; ++row) {
            if (!this.offsetMatchesDyes(ic, 0, row)) continue;
            return true;
        }
        return false;
    }

    private boolean offsetMatchesDyes(InventoryCrafting ic, int col, int row) {
        if (!EnderStorageRecipe.stackMatches(ic.func_70463_b(col + 1, row + 1), Item.func_150898_a((Block)EnderStorage.blockEnderChest))) {
            return false;
        }
        boolean hasDye = false;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (i == row + 1 && j == col + 1) continue;
                ItemStack stack = ic.func_70463_b(j, i);
                if (i == row && EnderStorageRecipe.getDyeType(stack) >= 0) {
                    hasDye = true;
                    continue;
                }
                if (stack == null) continue;
                return false;
            }
        }
        return hasDye;
    }

    public static boolean stackMatches(ItemStack stack, Item item) {
        return stack != null && stack.func_77973_b() == item;
    }

    public ItemStack func_77572_b(InventoryCrafting ic) {
        for (int row = 0; row < 2; ++row) {
            if (!this.offsetMatchesDyes(ic, 0, row)) continue;
            ItemStack freqowner = ic.func_70463_b(1, row + 1);
            int freq = freqowner.func_77960_j() & 0xFFF;
            int colour1 = this.recolour(0, row, freq, ic);
            int colour2 = this.recolour(1, row, freq, ic);
            int colour3 = this.recolour(2, row, freq, ic);
            ItemStack result = InventoryUtils.copyStack((ItemStack)freqowner, (int)1);
            result.func_77964_b(EnderStorageManager.getFreqFromColours(colour3, colour2, colour1) | freqowner.func_77960_j() & 0xF000);
            return result;
        }
        return null;
    }

    private int recolour(int i, int row, int freq, InventoryCrafting ic) {
        int dyeType = EnderStorageRecipe.getDyeType(ic.func_70463_b(i, row));
        if (dyeType >= 0) {
            return ~dyeType & 0xF;
        }
        return EnderStorageManager.getColourFromFreq(freq, 2 - i);
    }

    public int func_77570_a() {
        return 6;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((Block)EnderStorage.blockEnderChest);
    }

    public static void init() {
        EnderStorageRecipe instance = new EnderStorageRecipe();
        GameRegistry.addRecipe((IRecipe)instance);
        RecipeSorter.register((String)"enderstorage:recolour", EnderStorageRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"");
        if (!Loader.isModLoaded((String)"dreamcraft")) {
            EnderStorageRecipe.addNormalRecipies();
        }
    }

    public static void removeVanillaChest() {
        GameDataManipulator.replaceItem((int)Block.func_149682_b((Block)Blocks.field_150477_bB), (Item)new ItemEnderChestDummy());
        Iterator iterator = CraftingManager.func_77594_a().func_77592_b().iterator();
        while (iterator.hasNext()) {
            ItemStack r = ((IRecipe)iterator.next()).func_77571_b();
            if (r == null || r.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150477_bB)) continue;
            iterator.remove();
        }
        if (!EnderStorage.removeVanillaRecipe) {
            CraftingManager.func_77594_a().func_92103_a(new ItemStack(Blocks.field_150477_bB), new Object[]{"OOO", "OeO", "OOO", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('e'), Items.field_151061_bv});
        }
    }

    private static void addNormalRecipies() {
        for (int i = 0; i < 16; ++i) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)EnderStorage.blockEnderChest, 1, EnderStorageManager.getFreqFromColours(i, i, i)), (Object[])new Object[]{"bWb", "OCO", "bpb", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('p'), Items.field_151079_bi, Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)EnderStorage.itemEnderPouch, 1, EnderStorageManager.getFreqFromColours(i, i, i)), (Object[])new Object[]{"blb", "lpl", "bWb", Character.valueOf('b'), Items.field_151065_br, Character.valueOf('p'), Items.field_151079_bi, Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, i)});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)EnderStorage.blockEnderChest, 1, 0x1000 | EnderStorageManager.getFreqFromColours(i, i, i)), (Object[])new Object[]{"bWb", "OCO", "bpb", Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('p'), Items.field_151079_bi, Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('C'), Items.field_151066_bu, Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, i)});
        }
    }

    public static int getDyeType(ItemStack item) {
        if (item == null) {
            return -1;
        }
        if (item.func_77973_b() == Items.field_151100_aR) {
            return item.func_77960_j();
        }
        for (int i = 0; i < 16; ++i) {
            for (ItemStack target : OreDictionary.getOres((String)oreDictionaryNames[i])) {
                if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)item, (boolean)false)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getDyeColour(String string) {
        for (int i = 0; i < 16; ++i) {
            if (!oreDictionaryNames[i].substring(3).equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }
}

