/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.blocks;

import com.sinthoras.hydroenergy.blocks.HEWater;
import com.sinthoras.hydroenergy.client.renderer.HEWaterRenderer;
import com.sinthoras.hydroenergy.server.HEBlockQueue;
import com.sinthoras.hydroenergy.server.HEServer;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class HEWaterStill
extends HEWater {
    public HEWaterStill(int waterId) {
        super(waterId);
        this.func_149675_a(false);
    }

    public int func_149645_b() {
        return HEWaterRenderer.instance.getRenderId();
    }

    public boolean func_149646_a(IBlockAccess world, int blockX, int blockY, int blockZ, int side) {
        Block block = world.func_147439_a(blockX, blockY, blockZ);
        if (block != this) {
            return !block.func_149662_c();
        }
        return false;
    }

    public void func_149695_a(World world, int blockX, int blockY, int blockZ, Block block) {
        this.spread(world, blockX, blockY, blockZ);
    }

    public void func_149726_b(World world, int blockX, int blockY, int blockZ) {
    }

    private void spread(World world, int blockX, int blockY, int blockZ) {
        int waterId = this.getWaterId();
        boolean canSpread = HEServer.instance.canSpread(waterId);
        if (canSpread && blockY < HEServer.instance.getWaterLimitUp(waterId)) {
            HEBlockQueue.enqueueBlock(world, blockX, blockY + 1, blockZ, waterId);
        }
        if (canSpread && blockY > HEServer.instance.getWaterLimitDown(waterId)) {
            HEBlockQueue.enqueueBlock(world, blockX, blockY - 1, blockZ, waterId);
        }
        if (canSpread && blockX < HEServer.instance.getWaterLimitEast(waterId)) {
            HEBlockQueue.enqueueBlock(world, blockX + 1, blockY, blockZ, waterId);
        }
        if (canSpread && blockX > HEServer.instance.getWaterLimitWest(waterId)) {
            HEBlockQueue.enqueueBlock(world, blockX - 1, blockY, blockZ, waterId);
        }
        if (canSpread && blockZ < HEServer.instance.getWaterLimitSouth(waterId)) {
            HEBlockQueue.enqueueBlock(world, blockX, blockY, blockZ + 1, waterId);
        }
        if (canSpread && blockZ > HEServer.instance.getWaterLimitNorth(waterId)) {
            HEBlockQueue.enqueueBlock(world, blockX, blockY, blockZ - 1, waterId);
        }
        if (!canSpread || HEServer.instance.isBlockOutOfBounds(waterId, blockX, blockY, blockZ)) {
            HEBlockQueue.enqueueBlock(world, blockX, blockY, blockZ, waterId);
        }
    }
}

