/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.gui;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import tuhljin.automagy.gui.ContainerVisReader;
import tuhljin.automagy.gui.GuiButtonCheckbox;
import tuhljin.automagy.gui.GuiButtonScaledText;
import tuhljin.automagy.gui.ModGuiContainer;
import tuhljin.automagy.network.MessageGUIVisReader;
import tuhljin.automagy.network.PacketHandler;
import tuhljin.automagy.tiles.TileEntityVisReader;

public class GUIVisReader
extends ModGuiContainer {
    public TileEntityVisReader te;
    public final ResourceLocation texture = new ResourceLocation("Automagy:textures/gui/visReader.png");
    protected GuiButtonScaledText[] btnCapacity = new GuiButtonScaledText[4];
    protected GuiButtonScaledText[] btnOutput = new GuiButtonScaledText[4];
    public static final String[] strMode = new String[]{StatCollector.func_74838_a((String)"Automagy.gui.visReader.mode.0"), StatCollector.func_74838_a((String)"Automagy.gui.visReader.mode.1"), StatCollector.func_74838_a((String)"Automagy.gui.visReader.mode.2"), StatCollector.func_74838_a((String)"Automagy.gui.visReader.mode.3"), StatCollector.func_74838_a((String)"Automagy.gui.visReader.mode.4")};
    public static final String[] strCapacity = new String[]{StatCollector.func_74838_a((String)"Automagy.gui.visReader.capacity.auto"), "1", "8", "16", "25", "32", "50", "64", "100", "125"};
    public static final String[] strDir = new String[]{StatCollector.func_74838_a((String)"Automagy.gui.visReader.dir.all"), StatCollector.func_74838_a((String)"Automagy.gui.visReader.dir.N"), StatCollector.func_74838_a((String)"Automagy.gui.visReader.dir.E"), StatCollector.func_74838_a((String)"Automagy.gui.visReader.dir.S"), StatCollector.func_74838_a((String)"Automagy.gui.visReader.dir.W"), StatCollector.func_74838_a((String)"Automagy.gui.visReader.dir.D")};
    public static final int[] strDirLookup = new int[]{5, -1, 1, 3, 4, 2, 0};
    public static final int[] strDirLookupReverse = new int[]{6, 2, 5, 3, 4, 0};

    private GUIVisReader(InventoryPlayer inventoryPlayer, TileEntityVisReader te, ContainerVisReader container) {
        super(container);
        this.te = te;
        this.field_147000_g = 178;
        container.attachedGUI = this;
    }

    public GUIVisReader(InventoryPlayer inventoryPlayer, TileEntityVisReader te) {
        this(inventoryPlayer, te, new ContainerVisReader(inventoryPlayer, te));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int height = (int)(20.0f * this.scaleFactor);
        int leftOffset = 29;
        int i = 0;
        while (true) {
            if (i >= 4) break;
            this.field_146292_n.add(new GuiButtonScaledText(i * 4, this.field_147003_i + leftOffset, this.field_147009_r + 11 + (height + 4) * i, 56, height, strMode[this.te.modes[i]], this.scaleFactor));
            int iC = this.te.capacities[i];
            if (iC != 0) {
                int index = Arrays.asList(strCapacity).indexOf(String.valueOf(iC));
                iC = Math.max(index, 0);
            }
            this.btnCapacity[i] = new GuiButtonScaledText(i * 4 + 1, this.field_147003_i + leftOffset + 57, this.field_147009_r + 11 + (height + 4) * i, 36, height, strCapacity[iC], this.scaleFactor);
            this.field_146292_n.add(this.btnCapacity[i]);
            String s = strDirLookup[this.te.outputDirs[i]] == -1 ? "invalid" : strDir[strDirLookup[this.te.outputDirs[i]]];
            this.btnOutput[i] = new GuiButtonScaledText(i * 4 + 2, this.field_147003_i + leftOffset + 94, this.field_147009_r + 11 + (height + 4) * i, 27, height, s, this.scaleFactor);
            this.field_146292_n.add(this.btnOutput[i]);
            this.field_146292_n.add(new GuiButtonCheckbox(i * 4 + 3, this.field_147003_i + leftOffset + 126, this.field_147009_r + 14 + (height + 4) * i, this.te.inverseSignals[i], this.texture, this.field_146999_f, 0));
            ++i;
        }
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        int leftOffset = 29;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scaleFactor, (float)this.scaleFactor, (float)this.scaleFactor);
        this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.visReader.mode.col"), this.field_147003_i + leftOffset + 2, this.field_147009_r, 0xFFFFFF);
        this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.visReader.capacity.col"), this.field_147003_i + leftOffset + 59, this.field_147009_r, 0xFFFFFF);
        this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.visReader.dir.col"), this.field_147003_i + leftOffset + 96, this.field_147009_r, 0xFFFFFF);
        this.drawStringScaled(this.field_146289_q, StatCollector.func_74838_a((String)"Automagy.gui.visReader.invert"), this.field_147003_i + leftOffset + 124, this.field_147009_r, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    @Override
    protected void buttonClicked(GuiButton button, boolean rightClick) {
        String[] strArr;
        int type = button.field_146127_k % 4;
        switch (type) {
            case 0: {
                strArr = strMode;
                break;
            }
            case 1: {
                strArr = strCapacity;
                break;
            }
            case 2: {
                strArr = strDir;
                break;
            }
            case 3: {
                if (button instanceof GuiButtonCheckbox) {
                    GuiButtonCheckbox checkbox = (GuiButtonCheckbox)button;
                    checkbox.checked = !checkbox.checked;
                    PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGUIVisReader(button.field_146127_k, checkbox.checked ? 1 : 0));
                }
                return;
            }
            default: {
                return;
            }
        }
        int i = Arrays.asList(strArr).indexOf(button.field_146126_j);
        if (rightClick) {
            if (--i < 0) {
                i = strArr.length - 1;
            }
        } else if (++i >= strArr.length) {
            i = 0;
        }
        button.field_146126_j = strArr[i];
        if (type == 0) {
            int index = button.field_146127_k / 4;
            this.btnCapacity[index].field_146124_l = i != 0 && i != 4;
            this.btnOutput[index].field_146124_l = i != 0;
        } else if (type == 1) {
            if (i != 0) {
                int num;
                try {
                    num = Integer.valueOf(button.field_146126_j);
                }
                catch (Exception ex) {
                    FMLLog.warning((String)"[Automagy] GUIVisReader failed to translate button info into usable packet data. (capacity)", (Object[])new Object[0]);
                    return;
                }
                i = num < 1 ? 1 : (num > 1000 ? 1000 : num);
            }
        } else if (type == 2) {
            try {
                i = strDirLookupReverse[i];
            }
            catch (Exception ex) {
                FMLLog.warning((String)"[Automagy] GUIVisReader failed to translate button info into usable packet data. (output dir)", (Object[])new Object[0]);
                return;
            }
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGUIVisReader(button.field_146127_k, i));
    }

    public void updateButton(int id, int stringIndex) {
        String[] strArr;
        GuiButton button;
        try {
            button = (GuiButton)this.field_146292_n.get(id);
        }
        catch (Exception ex) {
            FMLLog.warning((String)("[Automagy] GUIVisReader updateButton request was invalid. (id=" + id + ")"), (Object[])new Object[0]);
            return;
        }
        if (button instanceof GuiButtonCheckbox) {
            ((GuiButtonCheckbox)button).checked = stringIndex == 1;
            return;
        }
        int type = button.field_146127_k % 4;
        switch (type) {
            case 0: {
                strArr = strMode;
                int index = id / 4;
                this.btnCapacity[index].field_146124_l = this.te.modes[index] != 0 && this.te.modes[index] != 4;
                this.btnOutput[index].field_146124_l = this.te.modes[index] != 0;
                break;
            }
            case 1: {
                if (stringIndex != 0) {
                    int i = Arrays.asList(strCapacity).indexOf(String.valueOf(stringIndex));
                    stringIndex = Math.max(i, 0);
                }
                strArr = strCapacity;
                break;
            }
            case 2: {
                if (stringIndex < 0 || stringIndex >= strDirLookup.length || strDirLookup[stringIndex] == -1) {
                    FMLLog.warning((String)("[Automagy] GUIVisReader updateButton request was invalid. Ignoring. (id=" + id + ", stringIndex=" + stringIndex + ")"), (Object[])new Object[0]);
                    return;
                }
                stringIndex = strDirLookup[stringIndex];
                strArr = strDir;
                break;
            }
            default: {
                FMLLog.warning((String)("[Automagy] GUIVisReader updateButton request was invalid. Ignoring. (id=" + id + ")"), (Object[])new Object[0]);
                return;
            }
        }
        if (stringIndex < 0 || stringIndex >= strArr.length) {
            FMLLog.warning((String)("[Automagy] GUIVisReader updateButton request was invalid. Ignoring. (stringIndex=" + stringIndex + ")"), (Object[])new Object[0]);
            return;
        }
        button.field_146126_j = strArr[stringIndex];
    }
}

