/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.packet;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Objects;
import ru.timeconqueror.lootgames.api.packet.IClientGamePacket;
import ru.timeconqueror.lootgames.api.packet.IServerGamePacket;

public abstract class GamePacketRegistry {
    private static final Storage<IClientGamePacket> CLIENT_STORAGE = new Storage();
    private static final Storage<IServerGamePacket> SERVER_STORAGE = new Storage();

    public static Storage<IClientGamePacket> clientStorage() {
        return CLIENT_STORAGE;
    }

    public static Storage<IServerGamePacket> serverStorage() {
        return SERVER_STORAGE;
    }

    public static class Key {
        private final String modId;
        private final int packetId;

        public Key(String modId, int packetId) {
            this.modId = modId;
            this.packetId = packetId;
        }

        public String getModId() {
            return this.modId;
        }

        public int getPacketId() {
            return this.packetId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key that = (Key)o;
            return this.packetId == that.packetId && this.modId.equals(that.modId);
        }

        public int hashCode() {
            return Objects.hash(this.modId, this.packetId);
        }

        public String toString() {
            return this.modId + ":" + this.packetId;
        }
    }

    public static class Storage<T> {
        private final BiMap<Key, Class<? extends T>> packets = HashBiMap.create();

        public Class<? extends T> getPacketClass(Key key) {
            Class packet = (Class)this.packets.get((Object)key);
            if (packet == null) {
                throw new NullPointerException(String.format("The packet with key %s doesn't exist.", key));
            }
            return packet;
        }

        public Key getKey(Class<? extends T> packetClass) {
            Key info = (Key)this.packets.inverse().get(packetClass);
            if (info == null) {
                throw new NullPointerException(String.format("The packet %s wasn't registered.", packetClass));
            }
            return info;
        }

        public void regPacket(String modId, int packetId, Class<? extends T> packetClass) {
            Key key = new Key(modId, packetId);
            try {
                if (this.packets.put((Object)key, packetClass) != null) {
                    throw new RuntimeException(String.format("Id %s has been already registered.", key));
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(String.format("Packet %s has been already registered.", packetClass.getName()));
            }
        }
    }
}

