/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import java.awt.Color;
import journeymap.client.Constants;
import journeymap.client.cartography.RGB;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.forge.helper.IRenderHelper;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;

public class GridSpec {
    private static final IRenderHelper renderHelper = ForgeHelper.INSTANCE.getRenderHelper();
    public final Style style;
    public final float red;
    public final float green;
    public final float blue;
    public final float alpha;
    private int colorX = -1;
    private int colorY = -1;

    public GridSpec(Style style, Color color, float alpha) {
        this.style = style;
        float[] rgb = RGB.floats(color.getRGB());
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
        if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        while (alpha > 1.0f) {
            alpha /= 100.0f;
        }
        this.alpha = alpha;
        assert (alpha <= 1.0f);
    }

    public GridSpec(Style style, float red, float green, float blue, float alpha) {
        this.style = style;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        assert (alpha <= 1.0f);
    }

    public GridSpec setColorCoords(int x, int y) {
        this.colorX = x;
        this.colorY = y;
        return this;
    }

    public void beginTexture(int textureWrap, float mapAlpha) {
        renderHelper.glEnableBlend();
        renderHelper.glBlendFunc(770, 771, 1, 0);
        renderHelper.glEnableTexture2D();
        renderHelper.glBindTexture(this.getTexture().func_110552_b());
        renderHelper.glColor4f(this.red, this.green, this.blue, this.alpha * mapAlpha);
        renderHelper.glTexParameteri(3553, 10241, 9728);
        renderHelper.glTexParameteri(3553, 10240, 9728);
        renderHelper.glTexParameteri(3553, 10242, textureWrap);
        renderHelper.glTexParameteri(3553, 10243, textureWrap);
    }

    public TextureImpl getTexture() {
        return TextureCache.instance().getGrid(this.style.textureName);
    }

    public GridSpec clone() {
        return new GridSpec(this.style, this.red, this.green, this.blue, this.alpha).setColorCoords(this.colorX, this.colorY);
    }

    public void finishTexture() {
        renderHelper.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        renderHelper.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Integer getColor() {
        return RGB.toInteger(this.red, this.green, this.blue);
    }

    public int getColorX() {
        return this.colorX;
    }

    public int getColorY() {
        return this.colorY;
    }

    public static enum Style {
        Squares("jm.common.grid_style_squares", TextureCache.Name.GridSquares),
        Dots("jm.common.grid_style_dots", TextureCache.Name.GridDots),
        Checkers("jm.common.grid_style_checkers", TextureCache.Name.GridCheckers);

        private final String key;
        private final TextureCache.Name textureName;

        private Style(String key, TextureCache.Name textureName) {
            this.key = key;
            this.textureName = textureName;
        }

        public String displayName() {
            return Constants.getString(this.key);
        }
    }
}

