/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory.gui;

import appeng.client.gui.AEBaseGui;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.util.ResourceLocation;

public class MouseRegionManager {
    private final GuiContainer gui;
    private final List<Region> regions = new ArrayList<Region>();

    public MouseRegionManager(GuiContainer gui) {
        this.gui = gui;
    }

    public void addRegion(int x, int y, int width, int height, Handler handler) {
        this.regions.add(new Region(x, y, width, height, handler));
    }

    public boolean onClick(int mX, int mY, int button) {
        mX -= this.gui.field_147003_i;
        mY -= this.gui.field_147009_r;
        for (Region region : this.regions) {
            if (!region.containsMouse(mX, mY) || !region.handler.onClick(button)) continue;
            this.gui.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            return false;
        }
        return true;
    }

    public void render(int mX, int mY) {
        mX -= this.gui.field_147003_i;
        mY -= this.gui.field_147009_r;
        for (Region region : this.regions) {
            List<String> tooltip;
            if (!region.containsMouse(mX, mY) || (tooltip = region.handler.getTooltip()) == null) continue;
            ((AEBaseGui)this.gui).drawTooltip(mX, mY, 0, String.join((CharSequence)"\n", tooltip));
            return;
        }
    }

    public static interface Handler {
        @Nullable
        default public List<String> getTooltip() {
            return null;
        }

        default public boolean onClick(int button) {
            return false;
        }
    }

    private static class Region {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final Handler handler;

        Region(int x, int y, int width, int height, Handler handler) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.handler = handler;
        }

        boolean containsMouse(int mX, int mY) {
            return mX >= this.x && mX < this.x + this.width && mY >= this.y && mY < this.y + this.height;
        }
    }
}

