/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui;

import com.enderio.core.client.gui.widget.GuiToolTip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;

public class ToolTipManager {
    private List<GuiToolTip> toolTips = new ArrayList<GuiToolTip>();

    public void addToolTip(GuiToolTip toolTip) {
        if (!this.toolTips.contains(toolTip)) {
            this.toolTips.add(toolTip);
        }
    }

    public boolean removeToolTip(GuiToolTip toolTip) {
        return this.toolTips.remove(toolTip);
    }

    protected final void drawTooltips(ToolTipRenderer renderer, int mouseX, int mouseY) {
        for (GuiToolTip toolTip : this.toolTips) {
            toolTip.onTick(mouseX - renderer.getGuiLeft(), mouseY - renderer.getGuiTop());
            if (!toolTip.shouldDraw()) continue;
            this.drawTooltip(toolTip, mouseX, mouseY, renderer);
        }
    }

    protected void drawTooltip(GuiToolTip toolTip, int mouseX, int mouseY, ToolTipRenderer renderer) {
        List<String> list = toolTip.getToolTipText();
        if (list == null) {
            return;
        }
        ArrayList<String> formatted = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                formatted.add("\u00a7f" + list.get(i));
                continue;
            }
            formatted.add("\u00a77" + list.get(i));
        }
        if (mouseX > renderer.getGuiLeft() + renderer.getXSize() / 2) {
            int maxWidth = 0;
            for (String s : formatted) {
                int w = renderer.getFontRenderer().func_78256_a(s);
                if (w <= maxWidth) continue;
                maxWidth = w;
            }
            mouseX -= maxWidth + 18;
        }
        renderer.drawHoveringText(formatted, mouseX, mouseY, renderer.getFontRenderer());
    }

    public static interface ToolTipRenderer {
        public int getGuiLeft();

        public int getGuiTop();

        public int getXSize();

        public FontRenderer getFontRenderer();

        public void drawHoveringText(List<String> var1, int var2, int var3, FontRenderer var4);
    }
}

