/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.chunkblock;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.malisis.core.MalisisCore;
import net.malisis.core.network.MalisisMessage;
import net.malisis.core.util.chunkblock.ChunkBlockHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.chunk.Chunk;

@MalisisMessage
public class ChunkBlockMessage
implements IMessageHandler<Packet, IMessage> {
    public ChunkBlockMessage() {
        MalisisCore.network.registerMessage(this, Packet.class, Side.CLIENT);
    }

    public IMessage onMessage(Packet message, MessageContext ctx) {
        if (ctx.side != Side.CLIENT) {
            return null;
        }
        ChunkBlockHandler.get().setCoords(message.x, message.z, message.coords);
        return null;
    }

    public static void sendCoords(Chunk chunk, long[] coords, EntityPlayerMP player) {
        MalisisCore.network.sendTo(new Packet(chunk, coords), player);
    }

    public static class Packet
    implements IMessage {
        private int x;
        private int z;
        private long[] coords;

        public Packet() {
        }

        public Packet(Chunk chunk, long[] coords) {
            this.x = chunk.field_76635_g;
            this.z = chunk.field_76647_h;
            this.coords = coords;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readInt();
            this.z = buf.readInt();
            this.coords = new long[buf.readInt()];
            for (int i = 0; i < this.coords.length; ++i) {
                this.coords[i] = buf.readLong();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.z);
            buf.writeInt(this.coords.length);
            for (long c : this.coords) {
                buf.writeLong(c);
            }
        }
    }
}

