/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.bbcode.node;

import net.malisis.core.util.bbcode.node.BBNode;
import net.malisis.core.util.bbcode.render.BBRenderElement;
import net.minecraft.util.EnumChatFormatting;

public class BBStyleNode
extends BBNode {
    protected EnumChatFormatting ecf;

    public BBStyleNode(String tag) {
        super(tag);
        switch (tag) {
            case "b": {
                this.ecf = EnumChatFormatting.BOLD;
                break;
            }
            case "i": {
                this.ecf = EnumChatFormatting.ITALIC;
                break;
            }
            case "u": {
                this.ecf = EnumChatFormatting.UNDERLINE;
                break;
            }
            case "s": {
                this.ecf = EnumChatFormatting.STRIKETHROUGH;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tag for BBStyleNode : " + tag);
            }
        }
    }

    public EnumChatFormatting getEcf() {
        return this.ecf;
    }

    public String toFormattedString() {
        return this.ecf.toString();
    }

    @Override
    public BBStyleNode copy() {
        return new BBStyleNode(this.tag);
    }

    @Override
    public void clean() {
        BBStyleNode node = this.getChildStyleNode(this.tag);
        if (node != null && node.getParent() != null) {
            for (BBNode n : node) {
                node.getParent().insertBefore(n, node);
            }
            node.getParent().remove(node);
        }
        super.clean();
    }

    @Override
    public void apply(BBRenderElement element) {
        element.styles.add(this.ecf);
    }
}

