/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.ghast;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.SpecialMobData;
import toast.specialMobs.entity.ghast.EntityBabyGhast;
import toast.specialMobs.entity.ghast.Entity_SpecialGhast;

public class EntityQueenGhast
extends Entity_SpecialGhast {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "ghast/queen.png"), new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "ghast/queen_shooting.png")};
    public byte babyCount;
    private byte babies;

    public EntityQueenGhast(World world) {
        super(world);
        this.func_70105_a(5.0f, 5.0f);
        this.getSpecialData().setTextures(TEXTURES);
        this.getSpecialData().resetRenderScale(1.25f);
        this.field_70728_aV += 2;
        this.babyCount = (byte)(this.field_70146_Z.nextInt(7) + 4);
        this.babies = (byte)(3 + this.field_70146_Z.nextInt(4));
    }

    @Override
    protected void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 30.0);
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111264_e, 4.0);
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 0.3);
        this.getSpecialData().setHealTime(20);
        this.getSpecialData().armor = (byte)(this.getSpecialData().armor + 6);
    }

    @Override
    public void shootFireballAtEntity(Entity target) {
        if (this.babyCount > 0 && this.field_70146_Z.nextInt(3) != 0) {
            this.babyCount = (byte)(this.babyCount - 1);
            EntityBabyGhast baby = new EntityBabyGhast(this.field_70170_p);
            baby.func_82149_j((Entity)this);
            baby.field_70792_g = this.field_70792_g;
            baby.func_110161_a(null);
            this.field_70170_p.func_72838_d((Entity)baby);
            this.field_70170_p.func_72956_a((Entity)baby, "random.pop", 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        } else {
            super.shootFireballAtEntity(target);
        }
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        int i = this.field_70146_Z.nextInt(2 + looting);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151043_k, 1);
        }
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151166_bC, 1);
        }
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_70099_a(new ItemStack(Items.field_151063_bx, 1, EntityList.func_75619_a((Entity)new EntityGhast(this.field_70170_p))), 0.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityBabyGhast baby = null;
            int i2 = this.babies;
            while (i2-- > 0) {
                baby = new EntityBabyGhast(this.field_70170_p);
                baby.func_82149_j((Entity)this);
                baby.field_70792_g = this.field_70792_g;
                baby.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)baby);
            }
            if (baby != null) {
                this.field_70170_p.func_72956_a((Entity)baby, "random.pop", 1.0f, 2.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
                baby.func_70656_aK();
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74774_a("BabyCount", this.babyCount);
        saveTag.func_74774_a("Babies", this.babies);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_74764_b("BabyCount")) {
            this.babyCount = saveTag.func_74771_c("BabyCount");
        } else if (tag.func_74764_b("BabyCount")) {
            this.babyCount = tag.func_74771_c("BabyCount");
        }
        if (saveTag.func_74764_b("Babies")) {
            this.babies = saveTag.func_74771_c("Babies");
        } else if (tag.func_74764_b("Babies")) {
            this.babies = tag.func_74771_c("Babies");
        }
    }
}

