/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import tconstruct.util.config.PHConstruct;

public class SurfaceOreGen
extends WorldGenerator {
    private final Block minableBlock;
    private int minableBlockMeta;
    private final int numberOfBlocks;
    private final Block[] replaceBlocks;
    private final boolean alterSize;

    public SurfaceOreGen(Block b, int meta, int number, boolean changeSize) {
        this(b, meta, number, changeSize, new Block[]{Blocks.field_150348_b, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150355_j, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150433_aE});
    }

    public SurfaceOreGen(Block b, int meta, int number, boolean changeSize, Block ... target) {
        this.minableBlock = b;
        this.numberOfBlocks = number;
        this.replaceBlocks = target;
        this.alterSize = changeSize;
        this.minableBlockMeta = meta;
    }

    int findGround(World world, int x, int y, int z) {
        int returnHeight = -1;
        Block block = world.func_147439_a(x, y - 1, z);
        if (!(world.func_147439_a(x, y, z).func_149662_c() || block != Blocks.field_150346_d && block != Blocks.field_150349_c)) {
            return y;
        }
        int height = PHConstruct.seaLevel + 64;
        while (height >= PHConstruct.seaLevel - 30) {
            Block b = world.func_147439_a(x, height, z);
            if (b == Blocks.field_150346_d || b == Blocks.field_150349_c) {
                if (world.func_147439_a(x, height + 1, z).func_149662_c()) break;
                returnHeight = height + 1;
                break;
            }
            if (--height > 0) continue;
        }
        return returnHeight;
    }

    public boolean func_76484_a(World world, Random random, int startX, int startY, int startZ) {
        if (this.alterSize && (startY = this.findGround(world, startX, startY, startZ)) == -1) {
            return false;
        }
        float f = random.nextFloat() * (float)Math.PI;
        int blockNumber = this.numberOfBlocks;
        if (this.alterSize) {
            blockNumber = this.numberOfBlocks * 2 / 5 + random.nextInt(this.numberOfBlocks * 3 / 5);
        }
        double d0 = (float)(startX + 8) + MathHelper.func_76126_a((float)f) * (float)blockNumber / 8.0f;
        double d1 = (float)(startX + 8) - MathHelper.func_76126_a((float)f) * (float)blockNumber / 8.0f;
        double d2 = (float)(startZ + 8) + MathHelper.func_76134_b((float)f) * (float)blockNumber / 8.0f;
        double d3 = (float)(startZ + 8) - MathHelper.func_76134_b((float)f) * (float)blockNumber / 8.0f;
        double d4 = startY + random.nextInt(3) - 2;
        double d5 = startY + random.nextInt(3) - 2;
        for (int l = 0; l <= blockNumber; ++l) {
            double d6 = d0 + (d1 - d0) * (double)l / (double)blockNumber;
            double d7 = d4 + (d5 - d4) * (double)l / (double)blockNumber;
            double d8 = d2 + (d3 - d2) * (double)l / (double)blockNumber;
            double d9 = random.nextDouble() * (double)blockNumber / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)blockNumber)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)blockNumber)) + 1.0f) * d9 + 1.0;
            int i1 = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int l1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int i2 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int j2 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int k2 = i1; k2 <= l1; ++k2) {
                double d12 = ((double)k2 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int l2 = j1; l2 <= i2; ++l2) {
                    double d13 = ((double)l2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    block3: for (int i3 = k1; i3 <= j2; ++i3) {
                        double d14 = ((double)i3 + 0.5 - d8) / (d10 / 2.0);
                        Block block = world.func_147439_a(k2, l2, i3);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0)) continue;
                        if (block == null || !world.func_147439_a(k2, l2, i3).func_149662_c()) {
                            world.func_147465_d(k2, l2, i3, this.minableBlock, this.minableBlockMeta, 2);
                            continue;
                        }
                        for (Block replaceBlock : this.replaceBlocks) {
                            if (!world.func_147439_a(k2, l2, i3).isReplaceableOreGen(world, k2, l2, i3, replaceBlock)) continue;
                            world.func_147465_d(k2, l2, i3, this.minableBlock, this.minableBlockMeta, 2);
                            continue block3;
                        }
                    }
                }
            }
        }
        return true;
    }
}

